/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.hyperledger.fabric.shim.ChaincodeBase;
import org.hyperledger.fabric.shim.ChaincodeServerProperties;
import org.hyperledger.fabric.shim.ChatChaincodeWithPeer;
import org.hyperledger.fabric.shim.GrpcServer;

public final class NettyGrpcServer
implements GrpcServer {
    private static final Logger LOGGER = Logger.getLogger(NettyGrpcServer.class.getName());
    private final Server server;

    public NettyGrpcServer(ChaincodeBase chaincodeBase, ChaincodeServerProperties chaincodeServerProperties) throws IOException {
        if (chaincodeBase == null) {
            throw new IllegalArgumentException("chaincode must be specified");
        }
        if (chaincodeServerProperties == null) {
            throw new IllegalArgumentException("chaincodeServerProperties must be specified");
        }
        chaincodeServerProperties.validate();
        NettyServerBuilder serverBuilder = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)chaincodeServerProperties.getServerAddress()).addService((BindableService)new ChatChaincodeWithPeer(chaincodeBase))).keepAliveTime((long)chaincodeServerProperties.getKeepAliveTimeMinutes(), TimeUnit.MINUTES).keepAliveTimeout((long)chaincodeServerProperties.getKeepAliveTimeoutSeconds(), TimeUnit.SECONDS).permitKeepAliveTime((long)chaincodeServerProperties.getPermitKeepAliveTimeMinutes(), TimeUnit.MINUTES).permitKeepAliveWithoutCalls(chaincodeServerProperties.isPermitKeepAliveWithoutCalls()).maxConnectionAge((long)chaincodeServerProperties.getMaxConnectionAgeSeconds(), TimeUnit.SECONDS).maxInboundMetadataSize(chaincodeServerProperties.getMaxInboundMetadataSize()).maxInboundMessageSize(chaincodeServerProperties.getMaxInboundMessageSize());
        if (chaincodeServerProperties.isTlsEnabled()) {
            NettyGrpcServer.configureTls(serverBuilder, chaincodeServerProperties);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("<<<<<<<<<<<<<chaincodeServerProperties>>>>>>>>>>>>:\n");
            LOGGER.info("ServerAddress:" + chaincodeServerProperties.getServerAddress().toString());
            LOGGER.info("MaxInboundMetadataSize:" + chaincodeServerProperties.getMaxInboundMetadataSize());
            LOGGER.info("MaxInboundMessageSize:" + chaincodeServerProperties.getMaxInboundMessageSize());
            LOGGER.info("MaxConnectionAgeSeconds:" + chaincodeServerProperties.getMaxConnectionAgeSeconds());
            LOGGER.info("KeepAliveTimeoutSeconds:" + chaincodeServerProperties.getKeepAliveTimeoutSeconds());
            LOGGER.info("PermitKeepAliveTimeMinutes:" + chaincodeServerProperties.getPermitKeepAliveTimeMinutes());
            LOGGER.info("KeepAliveTimeMinutes:" + chaincodeServerProperties.getKeepAliveTimeMinutes());
            LOGGER.info("PermitKeepAliveWithoutCalls:" + chaincodeServerProperties.getPermitKeepAliveWithoutCalls());
            LOGGER.info("KeyPassword:" + chaincodeServerProperties.getKeyPassword());
            LOGGER.info("KeyCertChainFile:" + chaincodeServerProperties.getKeyCertChainFile());
            LOGGER.info("KeyFile:" + chaincodeServerProperties.getKeyFile());
            LOGGER.info("isTlsEnabled:" + chaincodeServerProperties.isTlsEnabled());
            LOGGER.info("\n");
        }
        this.server = serverBuilder.build();
    }

    private static void configureTls(NettyServerBuilder serverBuilder, ChaincodeServerProperties chaincodeServerProperties) throws SSLException {
        File keyCertChainFile = Paths.get(chaincodeServerProperties.getKeyCertChainFile(), new String[0]).toFile();
        File keyFile = Paths.get(chaincodeServerProperties.getKeyFile(), new String[0]).toFile();
        SslContextBuilder sslContextBuilder = chaincodeServerProperties.getKeyPassword() == null || chaincodeServerProperties.getKeyPassword().isEmpty() ? SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile) : SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)chaincodeServerProperties.getKeyPassword());
        ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"});
        sslContextBuilder.applicationProtocolConfig(apn);
        if (chaincodeServerProperties.getTrustCertCollectionFile() != null) {
            File trustCertCollectionFile = Paths.get(chaincodeServerProperties.getTrustCertCollectionFile(), new String[0]).toFile();
            sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
            sslContextBuilder.trustManager(trustCertCollectionFile);
        }
        serverBuilder.sslContext(sslContextBuilder.build());
    }

    @Override
    public void start() throws IOException {
        LOGGER.info("start grpc server");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            this.stop();
            System.err.println("*** server shut down");
        }));
        this.server.start();
    }

    @Override
    public void blockUntilShutdown() throws InterruptedException {
        LOGGER.info("Waits for the server to become terminated.");
        this.server.awaitTermination();
    }

    @Override
    public void stop() {
        LOGGER.info("shutdown now grpc server.");
        this.server.shutdownNow();
    }
}

