/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hyperledger.fabric.protos.peer.ChaincodeEvent;
import org.hyperledger.fabric.protos.peer.SignedProposal;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ledger.CompositeKey;
import org.hyperledger.fabric.shim.ledger.KeyModification;
import org.hyperledger.fabric.shim.ledger.KeyValue;
import org.hyperledger.fabric.shim.ledger.QueryResultsIterator;
import org.hyperledger.fabric.shim.ledger.QueryResultsIteratorWithMetadata;

public interface ChaincodeStub {
    public List<byte[]> getArgs();

    public List<String> getStringArgs();

    public String getFunction();

    public List<String> getParameters();

    public String getTxId();

    public String getChannelId();

    public Chaincode.Response invokeChaincode(String var1, List<byte[]> var2, String var3);

    public byte[] getState(String var1);

    public byte[] getStateValidationParameter(String var1);

    public void putState(String var1, byte[] var2);

    public void setStateValidationParameter(String var1, byte[] var2);

    public void delState(String var1);

    public QueryResultsIterator<KeyValue> getStateByRange(String var1, String var2);

    public QueryResultsIteratorWithMetadata<KeyValue> getStateByRangeWithPagination(String var1, String var2, int var3, String var4);

    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(String var1);

    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(String var1, String ... var2);

    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(CompositeKey var1);

    public QueryResultsIteratorWithMetadata<KeyValue> getStateByPartialCompositeKeyWithPagination(CompositeKey var1, int var2, String var3);

    public CompositeKey createCompositeKey(String var1, String ... var2);

    public CompositeKey splitCompositeKey(String var1);

    public QueryResultsIterator<KeyValue> getQueryResult(String var1);

    public QueryResultsIteratorWithMetadata<KeyValue> getQueryResultWithPagination(String var1, int var2, String var3);

    public QueryResultsIterator<KeyModification> getHistoryForKey(String var1);

    public byte[] getPrivateData(String var1, String var2);

    public byte[] getPrivateDataHash(String var1, String var2);

    public byte[] getPrivateDataValidationParameter(String var1, String var2);

    public void putPrivateData(String var1, String var2, byte[] var3);

    public void setPrivateDataValidationParameter(String var1, String var2, byte[] var3);

    public void delPrivateData(String var1, String var2);

    public void purgePrivateData(String var1, String var2);

    public QueryResultsIterator<KeyValue> getPrivateDataByRange(String var1, String var2, String var3);

    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String var1, String var2);

    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String var1, CompositeKey var2);

    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String var1, String var2, String ... var3);

    public QueryResultsIterator<KeyValue> getPrivateDataQueryResult(String var1, String var2);

    public void setEvent(String var1, byte[] var2);

    default public Chaincode.Response invokeChaincode(String chaincodeName, List<byte[]> args) {
        return this.invokeChaincode(chaincodeName, args, null);
    }

    default public Chaincode.Response invokeChaincodeWithStringArgs(String chaincodeName, List<String> args, String channel) {
        return this.invokeChaincode(chaincodeName, args.stream().map(x -> x.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList()), channel);
    }

    default public Chaincode.Response invokeChaincodeWithStringArgs(String chaincodeName, List<String> args) {
        return this.invokeChaincodeWithStringArgs(chaincodeName, args, null);
    }

    default public Chaincode.Response invokeChaincodeWithStringArgs(String chaincodeName, String ... args) {
        return this.invokeChaincodeWithStringArgs(chaincodeName, Arrays.asList(args), null);
    }

    default public String getStringState(String key) {
        return new String(this.getState(key), StandardCharsets.UTF_8);
    }

    default public void putPrivateData(String collection, String key, String value) {
        this.putPrivateData(collection, key, value.getBytes(StandardCharsets.UTF_8));
    }

    default public String getPrivateDataUTF8(String collection, String key) {
        return new String(this.getPrivateData(collection, key), StandardCharsets.UTF_8);
    }

    default public void putStringState(String key, String value) {
        this.putState(key, value.getBytes(StandardCharsets.UTF_8));
    }

    public ChaincodeEvent getEvent();

    public SignedProposal getSignedProposal();

    public Instant getTxTimestamp();

    public byte[] getCreator();

    public Map<String, byte[]> getTransient();

    public byte[] getBinding();

    public String getMspId();
}

