/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogManager;

public final class Logging {
    public static final String PERFLOGGER = "org.hyperledger.Performance";

    private Logging() {
    }

    public static String formatError(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter buffer = new StringWriter();
        buffer.append(throwable.getMessage()).append(System.lineSeparator());
        throwable.printStackTrace(new PrintWriter(buffer));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            buffer.append(".. caused by ..").append(System.lineSeparator());
            buffer.append(Logging.formatError(cause));
        }
        return buffer.toString();
    }

    public static void setLogLevel(String newLevel) {
        Level l = Logging.mapLevel(newLevel);
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> allLoggers = Collections.list(logManager.getLoggerNames());
        allLoggers.add("org.hyperledger");
        allLoggers.stream().filter(name -> name.startsWith("org.hyperledger")).map(logManager::getLogger).forEach(logger -> {
            if (logger != null) {
                logger.setLevel(l);
            }
        });
    }

    private static Level mapLevel(String level) {
        if (level != null) {
            switch (level.toUpperCase(Locale.getDefault()).trim()) {
                case "ERROR": 
                case "CRITICAL": {
                    return Level.SEVERE;
                }
                case "WARNING": 
                case "WARN": {
                    return Level.WARNING;
                }
                case "INFO": {
                    return Level.INFO;
                }
                case "NOTICE": {
                    return Level.CONFIG;
                }
                case "DEBUG": {
                    return Level.FINEST;
                }
            }
            return Level.INFO;
        }
        return Level.INFO;
    }
}

