/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.traces.impl;

import io.grpc.ClientInterceptor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTracing;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Properties;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.hyperledger.fabric.traces.TracesProvider;
import org.hyperledger.fabric.traces.impl.OpenTelemetryProperties;

public final class OpenTelemetryTracesProvider
implements TracesProvider {
    private static final String TX_ID = "transaction_id";
    private static final String CHANNEL_ID = "channel_id";
    private static final String CORE_CHAINCODE_ID_NAME = "CORE_CHAINCODE_ID_NAME";
    private Tracer tracer;
    private GrpcTracing grpcTracer;

    @Override
    public void initialize(Properties props) {
        String serviceName = props.getProperty(CORE_CHAINCODE_ID_NAME, "unknown");
        props.setProperty(ResourceAttributes.SERVICE_NAME.getKey(), serviceName);
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdkAutoConfiguration.initialize((boolean)false, (ConfigProperties)new OpenTelemetryProperties(System.getenv(), System.getProperties(), props));
        this.tracer = openTelemetry.getTracerProvider().get("org.hyperledger.traces");
        this.grpcTracer = GrpcTracing.newBuilder((OpenTelemetry)openTelemetry).build();
    }

    @Override
    public Span createSpan(ChaincodeStub stub) {
        Context parentContext = Context.current();
        return this.tracer.spanBuilder(stub.getFunction()).setSpanKind(SpanKind.INTERNAL).setAttribute(TX_ID, stub.getTxId()).setAttribute(CHANNEL_ID, stub.getChannelId()).setParent(parentContext).startSpan();
    }

    @Override
    public ClientInterceptor createInterceptor() {
        return this.grpcTracer.newClientInterceptor();
    }
}

