/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.hyperledger.fabric.protos.peer.ChaincodeMessage;
import org.hyperledger.fabric.protos.peer.QueryResponse;
import org.hyperledger.fabric.protos.peer.QueryResultBytes;
import org.hyperledger.fabric.protos.peer.QueryStateClose;
import org.hyperledger.fabric.protos.peer.QueryStateNext;
import org.hyperledger.fabric.shim.impl.ChaincodeInvocationTask;
import org.hyperledger.fabric.shim.impl.ChaincodeMessageFactory;
import org.hyperledger.fabric.shim.ledger.QueryResultsIterator;

class QueryResultsIteratorImpl<T>
implements QueryResultsIterator<T> {
    private final ChaincodeInvocationTask handler;
    private final String channelId;
    private final String txId;
    private Iterator<QueryResultBytes> currentIterator;
    private QueryResponse currentQueryResponse;
    private Function<QueryResultBytes, T> mapper;

    QueryResultsIteratorImpl(ChaincodeInvocationTask handler, String channelId, String txId, ByteString responseBuffer, Function<QueryResultBytes, T> mapper) {
        try {
            this.handler = handler;
            this.channelId = channelId;
            this.txId = txId;
            this.currentQueryResponse = QueryResponse.parseFrom((ByteString)responseBuffer);
            this.currentIterator = this.currentQueryResponse.getResultsList().iterator();
            this.mapper = mapper;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return QueryResultsIteratorImpl.this.currentIterator.hasNext() || QueryResultsIteratorImpl.this.currentQueryResponse.getHasMore();
            }

            @Override
            public T next() {
                if (QueryResultsIteratorImpl.this.currentIterator.hasNext()) {
                    return QueryResultsIteratorImpl.this.mapper.apply((QueryResultBytes)QueryResultsIteratorImpl.this.currentIterator.next());
                }
                if (!QueryResultsIteratorImpl.this.currentQueryResponse.getHasMore()) {
                    throw new NoSuchElementException();
                }
                ByteString requestPayload = QueryStateNext.newBuilder().setId(QueryResultsIteratorImpl.this.currentQueryResponse.getId()).build().toByteString();
                ChaincodeMessage requestNextMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.QUERY_STATE_NEXT, QueryResultsIteratorImpl.this.channelId, QueryResultsIteratorImpl.this.txId, requestPayload);
                ByteString responseMessage = QueryResultsIteratorImpl.this.handler.invoke(requestNextMessage);
                try {
                    QueryResultsIteratorImpl.this.currentQueryResponse = QueryResponse.parseFrom((ByteString)responseMessage);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                QueryResultsIteratorImpl.this.currentIterator = QueryResultsIteratorImpl.this.currentQueryResponse.getResultsList().iterator();
                return QueryResultsIteratorImpl.this.mapper.apply((QueryResultBytes)QueryResultsIteratorImpl.this.currentIterator.next());
            }
        };
    }

    @Override
    public void close() throws Exception {
        ByteString requestPayload = QueryStateClose.newBuilder().setId(this.currentQueryResponse.getId()).build().toByteString();
        ChaincodeMessage requestNextMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.QUERY_STATE_CLOSE, this.channelId, this.txId, requestPayload);
        this.handler.invoke(requestNextMessage);
        this.currentIterator = Collections.emptyIterator();
        this.currentQueryResponse = QueryResponse.newBuilder().setHasMore(false).build();
    }
}

