/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.metrics.impl;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.hyperledger.fabric.metrics.MetricsProvider;
import org.hyperledger.fabric.metrics.TaskMetricsCollector;

public final class DefaultProvider
implements MetricsProvider {
    private static Logger perflogger = Logger.getLogger("org.hyperledger.Performance");
    private TaskMetricsCollector taskService;
    private static final int TIME_INTERVAL = 5000;

    public DefaultProvider() {
        perflogger.info("Default Metrics Provider started");
    }

    @Override
    public void setTaskMetricsCollector(TaskMetricsCollector taskService) {
        this.taskService = taskService;
    }

    @Override
    public void initialize(Properties props) {
        Timer metricTimer = new Timer(true);
        metricTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DefaultProvider.this.logMetrics();
            }
        }, 0L, 5000L);
    }

    protected void logMetrics() {
        perflogger.info(() -> {
            if (this.taskService == null) {
                return "No Metrics Provider service yet";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            sb.append(String.format(" \"active_count\":%d ", this.taskService.getActiveCount())).append(',');
            sb.append(String.format(" \"pool_size\":%d ", this.taskService.getPoolSize())).append(',');
            sb.append(String.format(" \"core_pool_size\":%d ", this.taskService.getCorePoolSize())).append(',');
            sb.append(String.format(" \"current_task_count\":%d ", this.taskService.getCurrentTaskCount())).append(',');
            sb.append(String.format(" \"current_queue_depth\":%d ", this.taskService.getCurrentQueueCount()));
            return sb.append('}').toString();
        });
    }
}

