/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.Context;
import org.hyperledger.fabric.contract.ContractInterface;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Property;
import org.hyperledger.fabric.contract.annotation.Transaction;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.ContractDefinition;
import org.hyperledger.fabric.contract.routing.ParameterDefinition;
import org.hyperledger.fabric.contract.routing.TransactionType;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.impl.ParameterDefinitionImpl;

public final class TxFunctionImpl
implements TxFunction {
    private static Logger logger = Logger.getLogger(TxFunctionImpl.class);
    private final Method method;
    private String name;
    private TransactionType type;
    private final TxFunction.Routing routing;
    private TypeSchema returnSchema;
    private List<ParameterDefinition> paramsList = new ArrayList<ParameterDefinition>();
    private boolean isUnknownTx;

    public TxFunctionImpl(Method m, ContractDefinition contract) {
        this.method = m;
        if (m.getAnnotation(Transaction.class) != null) {
            logger.debug("Found Transaction method: " + m.getName());
            this.type = m.getAnnotation(Transaction.class).submit() ? TransactionType.INVOKE : TransactionType.QUERY;
            String txnName = m.getAnnotation(Transaction.class).name();
            if (!txnName.isEmpty()) {
                this.name = txnName;
            }
        }
        if (this.name == null) {
            this.name = m.getName();
        }
        this.routing = new RoutingImpl(m, contract);
        this.returnSchema = TypeSchema.typeConvert(m.getReturnType());
        ArrayList<Parameter> params = new ArrayList<Parameter>(Arrays.asList(this.method.getParameters()));
        if (!Context.class.isAssignableFrom(((Parameter)params.get(0)).getType())) {
            throw new ContractRuntimeException("First argument should be of type Context " + this.method.getName() + " " + ((Parameter)params.get(0)).getType());
        }
        params.remove(0);
        for (Parameter parameter : params) {
            TypeSchema paramMap = new TypeSchema();
            TypeSchema schema = TypeSchema.typeConvert(parameter.getType());
            Property annotation = parameter.getAnnotation(Property.class);
            if (annotation != null) {
                String[] userSupplied = annotation.schema();
                for (int i = 0; i < userSupplied.length; i += 2) {
                    schema.put(userSupplied[i], userSupplied[i + 1]);
                }
            }
            paramMap.put("name", parameter.getName());
            paramMap.put("schema", schema);
            ParameterDefinitionImpl pd = new ParameterDefinitionImpl(parameter.getName(), parameter.getClass(), paramMap, parameter);
            this.paramsList.add(pd);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TxFunction.Routing getRouting() {
        return this.routing;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Parameter[] getParameters() {
        return this.method.getParameters();
    }

    @Override
    public TransactionType getType() {
        return this.type;
    }

    public String toString() {
        return this.name + " @" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public void setReturnSchema(TypeSchema returnSchema) {
        this.returnSchema = returnSchema;
    }

    @Override
    public List<ParameterDefinition> getParamsList() {
        return this.paramsList;
    }

    public void setParamsList(ArrayList<ParameterDefinition> paramsList) {
        this.paramsList = paramsList;
    }

    @Override
    public TypeSchema getReturnSchema() {
        return this.returnSchema;
    }

    @Override
    public void setParameterDefinitions(List<ParameterDefinition> list) {
        this.paramsList = list;
    }

    @Override
    public boolean isUnknownTx() {
        return this.isUnknownTx;
    }

    @Override
    public void setUnknownTx(boolean unknown) {
        this.isUnknownTx = unknown;
    }

    public final class RoutingImpl
    implements TxFunction.Routing {
        private final Method method;
        private final Class<? extends ContractInterface> clazz;
        private final String serializerName;

        public RoutingImpl(Method method, ContractDefinition contract) {
            this.method = method;
            this.clazz = contract.getContractImpl();
            this.serializerName = contract.getAnnotation().transactionSerializer();
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Class<? extends ContractInterface> getContractClass() {
            return this.clazz;
        }

        @Override
        public ContractInterface getContractInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
            return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }

        public String toString() {
            return this.method.getName() + ":" + this.clazz.getCanonicalName();
        }

        @Override
        public String getSerializerName() {
            return this.serializerName;
        }
    }
}

