/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.hyperledger.fabric.shim.ChaincodeStub;

public interface Chaincode {
    public Response init(ChaincodeStub var1);

    public Response invoke(ChaincodeStub var1);

    public static class Response {
        private final int statusCode;
        private final String message;
        private final byte[] payload;

        public Response(Status status, String message, byte[] payload) {
            this.statusCode = status.getCode();
            this.message = message;
            this.payload = payload;
        }

        public Response(int statusCode, String message, byte[] payload) {
            this.statusCode = statusCode;
            this.message = message;
            this.payload = payload;
        }

        public Status getStatus() {
            if (Status.hasStatusForCode(this.statusCode)) {
                return Status.forCode(this.statusCode);
            }
            return null;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public String getStringPayload() {
            return this.payload == null ? null : new String(this.payload, StandardCharsets.UTF_8);
        }

        public static enum Status {
            SUCCESS(200),
            ERROR_THRESHOLD(400),
            INTERNAL_SERVER_ERROR(500);

            private static final Map<Integer, Status> CODETOSTATUS;
            private final int code;

            private Status(int code) {
                this.code = code;
            }

            public int getCode() {
                return this.code;
            }

            public static Status forCode(int code) {
                Status result = CODETOSTATUS.get(code);
                if (result == null) {
                    throw new IllegalArgumentException("no status for code " + code);
                }
                return result;
            }

            public static boolean hasStatusForCode(int code) {
                return CODETOSTATUS.containsKey(code);
            }

            static {
                CODETOSTATUS = new HashMap<Integer, Status>();
                for (Status status : Status.values()) {
                    CODETOSTATUS.put(status.code, status);
                }
            }
        }
    }
}

