/*****************************************************
 * WARNING: this file was generated by -e
 * on Mon Jul 20 16:59:28 2009.
 * Any changes made here will be LOST.
 *****************************************************/
package org.hyperic.sigar;

import java.util.HashMap;
import java.util.Map;

/**
 * Cpu sigar class.
 */
public class Cpu implements java.io.Serializable {

    private static final long serialVersionUID = 8076L;

    public Cpu() { }

    public native void gather(Sigar sigar) throws SigarException;

    /**
     * This method is not intended to be called directly.
     * use Sigar.getCpu() instead.
     * @exception SigarException on failure.
     * @see org.hyperic.sigar.Sigar#getCpu
     */
    static Cpu fetch(Sigar sigar) throws SigarException {
        Cpu cpu = new Cpu();
        cpu.gather(sigar);
        return cpu;
    }

    long user = 0;

    /**
     * Get the Total system cpu user time.<p>
     * Supported Platforms: All.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu user time
     */
    public long getUser() { return user; }
    long sys = 0;

    /**
     * Get the Total system cpu kernel time.<p>
     * Supported Platforms: All.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu kernel time
     */
    public long getSys() { return sys; }
    long nice = 0;

    /**
     * Get the Total system cpu nice time.<p>
     * Supported Platforms: Darwin, FreeBSD, HPUX, Linux.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu nice time
     */
    public long getNice() { return nice; }
    long idle = 0;

    /**
     * Get the Total system cpu idle time.<p>
     * Supported Platforms: All.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu idle time
     */
    public long getIdle() { return idle; }
    long wait = 0;

    /**
     * Get the Total system cpu io wait time.<p>
     * Supported Platforms: AIX, Linux, HPUX, Solaris.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu io wait time
     */
    public long getWait() { return wait; }
    long irq = 0;

    /**
     * Get the Total system cpu time servicing interrupts.<p>
     * Supported Platforms: FreeBSD, Linux, HPUX, Win32.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu time servicing interrupts
     */
    public long getIrq() { return irq; }
    long softIrq = 0;

    /**
     * Get the Total system cpu time servicing softirqs.<p>
     * Supported Platforms: Linux.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu time servicing softirqs
     */
    public long getSoftIrq() { return softIrq; }
    long stolen = 0;

    /**
     * Get the Total system cpu involuntary wait time.<p>
     * Supported Platforms: Linux.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu involuntary wait time
     */
    public long getStolen() { return stolen; }
    long total = 0;

    /**
     * Get the Total system cpu time.<p>
     * Supported Platforms: All.
     * <p>
     * System equivalent commands:<ul>
     * <li> AIX: <code>top</code><br>
     * <li> Darwin: <code>top</code><br>
     * <li> FreeBSD: <code>top</code><br>
     * <li> HPUX: <code>top</code><br>
     * <li> Linux: <code>top</code><br>
     * <li> Solaris: <code>top</code><br>
     * <li> Win32: <code>taskman</code><br>
     * </ul>
     * @return Total system cpu time
     */
    public long getTotal() { return total; }

    void copyTo(Cpu copy) {
        copy.user = this.user;
        copy.sys = this.sys;
        copy.nice = this.nice;
        copy.idle = this.idle;
        copy.wait = this.wait;
        copy.irq = this.irq;
        copy.softIrq = this.softIrq;
        copy.stolen = this.stolen;
        copy.total = this.total;
    }

    public Map toMap() {
        Map map = new HashMap();
        String struser = 
            String.valueOf(this.user);
        if (!"-1".equals(struser))
            map.put("User", struser);
        String strsys = 
            String.valueOf(this.sys);
        if (!"-1".equals(strsys))
            map.put("Sys", strsys);
        String strnice = 
            String.valueOf(this.nice);
        if (!"-1".equals(strnice))
            map.put("Nice", strnice);
        String stridle = 
            String.valueOf(this.idle);
        if (!"-1".equals(stridle))
            map.put("Idle", stridle);
        String strwait = 
            String.valueOf(this.wait);
        if (!"-1".equals(strwait))
            map.put("Wait", strwait);
        String strirq = 
            String.valueOf(this.irq);
        if (!"-1".equals(strirq))
            map.put("Irq", strirq);
        String strsoftIrq = 
            String.valueOf(this.softIrq);
        if (!"-1".equals(strsoftIrq))
            map.put("SoftIrq", strsoftIrq);
        String strstolen = 
            String.valueOf(this.stolen);
        if (!"-1".equals(strstolen))
            map.put("Stolen", strstolen);
        String strtotal = 
            String.valueOf(this.total);
        if (!"-1".equals(strtotal))
            map.put("Total", strtotal);
        return map;
    }

    public String toString() {
        return toMap().toString();
    }

}
