/*
 * Decompiled with CFR 0.152.
 */
package org.hybridsquad.android.library;

import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import org.hybridsquad.android.library.CompressImageUtils;
import org.hybridsquad.android.library.CropFileUtils;
import org.hybridsquad.android.library.CropHandler;
import org.hybridsquad.android.library.CropParams;

public class CropHelper {
    public static final String TAG = "CropHelper";
    public static final int REQUEST_CROP = 127;
    public static final int REQUEST_CAMERA = 128;
    public static final int REQUEST_PICK = 129;
    public static final String CROP_CACHE_FOLDER = "PhotoCropper";

    public static Uri generateUri() {
        File cacheFolder = new File(Environment.getExternalStorageDirectory() + File.separator + CROP_CACHE_FOLDER);
        if (!cacheFolder.exists()) {
            try {
                boolean result = cacheFolder.mkdir();
                Log.d((String)TAG, (String)("generateUri " + cacheFolder + " result: " + (result ? "succeeded" : "failed")));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("generateUri failed: " + cacheFolder), (Throwable)e);
            }
        }
        String name = String.format("image-%d.jpg", System.currentTimeMillis());
        return Uri.fromFile((File)cacheFolder).buildUpon().appendPath(name).build();
    }

    public static boolean isPhotoReallyCropped(Uri uri) {
        File file = new File(uri.getPath());
        long length = file.length();
        return length > 0L;
    }

    /*
     * Unable to fully structure code
     */
    public static void handleResult(CropHandler handler, int requestCode, int resultCode, Intent data) {
        block12: {
            block11: {
                if (handler == null) {
                    return;
                }
                if (resultCode != 0) break block11;
                handler.onCancel();
                break block12;
            }
            if (resultCode != -1) break block12;
            cropParams = handler.getCropParams();
            if (cropParams == null) {
                handler.onFailed("CropHandler's params MUST NOT be null!");
                return;
            }
            switch (requestCode) {
                case 127: 
                case 129: {
                    if (CropHelper.isPhotoReallyCropped(cropParams.uri)) {
                        Log.d((String)"CropHelper", (String)"Photo cropped!");
                        CropHelper.onPhotoCropped(handler, cropParams);
                        break;
                    }
                    context = handler.getCropParams().context;
                    if (context == null) ** GOTO lbl30
                    if (data != null && data.getData() != null) {
                        path = CropFileUtils.getSmartFilePath(context, data.getData());
                        result = CropFileUtils.copyFile(path, cropParams.uri.getPath());
                        if (!result) {
                            handler.onFailed("Copy file to cached folder failed");
                            break;
                        }
                    } else {
                        handler.onFailed("Returned data is null " + data);
                        break;
lbl30:
                        // 1 sources

                        handler.onFailed("CropHandler's context MUST NOT be null!");
                    }
                }
                case 128: {
                    if (cropParams.enable) {
                        intent = CropHelper.buildCropFromUriIntent(cropParams);
                        handler.handleIntent(intent, 127);
                        break;
                    }
                    Log.d((String)"CropHelper", (String)"Photo cropped!");
                    CropHelper.onPhotoCropped(handler, cropParams);
                }
            }
        }
    }

    private static void onPhotoCropped(CropHandler handler, CropParams cropParams) {
        if (cropParams.compress) {
            Uri originUri = cropParams.uri;
            Uri compressUri = CropHelper.generateUri();
            CompressImageUtils.compressImageFile(cropParams, originUri, compressUri);
            handler.onCompressed(compressUri);
        } else {
            handler.onPhotoCropped(cropParams.uri);
        }
    }

    public static Intent buildGalleryIntent(CropParams params) {
        Intent intent = params.enable ? CropHelper.buildCropIntent("android.intent.action.GET_CONTENT", params) : new Intent("android.intent.action.GET_CONTENT").setType("image/*").putExtra("output", (Parcelable)params.uri);
        return intent;
    }

    public static Intent buildCameraIntent(CropParams params) {
        return new Intent("android.media.action.IMAGE_CAPTURE").putExtra("output", (Parcelable)params.uri);
    }

    private static Intent buildCropFromUriIntent(CropParams params) {
        return CropHelper.buildCropIntent("com.android.camera.action.CROP", params);
    }

    private static Intent buildCropIntent(String action, CropParams params) {
        return new Intent(action).setDataAndType(params.uri, params.type).putExtra("crop", "true").putExtra("scale", params.scale).putExtra("aspectX", params.aspectX).putExtra("aspectY", params.aspectY).putExtra("outputX", params.outputX).putExtra("outputY", params.outputY).putExtra("return-data", params.returnData).putExtra("outputFormat", params.outputFormat).putExtra("noFaceDetection", params.noFaceDetection).putExtra("scaleUpIfNeeded", params.scaleUpIfNeeded).putExtra("output", (Parcelable)params.uri);
    }

    public static boolean clearCacheDir() {
        File cacheFolder = new File(Environment.getExternalStorageDirectory() + File.separator + CROP_CACHE_FOLDER);
        if (cacheFolder.exists()) {
            for (File file : cacheFolder.listFiles()) {
                boolean result = file.delete();
                Log.d((String)TAG, (String)("Delete " + file.getAbsolutePath() + (result ? " succeeded" : " failed")));
            }
            return true;
        }
        return false;
    }

    public static boolean clearCachedCropFile(Uri uri) {
        if (uri == null) {
            return false;
        }
        File file = new File(uri.getPath());
        if (file.exists()) {
            boolean result = file.delete();
            Log.d((String)TAG, (String)("Delete " + file.getAbsolutePath() + (result ? " succeeded" : " failed")));
            return result;
        }
        return false;
    }
}

