/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class XNamespaceContext
implements NamespaceContext {
    Map map;
    PrefixMap prefixMap;

    public XNamespaceContext(Map uris) {
        this.map = uris;
    }

    public String getNamespaceURI(String prefix) {
        return (String)this.map.get(prefix);
    }

    private PrefixMap getPrefixMap() {
        if (this.prefixMap == null) {
            this.prefixMap = new PrefixMap(this.map);
        }
        return this.prefixMap;
    }

    public String getPrefix(String namespaceURI) {
        List<String> list = this.getPrefixMap().getPrefixes(namespaceURI);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return this.getPrefixMap().getPrefixes(namespaceURI).iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrefixMap {
        Map<String, List<String>> map = new HashMap<String, List<String>>();

        PrefixMap(Map nsMap) {
            Iterator i$ = nsMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = i$.next();
                String prefix = (String)entry.getKey();
                String ns = (String)entry.getValue();
                List<String> list = this.map.get(ns);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.map.put(ns, list);
                }
                list.add(prefix);
            }
        }

        List<String> getPrefixes(String ns) {
            List<String> list = this.map.get(ns);
            if (list == null) {
                return Collections.EMPTY_LIST;
            }
            return list;
        }
    }
}

