/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import java.io.Serializable;

public class MethodResultException
implements Serializable {
    private String exceptionName;
    private String message;
    private String stackTrace;
    private String shortStackTrace;
    private String fullStackTrace;

    public MethodResultException(String message, String shortStackTrace, String fullStackTrace) {
        this.message = message == null ? null : message.trim();
        this.trySettingData(shortStackTrace, fullStackTrace);
    }

    public String getExceptionName() {
        if (this.exceptionName == null) {
            this.trySettingData(this.shortStackTrace, this.fullStackTrace);
        }
        return this.exceptionName;
    }

    private void trySettingData(String shortStackTrace, String fullStackTrace) {
        String tmpStackTrace = shortStackTrace;
        if ((shortStackTrace == null || "".equals(shortStackTrace)) && fullStackTrace != null) {
            tmpStackTrace = fullStackTrace;
        }
        this.stackTrace = tmpStackTrace.trim();
        int index = -1;
        if (this.message == null) {
            index = this.stackTrace.indexOf("\n");
            if (index != -1) {
                this.exceptionName = this.stackTrace.substring(0, index);
                this.stackTrace = this.stackTrace.substring(index + 1, this.stackTrace.length());
            }
        } else {
            this.message = this.message.trim();
            index = this.stackTrace.indexOf(": ");
            if (index != -1) {
                this.exceptionName = this.stackTrace.substring(0, index);
                this.stackTrace = this.stackTrace.substring(index + 2, this.stackTrace.length()).replace(this.message, "");
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        if (this.stackTrace == null) {
            this.trySettingData(this.shortStackTrace, this.fullStackTrace);
        }
        return this.stackTrace;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.exceptionName).append(": ");
        if (this.message != null) {
            str.append(this.message);
        }
        str.append("\n");
        str.append(this.stackTrace);
        return str.toString();
    }
}

