/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.parser;

import hudson.FilePath;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.TestResult;
import hudson.plugins.testng.results.TestResults;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ResultsParser {
    private static final Logger log = Logger.getLogger(ResultsParser.class.getName());
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static XmlPullParserFactory PARSER_FACTORY;
    private final DateFormat dateFormat;
    private PrintStream logger;
    private Map<String, TestResult> testResultMap = new HashMap<String, TestResult>();
    private Map<String, ClassResult> classResultMap = new HashMap<String, ClassResult>();
    private Map<String, List<String>> methodGroupMap = new HashMap<String, List<String>>();
    private TestResults finalResults;
    private List<TestResult> testList;
    private List<ClassResult> currentClassList;
    private List<MethodResult> currentMethodList;
    private List<String> currentMethodParamsList;
    private TestResult currentTest;
    private ClassResult currentClass;
    private String currentTestRunId;
    private MethodResult currentMethod;
    private XmlPullParser xmlPullParser;
    private TAGS currentCDATAParent = TAGS.UNKNOWN;
    private String currentMessage;
    private String currentShortStackTrace;
    private String currentFullStackTrace;
    private String currentGroupName;
    private String currentSuite;

    public ResultsParser() {
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT);
    }

    public ResultsParser(PrintStream logger) {
        this();
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults parse(FilePath[] paths) {
        if (null == paths) {
            this.log("File paths not specified. paths var is null. Returning empty test results.");
            return new TestResults("");
        }
        this.finalResults = new TestResults(UUID.randomUUID().toString());
        for (FilePath path : paths) {
            File file = new File(path.getRemote());
            if (!file.isFile()) {
                this.log("'" + file.getAbsolutePath() + "' points to an invalid test report");
                continue;
            }
            this.log("Processing '" + file.getAbsolutePath() + "'");
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.xmlPullParser = this.createXmlPullParser(bufferedInputStream);
                this.testList = new ArrayList<TestResult>();
                while (1 != this.xmlPullParser.nextToken()) {
                    TAGS tag = TAGS.fromString(this.xmlPullParser.getName());
                    int eventType = this.xmlPullParser.getEventType();
                    block9 : switch (eventType) {
                        case 2: {
                            switch (tag) {
                                case SUITE: {
                                    this.startSuite(this.get("name"));
                                    break block9;
                                }
                                case GROUPS: {
                                    this.startGroups();
                                    break block9;
                                }
                                case GROUP: {
                                    this.startGroup(this.get("name"));
                                    break block9;
                                }
                                case METHOD: {
                                    this.startGroupMethod(this.get("class"), this.get("name"));
                                    break block9;
                                }
                                case TEST: {
                                    this.startTest(this.get("name"));
                                    break block9;
                                }
                                case CLASS: {
                                    this.startClass(this.get("name"));
                                    break block9;
                                }
                                case TEST_METHOD: {
                                    this.startTestMethod(this.get("name"), this.get("test-instance-name"), this.get("status"), this.get("description"), this.get("duration-ms"), this.get("started-at"), this.get("is-config"));
                                    break block9;
                                }
                                case PARAMS: {
                                    this.startMethodParameters();
                                    this.currentCDATAParent = TAGS.PARAMS;
                                    break block9;
                                }
                                case EXCEPTION: {
                                    this.startException();
                                    break block9;
                                }
                                case MESSAGE: {
                                    this.currentCDATAParent = TAGS.MESSAGE;
                                    break block9;
                                }
                                case SHORT_STACKTRACE: {
                                    this.currentCDATAParent = TAGS.SHORT_STACKTRACE;
                                    break block9;
                                }
                                case FULL_STACKTRACE: {
                                    this.currentCDATAParent = TAGS.FULL_STACKTRACE;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (tag) {
                                case SUITE: {
                                    this.finishSuite();
                                    break block9;
                                }
                                case GROUP: {
                                    this.finishGroup();
                                    break block9;
                                }
                                case METHOD: {
                                    this.finishGroupMethod();
                                    break block9;
                                }
                                case TEST: {
                                    this.finishTest();
                                    break block9;
                                }
                                case CLASS: {
                                    this.finishclass();
                                    break block9;
                                }
                                case TEST_METHOD: {
                                    this.finishTestMethod();
                                    break block9;
                                }
                                case PARAMS: {
                                    this.finishMethodParameters();
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                    break block9;
                                }
                                case EXCEPTION: {
                                    this.finishException();
                                    break block9;
                                }
                                case MESSAGE: 
                                case SHORT_STACKTRACE: 
                                case FULL_STACKTRACE: {
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                }
                            }
                            break;
                        }
                        case 5: {
                            this.handleCDATA();
                        }
                    }
                }
                this.finalResults.addUniqueTests(this.testList);
            }
            catch (XmlPullParserException e) {
                this.log("Failed to parse XML: " + e.getMessage());
                this.log((Exception)((Object)e));
            }
            catch (FileNotFoundException e) {
                this.log("Failed to find XML file");
                this.log(e);
            }
            catch (IOException e) {
                this.log(e);
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log(e);
                }
            }
        }
        this.finalResults.tally();
        return this.finalResults;
    }

    private void startGroupMethod(String className, String methodName) {
        String key = className + "|" + methodName;
        List<String> groups = this.methodGroupMap.get(key);
        if (groups == null) {
            groups = new ArrayList<String>(3);
            groups.add(this.currentGroupName);
            this.methodGroupMap.put(key, groups);
        } else {
            groups.add(this.currentGroupName);
        }
    }

    private void finishGroupMethod() {
    }

    private void startGroup(String groupName) {
        this.currentGroupName = groupName;
    }

    private void finishGroup() {
        this.currentGroupName = null;
    }

    private void startGroups() {
        this.methodGroupMap = new HashMap<String, List<String>>();
    }

    private void startSuite(String name) {
        this.currentSuite = name;
    }

    private void finishSuite() {
        this.methodGroupMap.clear();
        this.currentSuite = null;
    }

    private void startException() {
    }

    private void finishException() {
        if (this.currentShortStackTrace == null && this.currentFullStackTrace == null) {
            this.log("Something is wrong with TestNG result XML. Didn't find stacktraces for the exception.");
            return;
        }
        MethodResultException mrEx = new MethodResultException(this.currentMessage, this.currentShortStackTrace, this.currentFullStackTrace);
        this.currentMethod.setException(mrEx);
        mrEx = null;
        this.currentMessage = null;
        this.currentShortStackTrace = null;
        this.currentFullStackTrace = null;
    }

    private void startMethodParameters() {
        this.currentMethodParamsList = new ArrayList<String>();
    }

    private void finishMethodParameters() {
        this.currentMethod.setParameters(this.currentMethodParamsList);
        this.currentMethodParamsList = null;
    }

    private void handleCDATA() {
        switch (this.currentCDATAParent) {
            case PARAMS: {
                this.currentMethodParamsList.add(this.xmlPullParser.getText());
                break;
            }
            case MESSAGE: {
                this.currentMessage = this.xmlPullParser.getText();
                break;
            }
            case FULL_STACKTRACE: {
                this.currentFullStackTrace = this.xmlPullParser.getText();
                break;
            }
            case SHORT_STACKTRACE: {
                this.currentShortStackTrace = this.xmlPullParser.getText();
                break;
            }
        }
    }

    private void startTestMethod(String name, String testInstanceName, String status, String description, String duration, String startedAt, String isConfig) {
        Date startedAtDate;
        try {
            startedAtDate = this.dateFormat.parse(startedAt);
        }
        catch (ParseException e) {
            this.log("Unable to parse started-at value: " + startedAt);
            startedAtDate = null;
        }
        this.currentMethod = new MethodResult(name, status, description, duration, startedAtDate, isConfig, this.currentTestRunId, this.currentTest.getName(), this.currentSuite, testInstanceName);
        List<String> groups = this.methodGroupMap.get(this.currentClass.getName() + "|" + name);
        if (groups != null) {
            this.currentMethod.setGroups(groups);
        }
    }

    private void finishTestMethod() {
        this.updateTestMethodLists(this.currentMethod);
        this.currentMethodList.add(this.currentMethod);
        this.currentMethod = null;
    }

    private void startClass(String name) {
        if (this.classResultMap.containsKey(name)) {
            this.currentClass = this.classResultMap.get(name);
        } else {
            this.currentClass = new ClassResult(name);
            this.classResultMap.put(name, this.currentClass);
        }
        this.currentMethodList = new ArrayList<MethodResult>();
        this.currentTestRunId = UUID.randomUUID().toString();
    }

    private void finishclass() {
        this.currentClass.addTestMethods(this.currentMethodList);
        this.currentClassList.add(this.currentClass);
        this.currentMethodList = null;
        this.currentClass = null;
        this.currentTestRunId = null;
    }

    private void startTest(String name) {
        if (this.testResultMap.containsKey(name)) {
            this.currentTest = this.testResultMap.get(name);
        } else {
            this.currentTest = new TestResult(name);
            this.testResultMap.put(name, this.currentTest);
        }
        this.currentClassList = new ArrayList<ClassResult>();
    }

    private void finishTest() {
        this.currentTest.addClassList(this.currentClassList);
        this.testList.add(this.currentTest);
        this.currentClassList = null;
        this.currentTest = null;
    }

    private void updateTestMethodLists(MethodResult testMethod) {
        if (testMethod.isConfig()) {
            if ("FAIL".equals(testMethod.getStatus())) {
                this.finalResults.getFailedConfigs().add(testMethod);
            } else if ("SKIP".equals(testMethod.getStatus())) {
                this.finalResults.getSkippedConfigs().add(testMethod);
            }
        } else if ("FAIL".equals(testMethod.getStatus())) {
            this.finalResults.getFailedTests().add(testMethod);
        } else if ("SKIP".equals(testMethod.getStatus())) {
            this.finalResults.getSkippedTests().add(testMethod);
        } else if ("PASS".equals(testMethod.getStatus())) {
            this.finalResults.getPassedTests().add(testMethod);
        }
    }

    private String get(String attr) {
        return this.xmlPullParser.getAttributeValue(null, attr);
    }

    private XmlPullParser createXmlPullParser(BufferedInputStream bufferedInputStream) throws XmlPullParserException {
        if (PARSER_FACTORY == null) {
            throw new XmlPullParserException("XML Parser Factory has not been initiallized properly");
        }
        XmlPullParser xmlPullParser = PARSER_FACTORY.newPullParser();
        xmlPullParser.setInput((InputStream)bufferedInputStream, null);
        return xmlPullParser;
    }

    private void log(String str) {
        if (this.logger != null) {
            this.logger.println(str);
        } else {
            log.fine(str);
        }
    }

    private void log(Exception ex) {
        if (this.logger != null) {
            ex.printStackTrace(this.logger);
        } else {
            log.severe(ex.toString());
        }
    }

    static {
        try {
            PARSER_FACTORY = XmlPullParserFactory.newInstance();
            PARSER_FACTORY.setNamespaceAware(true);
            PARSER_FACTORY.setValidating(false);
        }
        catch (XmlPullParserException e) {
            log.severe(e.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TAGS {
        TESTNG_RESULTS,
        SUITE,
        TEST,
        CLASS,
        TEST_METHOD,
        PARAMS,
        PARAM,
        VALUE,
        EXCEPTION,
        UNKNOWN,
        MESSAGE,
        SHORT_STACKTRACE,
        FULL_STACKTRACE,
        GROUPS,
        GROUP,
        METHOD;


        public static TAGS fromString(String val) {
            if (val == null) {
                return UNKNOWN;
            }
            val = val.toUpperCase().replace('-', '_');
            try {
                return TAGS.valueOf(val);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

