/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.testng.TestNGBuildAction;
import hudson.plugins.testng.util.GraphHelper;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGProjectAction
implements ProminentProjectAction {
    private boolean escapeTestDescp;
    private boolean escapeExceptionMsg;
    private transient Map<String, Integer> requestMap = new HashMap<String, Integer>();
    private final AbstractProject<?, ?> project;

    public TestNGProjectAction(AbstractProject<?, ?> project, boolean escapeTestDescp, boolean escapeExceptionMsg) {
        this.project = project;
        this.escapeExceptionMsg = escapeExceptionMsg;
        this.escapeTestDescp = escapeTestDescp;
    }

    protected Class<TestNGBuildAction> getBuildActionClass() {
        return TestNGBuildAction.class;
    }

    public boolean getEscapeTestDescp() {
        return this.escapeTestDescp;
    }

    public boolean getEscapeExceptionMsg() {
        return this.escapeExceptionMsg;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getIconFileName() {
        return "/plugin/testng-plugin/icons/report.png";
    }

    public String getDisplayName() {
        return "TestNG Results";
    }

    public String getGraphName() {
        return "TestNG Results Trend";
    }

    public String getUrlName() {
        return "testngreports";
    }

    public String getSearchUrl() {
        return "testngreports";
    }

    public void doGraph(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doPng(req, rsp);
    }

    private boolean newGraphNotNeeded(StaplerRequest req, StaplerResponse rsp) {
        Calendar t = ((AbstractBuild)this.getProject().getLastCompletedBuild()).getTimestamp();
        Integer prevNumBuilds = this.requestMap.get(req.getRequestURI());
        int numBuilds = this.getProject().getBuilds().size();
        if ((prevNumBuilds = Integer.valueOf(prevNumBuilds == null ? 0 : prevNumBuilds)) != numBuilds) {
            this.requestMap.put(req.getRequestURI(), numBuilds);
        }
        if (this.requestMap.size() > 10) {
            this.requestMap.clear();
        }
        return prevNumBuilds == numBuilds && req.checkIfModified(t, rsp);
    }

    public void doGraphMap(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doMap(req, rsp);
    }

    public boolean isGraphActive() {
        AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    public TestNGBuildAction getLastCompletedBuildAction() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastCompletedBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            TestNGBuildAction action = (TestNGBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action;
        }
        return null;
    }

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            TestNGBuildAction action = (TestNGBuildAction)build.getAction(this.getBuildActionClass());
            if (action != null) {
                dataset.add((Number)action.getPassedTestCount(), (Comparable)((Object)"Passed"), (Comparable)label);
                dataset.add((Number)action.getFailedTestCount(), (Comparable)((Object)"Failed"), (Comparable)label);
                dataset.add((Number)action.getSkippedTestCount(), (Comparable)((Object)"Skipped"), (Comparable)label);
                continue;
            }
            dataset.add((Number)0, (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)0, (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)0, (Comparable)((Object)"Skipped"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

