/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GitRepositoryBrowser
extends RepositoryBrowser<GitChangeSet> {
    private static final long serialVersionUID = 1L;

    public abstract URL getDiffLink(GitChangeSet.Path var1) throws IOException;

    public abstract URL getFileLink(GitChangeSet.Path var1) throws IOException;

    protected static class GitUrlChecker
    extends FormValidation.URLCheck {
        private String url;
        private String browserName;

        public GitUrlChecker(String url, String gitBrowserName) {
            this.url = url;
            this.browserName = gitBrowserName;
        }

        protected FormValidation check() throws IOException, ServletException {
            if (null == this.url) {
                return FormValidation.ok();
            }
            String v = this.url;
            if (!v.endsWith("/")) {
                v = v + '/';
            }
            try {
                if (this.findText(this.open(new URL(v)), this.browserName)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)("This is a valid URL but it doesn't look like " + this.browserName));
            }
            catch (IOException e) {
                return this.handleIOException(v, e);
            }
        }
    }
}

