/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.converter;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.plugins.git.converter.LegacyConverter;
import hudson.util.RobustReflectionConverter;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.util.Map;
import org.spearce.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConfigConverter
extends RobustReflectionConverter
implements LegacyConverter<org.eclipse.jgit.transport.RemoteConfig> {
    public RemoteConfigConverter(Mapper mapper, ReflectionProvider provider) {
        super(mapper, provider);
    }

    public boolean canConvert(Class type) {
        return org.eclipse.jgit.transport.RemoteConfig.class == type || RemoteConfig.class == type;
    }

    @Override
    public boolean isLegacyNode(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return reader.getNodeName().startsWith("org.spearce");
    }

    @Override
    public org.eclipse.jgit.transport.RemoteConfig legacyUnmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteConfig remoteConfig = new RemoteConfig();
        LegacyInputStreamCallback callback = new LegacyInputStreamCallback(reader, context, remoteConfig);
        try {
            CustomObjectInputStream objectInput = CustomObjectInputStream.getInstance((DataHolder)context, (CustomObjectInputStream.StreamCallback)callback, null);
            remoteConfig.readExternal((ObjectInput)objectInput);
            objectInput.popCallback();
            return remoteConfig.toRemote();
        }
        catch (Exception e) {
            throw new ConversionException("Unmarshal failed", (Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.isLegacyNode(reader, context)) {
            return this.legacyUnmarshal(reader, context);
        }
        return super.unmarshal(reader, context);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.reflectionProvider.newInstance(org.eclipse.jgit.transport.RemoteConfig.class);
    }

    private class LegacyInputStreamCallback
    implements CustomObjectInputStream.StreamCallback {
        private HierarchicalStreamReader reader;
        private UnmarshallingContext context;
        private RemoteConfig remoteConfig;

        private LegacyInputStreamCallback(HierarchicalStreamReader reader, UnmarshallingContext context, RemoteConfig remoteConfig) {
            this.reader = reader;
            this.context = context;
            this.remoteConfig = remoteConfig;
        }

        public Object readFromStream() {
            this.reader.moveDown();
            Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)this.reader, (Mapper)RemoteConfigConverter.this.mapper);
            Object streamItem = this.context.convertAnother((Object)this.remoteConfig, type);
            this.reader.moveUp();
            return streamItem;
        }

        public Map readFieldsFromStream() {
            throw new UnsupportedOperationException();
        }

        public void defaultReadObject() {
            throw new UnsupportedOperationException();
        }

        public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
            throw new NotActiveException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }
    }
}

