/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import de.theit.jenkins.crowd.CrowdSecurityRealm;
import de.theit.jenkins.crowd.CrowdUser;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.tasks.MailAddressResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Extension
public class CrowdMailAddressResolverImpl
extends MailAddressResolver {
    private static final Logger LOG = Logger.getLogger(CrowdMailAddressResolverImpl.class.getName());

    public String findMailAddressFor(User u) {
        String mail = null;
        SecurityRealm realm = Hudson.getInstance().getSecurityRealm();
        if (realm instanceof CrowdSecurityRealm) {
            try {
                int pos2;
                String userId = u.getId();
                int pos = userId.lastIndexOf(40);
                if (pos > 0 && (pos2 = userId.indexOf(41, pos + 1)) > pos) {
                    userId = userId.substring(pos + 1, pos2);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Looking up mail address for user: " + userId);
                }
                CrowdUser details = (CrowdUser)realm.getSecurityComponents().userDetails.loadUserByUsername(userId);
                mail = details.getEmailAddress();
            }
            catch (UsernameNotFoundException ex) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Failed to look up email address in Crowd");
                }
            }
            catch (DataAccessException ex) {
                LOG.log(Level.SEVERE, "Access exception trying to look up email address in Crowd", ex);
            }
        }
        return mail;
    }
}

