/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Unique;
import cats.effect.package$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.ResponseCookie;
import org.http4s.Uri;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Location;
import org.http4s.headers.Location$;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class FollowRedirect$ {
    public static FollowRedirect$ MODULE$;
    private final Key<List<Uri>> redirectUrisKey;

    static {
        new FollowRedirect$();
    }

    public <F> Client<F> apply(int maxRedirects, Function1<CIString, Object> sensitiveHeaderFilter, Client<F> client, GenConcurrent<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable & scala.Serializable)req -> Hotswap$.MODULE$.create(F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Hotswap hotswap = x0$1;
            return package$.MODULE$.Resource().eval(FollowRedirect$.redirectLoop$1(req, 0, hotswap, F, client, maxRedirects, sensitiveHeaderFilter));
        }), F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return Headers$.MODULE$.SensitiveHeaders();
    }

    private <F> Option<Method> methodForRedirect(Request<F> req, Response<F> resp) {
        int n = resp.status().code();
        switch (n) {
            case 301: 
            case 302: {
                Method method = req.method();
                Method method2 = Method$.MODULE$.POST();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    return new Some((Object)Method$.MODULE$.GET());
                }
                return new Some((Object)method);
            }
            case 303: {
                Method method = req.method();
                Method method4 = Method$.MODULE$.HEAD();
                Method method5 = method;
                if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                    return new Some((Object)Method$.MODULE$.HEAD());
                }
                return new Some((Object)Method$.MODULE$.GET());
            }
            case 307: 
            case 308: {
                return new Some((Object)req.method());
            }
        }
        return None$.MODULE$;
    }

    private Key<List<Uri>> redirectUrisKey() {
        return this.redirectUrisKey;
    }

    public <F> List<Uri> getRedirectUris(Response<F> response) {
        return (List)response.attributes().lookup(this.redirectUrisKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Function1 sensitiveHeaderFilter$1, Header.Raw h) {
        return BoxesRunTime.unboxToBoolean((Object)sensitiveHeaderFilter$1.apply((Object)h.name()));
    }

    private static final Request stripSensitiveHeaders$1(Request req, Uri nextUri$1, Function1 sensitiveHeaderFilter$1) {
        Option option = req.uri().authority();
        Option option2 = nextUri$1.authority();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return (Request)req.transformHeaders((Function1 & Serializable & scala.Serializable)hs -> new Headers(Headers$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)((Headers)hs).headers().filterNot((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)FollowRedirect$.$anonfun$apply$5(sensitiveHeaderFilter$1, h))), (Function1 & Serializable & scala.Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))}))));
        }
        return req;
    }

    private static final Request propagateCookies$1(Request req, Uri nextUri$1, List cookies$1) {
        Option option = req.uri().authority();
        Option option2 = nextUri$1.authority();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return (Request)cookies$1.foldLeft((Object)req, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Request nextReq = (Request)tuple2._1();
                    ResponseCookie cookie = (ResponseCookie)tuple2._2();
                    return nextReq.addCookie(cookie.name(), cookie.content());
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return req;
    }

    private static final Request clearBodyFromGetHead$1(Request req, Method method$1) {
        boolean bl;
        Method method = method$1;
        Method method2 = Method$.MODULE$.GET();
        Method method3 = method;
        if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
            bl = true;
        } else {
            Method method4 = Method$.MODULE$.HEAD();
            Method method5 = method;
            bl = !(method4 != null ? !method4.equals(method5) : method5 != null);
        }
        if (bl) {
            return (Request)req.withEmptyBody();
        }
        return req;
    }

    private static final Request nextRequest$1(Request req, Uri uri, Method method, List cookies, Function1 sensitiveHeaderFilter$1) {
        Option x$1 = uri.scheme().orElse((Function0 & Serializable & scala.Serializable)() -> req.uri().scheme());
        Option x$2 = uri.authority().orElse((Function0 & Serializable & scala.Serializable)() -> req.uri().authority());
        Option x$3 = uri.fragment().orElse((Function0 & Serializable & scala.Serializable)() -> req.uri().fragment());
        Uri.Path x$4 = uri.copy$default$3();
        Query x$5 = uri.copy$default$4();
        Uri nextUri = uri.copy(x$1, x$2, x$4, x$5, x$3);
        return FollowRedirect$.clearBodyFromGetHead$1(FollowRedirect$.propagateCookies$1(FollowRedirect$.stripSensitiveHeaders$1(req, nextUri, sensitiveHeaderFilter$1), nextUri, cookies).withMethod(method).withUri(nextUri), method);
    }

    private static final Object redirectLoop$1(Request req, int redirects, Hotswap hotswap, GenConcurrent F$1, Client client$1, int maxRedirects$1, Function1 sensitiveHeaderFilter$1) {
        return package.all$.MODULE$.catsSyntaxApply(hotswap.clear(), (Apply)F$1).$times$greater(package.all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run(req)), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)resp -> {
            Option l = Headers$.MODULE$.get$extension0(resp.headers(), Header.Select$.MODULE$.singleHeaders(Location$.MODULE$.headerInstance()));
            Tuple2 tuple2 = new Tuple2(MODULE$.methodForRedirect((Request)req, (Response)resp), (Object)l);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Method method = (Method)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Location loc = (Location)some2.value();
                        if (redirects < maxRedirects$1) {
                            Request nextReq = FollowRedirect$.nextRequest$1(req, loc.uri(), method, resp.cookies(), sensitiveHeaderFilter$1);
                            return package.all$.MODULE$.toFunctorOps(FollowRedirect$.redirectLoop$1(nextReq, redirects + 1, hotswap, F$1, client$1, maxRedirects$1, sensitiveHeaderFilter$1), (Functor)F$1).map((Function1 & Serializable & scala.Serializable)res -> {
                                Uri uri = nextReq.uri();
                                return (Response)res.withAttribute(MODULE$.redirectUrisKey(), MODULE$.getRedirectUris((Response)res).$plus$colon((Object)uri, List$.MODULE$.canBuildFrom()));
                            });
                        }
                    }
                }
            }
            return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(resp), (Applicative)F$1);
        }));
    }

    private FollowRedirect$() {
        MODULE$ = this;
        this.redirectUrisKey = (Key)((SyncIO)Key$.MODULE$.newKey((Functor)SyncIO$.MODULE$.syncForSyncIO(), (Unique)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }
}

