/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.dom;

import org.htmlunit.cyberneko.xerces.dom.CoreDocumentImpl;
import org.htmlunit.cyberneko.xerces.dom.DocumentImpl;
import org.htmlunit.cyberneko.xerces.dom.DocumentTypeImpl;
import org.htmlunit.cyberneko.xerces.util.DOMMessageFormatter;
import org.htmlunit.cyberneko.xerces.util.XMLChar;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DOMImplementationImpl
implements DOMImplementation {
    private static final DOMImplementationImpl INSTANCE = new DOMImplementationImpl();
    private int docAndDoctypeCounter_ = 0;

    public static DOMImplementation getDOMImplementation() {
        return INSTANCE;
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        boolean anyVersion;
        boolean bl = anyVersion = version == null || version.length() == 0;
        if (feature.startsWith("+")) {
            feature = feature.substring(1);
        }
        if ("Core".equalsIgnoreCase(feature) && (anyVersion || "1.0".equals(version) || "2.0".equals(version) || "3.0".equals(version))) {
            return true;
        }
        if ("XML".equalsIgnoreCase(feature) && (anyVersion || "1.0".equals(version) || "2.0".equals(version) || "3.0".equals(version))) {
            return true;
        }
        if ("XMLVersion".equalsIgnoreCase(feature) && (anyVersion || "1.0".equals(version) || "1.1".equals(version))) {
            return true;
        }
        if ("LS".equalsIgnoreCase(feature) && (anyVersion || "3.0".equals(version))) {
            return true;
        }
        if ("ElementTraversal".equalsIgnoreCase(feature) && (anyVersion || "1.0".equals(version))) {
            return true;
        }
        if ("Events".equalsIgnoreCase(feature) && (anyVersion || "2.0".equals(version))) {
            return true;
        }
        if ("MutationEvents".equalsIgnoreCase(feature) && (anyVersion || "2.0".equals(version))) {
            return true;
        }
        if ("Traversal".equalsIgnoreCase(feature) && (anyVersion || "2.0".equals(version))) {
            return true;
        }
        return "Range".equalsIgnoreCase(feature) && (anyVersion || "2.0".equals(version));
    }

    protected CoreDocumentImpl createDocument(DocumentType doctype) {
        return new DocumentImpl(doctype);
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        this.checkQName(qualifiedName);
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }

    final void checkQName(String qname) {
        int i;
        int index = qname.indexOf(58);
        int lastIndex = qname.lastIndexOf(58);
        int length = qname.length();
        if (index == 0 || index == length - 1 || lastIndex != index) {
            String msg = DOMMessageFormatter.formatMessage("NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
        int start = 0;
        if (index > 0) {
            if (!XMLChar.isNCNameStart(qname.charAt(start))) {
                String msg = DOMMessageFormatter.formatMessage("INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            for (i = 1; i < index; ++i) {
                if (XMLChar.isNCName(qname.charAt(i))) continue;
                String msg = DOMMessageFormatter.formatMessage("INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            start = index + 1;
        }
        if (!XMLChar.isNCNameStart(qname.charAt(start))) {
            String msg = DOMMessageFormatter.formatMessage("INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        for (i = start + 1; i < length; ++i) {
            if (XMLChar.isNCName(qname.charAt(i))) continue;
            String msg = DOMMessageFormatter.formatMessage("INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            String msg = DOMMessageFormatter.formatMessage("WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        CoreDocumentImpl doc = this.createDocument(doctype);
        if (qualifiedName != null || namespaceURI != null) {
            Element e = doc.createElementNS(namespaceURI, qualifiedName);
            doc.appendChild(e);
        }
        return doc;
    }

    @Override
    public Object getFeature(String feature, String version) {
        if (INSTANCE.hasFeature(feature, version)) {
            return INSTANCE;
        }
        return null;
    }

    protected synchronized int assignDocumentNumber() {
        return ++this.docAndDoctypeCounter_;
    }

    protected synchronized int assignDocTypeNumber() {
        return ++this.docAndDoctypeCounter_;
    }
}

