/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SimpleArrayList<T>
implements List<T> {
    private T[] data;
    private int size;

    SimpleArrayList(SimpleArrayList<T> list) {
        this.data = list.data;
        this.size = list.size;
    }

    public SimpleArrayList(int capacity) {
        this.data = new Object[capacity];
    }

    public SimpleArrayList() {
        this.data = new Object[10];
    }

    @Override
    public boolean add(T element) {
        int length = this.data.length;
        if (this.size == length) {
            Object[] newData = new Object[(length << 1) + 2];
            System.arraycopy(this.data, 0, newData, 0, length);
            this.data = newData;
        }
        this.data[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, T element) {
        int length = this.data.length;
        if (this.size == length) {
            Object[] newData = new Object[(length << 1) + 2];
            System.arraycopy(this.data, 0, newData, 0, length);
            this.data = newData;
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    @Override
    public T get(int index) {
        return this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return Arrays.copyOf(this.data, this.size, array.getClass());
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public List<List<T>> partition(int count) {
        int _count = count > this.size ? this.size : (count <= 0 ? 1 : count);
        SimpleArrayList result = new SimpleArrayList(count);
        int newSize = (int)Math.ceil((double)this.size / (double)_count);
        for (int i = 0; i < _count; ++i) {
            int from = i * newSize;
            int to = from + newSize - 1;
            if (to >= this.size) {
                to = this.size - 1;
            }
            result.add((T)new Partition(this, from, to));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public T remove(int index) {
        T t = this.data[index];
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        --this.size;
        return t;
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("unimplemented");
    }

    class Partition<K>
    extends SimpleArrayList<K> {
        private final int from;
        private final int size;

        Partition(SimpleArrayList<K> list, int from, int to) {
            super(list);
            this.from = from;
            this.size = to - from + 1;
        }

        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException("Cannot modify the partition");
        }

        @Override
        public K get(int index) {
            return (K)super.get(index + this.from);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public K[] toArray() {
            throw new UnsupportedOperationException("unimplemented");
        }
    }
}

