/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.io;

import java.io.IOException;
import java.io.InputStream;

public final class PlaybackInputStream
extends InputStream {
    private static final boolean DEBUG_PLAYBACK = false;
    private boolean playback_ = false;
    private boolean cleared_ = false;
    private boolean detected_ = false;
    private byte[] byteBuffer_ = new byte[1024];
    private int byteOffset_ = 0;
    private int byteLength_ = 0;
    private int pushbackOffset_ = 0;
    private int pushbackLength_ = 0;
    private final InputStream in;

    public PlaybackInputStream(InputStream in) {
        this.in = in;
    }

    public void detectEncoding(String[] encodings) throws IOException {
        if (this.detected_) {
            throw new IOException("Should not detect encoding twice.");
        }
        this.detected_ = true;
        int b1 = this.read();
        if (b1 == -1) {
            return;
        }
        int b2 = this.read();
        if (b2 == -1) {
            this.pushbackLength_ = 1;
            return;
        }
        if (b1 == 239 && b2 == 187) {
            int b3 = this.read();
            if (b3 == 191) {
                this.pushbackOffset_ = 3;
                encodings[0] = "UTF-8";
                encodings[1] = "UTF8";
                return;
            }
            this.pushbackLength_ = 3;
        }
        if (b1 == 255 && b2 == 254) {
            encodings[0] = "UTF-16";
            encodings[1] = "UnicodeLittleUnmarked";
            return;
        }
        if (b1 == 254 && b2 == 255) {
            encodings[0] = "UTF-16";
            encodings[1] = "UnicodeBigUnmarked";
            return;
        }
        this.pushbackLength_ = 2;
    }

    public void playback() {
        this.playback_ = true;
    }

    public void clear() {
        if (!this.playback_) {
            this.cleared_ = true;
            this.byteBuffer_ = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.cleared_) {
            return this.in.read();
        }
        if (this.pushbackOffset_ < this.pushbackLength_) {
            return this.byteBuffer_[this.pushbackOffset_++];
        }
        if (this.playback_) {
            byte c = this.byteBuffer_[this.byteOffset_++];
            if (this.byteOffset_ == this.byteLength_) {
                this.cleared_ = true;
                this.byteBuffer_ = null;
            }
            return c;
        }
        int c = this.in.read();
        if (c != -1) {
            if (this.byteLength_ == this.byteBuffer_.length) {
                byte[] newarray = new byte[this.byteLength_ + 1024];
                System.arraycopy(this.byteBuffer_, 0, newarray, 0, this.byteLength_);
                this.byteBuffer_ = newarray;
            }
            this.byteBuffer_[this.byteLength_++] = (byte)c;
        }
        return c;
    }

    @Override
    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    @Override
    public int read(byte[] array, int offset, int length) throws IOException {
        if (this.cleared_) {
            return this.in.read(array, offset, length);
        }
        if (this.pushbackOffset_ < this.pushbackLength_) {
            int count = this.pushbackLength_ - this.pushbackOffset_;
            if (count > length) {
                count = length;
            }
            System.arraycopy(this.byteBuffer_, this.pushbackOffset_, array, offset, count);
            this.pushbackOffset_ += count;
            return count;
        }
        if (this.playback_) {
            if (this.byteOffset_ + length > this.byteLength_) {
                length = this.byteLength_ - this.byteOffset_;
            }
            System.arraycopy(this.byteBuffer_, this.byteOffset_, array, offset, length);
            this.byteOffset_ += length;
            if (this.byteOffset_ == this.byteLength_) {
                this.cleared_ = true;
                this.byteBuffer_ = null;
            }
            return length;
        }
        int count = this.in.read(array, offset, length);
        if (count != -1) {
            if (this.byteLength_ + count > this.byteBuffer_.length) {
                byte[] newarray = new byte[this.byteLength_ + count + 512];
                System.arraycopy(this.byteBuffer_, 0, newarray, 0, this.byteLength_);
                this.byteBuffer_ = newarray;
            }
            System.arraycopy(array, offset, this.byteBuffer_, this.byteLength_, count);
            this.byteLength_ += count;
        }
        return count;
    }
}

