/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.htmlunit.csp.Constants;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.value.Host;
import org.htmlunit.csp.value.Scheme;

public abstract class HostSourceDirective
extends Directive {
    private static final String NONE_SRC = "'none'";
    private static final String SELF_SRC = "'self'";
    private final List<Scheme> schemes_ = new ArrayList<Scheme>();
    private final List<Host> hosts_ = new ArrayList<Host>();
    private boolean star_;
    private boolean self_;
    private String none_;

    protected HostSourceDirective(List<String> values) {
        super(values);
    }

    public String getNone() {
        return this.none_;
    }

    @Override
    protected void addValue(String value) {
        if (this.none_ != null) {
            super.removeValueIgnoreCase(NONE_SRC);
            this.none_ = null;
        }
        super.addValue(value);
    }

    @Override
    protected void removeValueIgnoreCase(String value) {
        super.removeValueIgnoreCase(value);
        if (this.getValues().isEmpty()) {
            this.getValues().add(NONE_SRC);
            this.none_ = NONE_SRC;
        }
    }

    void addHostOrSchemeDuringConstruction(String token, String lowcaseToken, String kind, int index, Directive.DirectiveErrorConsumer errors) {
        if (lowcaseToken.equals(NONE_SRC)) {
            if (this.none_ == null) {
                this.none_ = token;
            }
        } else if ("*".equals(lowcaseToken)) {
            if (this.star_) {
                errors.add(Policy.Severity.Warning, "Duplicate " + kind + " *", index);
            } else {
                this.star_ = true;
            }
        } else if (lowcaseToken.equals(SELF_SRC)) {
            if (this.self_) {
                errors.add(Policy.Severity.Warning, "Duplicate " + kind + " 'self'", index);
            } else {
                this.self_ = true;
            }
        } else {
            Optional<Scheme> asScheme = Scheme.parseScheme(token);
            if (asScheme.isPresent()) {
                this.addScheme(asScheme.get(), index, errors);
            } else {
                Optional<Host> asHost;
                if (Constants.UNQUOTED_KEYWORD_PATTERN.matcher(token).find()) {
                    errors.add(Policy.Severity.Warning, "This host name is unusual, and likely meant to be a keyword that is missing the required quotes: '" + token + "'.", index);
                }
                if ((asHost = Host.parseHost(token)).isPresent()) {
                    this.addHostSource(asHost.get(), index, errors);
                } else {
                    errors.add(Policy.Severity.Error, "Unrecognized " + kind + " " + token, index);
                }
            }
        }
    }

    private boolean addScheme(Scheme scheme, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.schemes_.contains(scheme)) {
            errors.add(Policy.Severity.Warning, "Duplicate scheme " + scheme, index);
            return false;
        }
        this.schemes_.add(scheme);
        return true;
    }

    private boolean addHostSource(Host source, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.hosts_.contains(source)) {
            errors.add(Policy.Severity.Warning, "Duplicate host " + source.toString(), index);
            return false;
        }
        this.hosts_.add(source);
        return true;
    }

    public boolean star() {
        return this.star_;
    }

    public boolean self() {
        return this.self_;
    }

    public List<Scheme> getSchemes() {
        return Collections.unmodifiableList(this.schemes_);
    }

    public List<Host> getHosts() {
        return Collections.unmodifiableList(this.hosts_);
    }
}

