/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.CompilerEnvirons;
import org.htmlunit.corejs.javascript.ErrorReporter;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.Node;
import org.htmlunit.corejs.javascript.Parser;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ast.ArrayComprehension;
import org.htmlunit.corejs.javascript.ast.ArrayComprehensionLoop;
import org.htmlunit.corejs.javascript.ast.ArrayLiteral;
import org.htmlunit.corejs.javascript.ast.Assignment;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.AstRoot;
import org.htmlunit.corejs.javascript.ast.BigIntLiteral;
import org.htmlunit.corejs.javascript.ast.Block;
import org.htmlunit.corejs.javascript.ast.BreakStatement;
import org.htmlunit.corejs.javascript.ast.CatchClause;
import org.htmlunit.corejs.javascript.ast.ComputedPropertyKey;
import org.htmlunit.corejs.javascript.ast.ConditionalExpression;
import org.htmlunit.corejs.javascript.ast.ContinueStatement;
import org.htmlunit.corejs.javascript.ast.DestructuringForm;
import org.htmlunit.corejs.javascript.ast.DoLoop;
import org.htmlunit.corejs.javascript.ast.ElementGet;
import org.htmlunit.corejs.javascript.ast.EmptyExpression;
import org.htmlunit.corejs.javascript.ast.ExpressionStatement;
import org.htmlunit.corejs.javascript.ast.ForInLoop;
import org.htmlunit.corejs.javascript.ast.ForLoop;
import org.htmlunit.corejs.javascript.ast.FunctionCall;
import org.htmlunit.corejs.javascript.ast.FunctionNode;
import org.htmlunit.corejs.javascript.ast.GeneratorExpression;
import org.htmlunit.corejs.javascript.ast.GeneratorExpressionLoop;
import org.htmlunit.corejs.javascript.ast.IfStatement;
import org.htmlunit.corejs.javascript.ast.InfixExpression;
import org.htmlunit.corejs.javascript.ast.Jump;
import org.htmlunit.corejs.javascript.ast.KeywordLiteral;
import org.htmlunit.corejs.javascript.ast.Label;
import org.htmlunit.corejs.javascript.ast.LabeledStatement;
import org.htmlunit.corejs.javascript.ast.LetNode;
import org.htmlunit.corejs.javascript.ast.Name;
import org.htmlunit.corejs.javascript.ast.NewExpression;
import org.htmlunit.corejs.javascript.ast.NumberLiteral;
import org.htmlunit.corejs.javascript.ast.ObjectLiteral;
import org.htmlunit.corejs.javascript.ast.ObjectProperty;
import org.htmlunit.corejs.javascript.ast.ParenthesizedExpression;
import org.htmlunit.corejs.javascript.ast.PropertyGet;
import org.htmlunit.corejs.javascript.ast.RegExpLiteral;
import org.htmlunit.corejs.javascript.ast.ReturnStatement;
import org.htmlunit.corejs.javascript.ast.Scope;
import org.htmlunit.corejs.javascript.ast.ScriptNode;
import org.htmlunit.corejs.javascript.ast.StringLiteral;
import org.htmlunit.corejs.javascript.ast.SwitchCase;
import org.htmlunit.corejs.javascript.ast.SwitchStatement;
import org.htmlunit.corejs.javascript.ast.Symbol;
import org.htmlunit.corejs.javascript.ast.TaggedTemplateLiteral;
import org.htmlunit.corejs.javascript.ast.TemplateCharacters;
import org.htmlunit.corejs.javascript.ast.TemplateLiteral;
import org.htmlunit.corejs.javascript.ast.ThrowStatement;
import org.htmlunit.corejs.javascript.ast.TryStatement;
import org.htmlunit.corejs.javascript.ast.UnaryExpression;
import org.htmlunit.corejs.javascript.ast.UpdateExpression;
import org.htmlunit.corejs.javascript.ast.VariableDeclaration;
import org.htmlunit.corejs.javascript.ast.VariableInitializer;
import org.htmlunit.corejs.javascript.ast.WhileLoop;
import org.htmlunit.corejs.javascript.ast.WithStatement;
import org.htmlunit.corejs.javascript.ast.XmlElemRef;
import org.htmlunit.corejs.javascript.ast.XmlExpression;
import org.htmlunit.corejs.javascript.ast.XmlFragment;
import org.htmlunit.corejs.javascript.ast.XmlLiteral;
import org.htmlunit.corejs.javascript.ast.XmlMemberGet;
import org.htmlunit.corejs.javascript.ast.XmlPropRef;
import org.htmlunit.corejs.javascript.ast.XmlRef;
import org.htmlunit.corejs.javascript.ast.XmlString;
import org.htmlunit.corejs.javascript.ast.Yield;

public final class IRFactory {
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;
    private Parser parser;
    private AstNodePosition astNodePos;

    public IRFactory(CompilerEnvirons env, String sourceString) {
        this(env, sourceString, env.getErrorReporter());
    }

    public IRFactory(CompilerEnvirons env, String sourceString, ErrorReporter errorReporter) {
        this.parser = new Parser(env, errorReporter);
        this.astNodePos = new AstNodePosition(sourceString);
        this.parser.currentPos = this.astNodePos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptNode transformTree(AstRoot root) {
        this.parser.currentScriptOrFn = root;
        this.parser.inUseStrictDirective = root.isInStrictMode();
        this.astNodePos.push(root);
        try {
            ScriptNode scriptNode = (ScriptNode)this.transform(root);
            return scriptNode;
        }
        catch (Parser.ParserException e) {
            this.parser.reportErrorsIfExists(root.getLineno());
            ScriptNode scriptNode = null;
            return scriptNode;
        }
        finally {
            this.astNodePos.pop();
        }
    }

    private Node transform(AstNode node) {
        switch (node.getType()) {
            case 165: {
                return this.transformArrayComp((ArrayComprehension)node);
            }
            case 66: {
                return this.transformArrayLiteral((ArrayLiteral)node);
            }
            case 83: {
                return this.transformBigInt((BigIntLiteral)node);
            }
            case 137: {
                return this.transformBlock(node);
            }
            case 127: {
                return this.transformBreak((BreakStatement)node);
            }
            case 38: {
                return this.transformFunctionCall((FunctionCall)node);
            }
            case 128: {
                return this.transformContinue((ContinueStatement)node);
            }
            case 125: {
                return this.transformDoLoop((DoLoop)node);
            }
            case 135: 
            case 169: {
                return node;
            }
            case 126: {
                if (node instanceof ForInLoop) {
                    return this.transformForInLoop((ForInLoop)node);
                }
                return this.transformForLoop((ForLoop)node);
            }
            case 116: {
                return this.transformFunction((FunctionNode)node);
            }
            case 170: {
                return this.transformGenExpr((GeneratorExpression)node);
            }
            case 36: {
                return this.transformElementGet((ElementGet)node);
            }
            case 33: {
                return this.transformPropertyGet((PropertyGet)node);
            }
            case 180: {
                if (node instanceof ElementGet) {
                    return this.transformElementGet((ElementGet)node);
                }
                return this.transformPropertyGet((PropertyGet)node);
            }
            case 109: {
                return this.transformCondExpr((ConditionalExpression)node);
            }
            case 119: {
                return this.transformIf((IfStatement)node);
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 168: {
                return this.transformLiteral(node);
            }
            case 39: {
                return this.transformName((Name)node);
            }
            case 40: {
                return this.transformNumber((NumberLiteral)node);
            }
            case 30: {
                return this.transformNewExpr((NewExpression)node);
            }
            case 67: {
                return this.transformObjectLiteral((ObjectLiteral)node);
            }
            case 174: {
                return this.transformTemplateLiteral((TemplateLiteral)node);
            }
            case 177: {
                return this.transformTemplateLiteralCall((TaggedTemplateLiteral)node);
            }
            case 48: {
                return this.transformRegExp((RegExpLiteral)node);
            }
            case 4: {
                return this.transformReturn((ReturnStatement)node);
            }
            case 144: {
                return this.transformScript((ScriptNode)node);
            }
            case 41: {
                return this.transformString((StringLiteral)node);
            }
            case 121: {
                return this.transformSwitch((SwitchStatement)node);
            }
            case 50: {
                return this.transformThrow((ThrowStatement)node);
            }
            case 84: {
                return this.transformTry((TryStatement)node);
            }
            case 124: {
                return this.transformWhileLoop((WhileLoop)node);
            }
            case 130: {
                return this.transformWith((WithStatement)node);
            }
            case 73: 
            case 173: {
                return this.transformYield((Yield)node);
            }
        }
        if (node instanceof ExpressionStatement) {
            return this.transformExprStmt((ExpressionStatement)node);
        }
        if (node instanceof Assignment) {
            return this.transformAssignment((Assignment)node);
        }
        if (node instanceof UnaryExpression) {
            return this.transformUnary((UnaryExpression)node);
        }
        if (node instanceof UpdateExpression) {
            return this.transformUpdate((UpdateExpression)node);
        }
        if (node instanceof XmlMemberGet) {
            return this.transformXmlMemberGet((XmlMemberGet)node);
        }
        if (node instanceof InfixExpression) {
            return this.transformInfix((InfixExpression)node);
        }
        if (node instanceof VariableDeclaration) {
            return this.transformVariables((VariableDeclaration)node);
        }
        if (node instanceof ParenthesizedExpression) {
            return this.transformParenExpr((ParenthesizedExpression)node);
        }
        if (node instanceof ComputedPropertyKey) {
            return this.transformComputedPropertyKey((ComputedPropertyKey)node);
        }
        if (node instanceof LabeledStatement) {
            return this.transformLabeledStatement((LabeledStatement)node);
        }
        if (node instanceof LetNode) {
            return this.transformLetNode((LetNode)node);
        }
        if (node instanceof XmlRef) {
            return this.transformXmlRef((XmlRef)node);
        }
        if (node instanceof XmlLiteral) {
            return this.transformXmlLiteral((XmlLiteral)node);
        }
        throw new IllegalArgumentException("Can't transform: " + node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformArrayComp(ArrayComprehension node) {
        int lineno = node.getLineno();
        Scope scopeNode = this.parser.createScopeNode(165, lineno);
        String arrayName = this.parser.currentScriptOrFn.getNextTempName();
        this.parser.pushScope(scopeNode);
        try {
            this.astNodePos.push(node);
            try {
                this.parser.defineSymbol(161, arrayName, false);
                Node block = new Node(137, lineno);
                Node newArray = this.createCallOrNew(30, this.parser.createName("Array"));
                Node init = new Node(141, this.createAssignment(93, this.parser.createName(arrayName), newArray), lineno);
                block.addChildToBack(init);
                block.addChildToBack(this.arrayCompTransformHelper(node, arrayName));
                scopeNode.addChildToBack(block);
                scopeNode.addChildToBack(this.parser.createName(arrayName));
                Scope scope = scopeNode;
                this.astNodePos.pop();
                return scope;
            }
            catch (Throwable throwable) {
                this.astNodePos.pop();
                throw throwable;
            }
        }
        finally {
            this.parser.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayCompTransformHelper(ArrayComprehension node, String arrayName) {
        int i;
        int lineno = node.getLineno();
        Node expr = this.transform(node.getResult());
        List<ArrayComprehensionLoop> loops = node.getLoops();
        int numLoops = loops.size();
        Node[] iterators = new Node[numLoops];
        Node[] iteratedObjs = new Node[numLoops];
        for (int i2 = 0; i2 < numLoops; ++i2) {
            ArrayComprehensionLoop acl = loops.get(i2);
            AstNode iter = acl.getIterator();
            this.astNodePos.push(iter);
            try {
                String name = null;
                if (iter.getType() == 39) {
                    name = iter.getString();
                } else {
                    name = this.parser.currentScriptOrFn.getNextTempName();
                    this.parser.defineSymbol(90, name, false);
                    expr = IRFactory.createBinary(92, this.createAssignment(93, iter, this.parser.createName(name)), expr);
                }
                Node init = this.parser.createName(name);
                this.parser.defineSymbol(161, name, false);
                iterators[i2] = init;
            }
            finally {
                this.astNodePos.pop();
            }
            iteratedObjs[i2] = this.transform(acl.getIteratedObject());
        }
        Node call = this.createCallOrNew(38, this.createPropertyGet(this.parser.createName(arrayName), null, "push", 0, node.type));
        Node body = new Node(141, call, lineno);
        if (node.getFilter() != null) {
            body = IRFactory.createIf(this.transform(node.getFilter()), body, null, lineno);
        }
        int pushed = 0;
        try {
            for (i = numLoops - 1; i >= 0; --i) {
                ArrayComprehensionLoop acl = loops.get(i);
                Scope loop = this.createLoopNode(null, acl.getLineno());
                this.parser.pushScope(loop);
                ++pushed;
                body = this.createForIn(161, loop, iterators[i], iteratedObjs[i], body, acl, acl.isForEach(), acl.isForOf());
            }
        }
        finally {
            for (i = 0; i < pushed; ++i) {
                this.parser.popScope();
            }
        }
        call.addChildToBack(expr);
        return body;
    }

    private Node transformArrayLiteral(ArrayLiteral node) {
        if (node.isDestructuring()) {
            return node;
        }
        List<AstNode> elems = node.getElements();
        Node array = new Node(66);
        ArrayList<Integer> skipIndexes = null;
        for (int i = 0; i < elems.size(); ++i) {
            AstNode elem = elems.get(i);
            if (elem.getType() != 135) {
                array.addChildToBack(this.transform(elem));
                continue;
            }
            if (skipIndexes == null) {
                skipIndexes = new ArrayList<Integer>();
            }
            skipIndexes.add(i);
        }
        array.putIntProp(21, node.getDestructuringLength());
        if (skipIndexes != null) {
            int[] skips = new int[skipIndexes.size()];
            for (int i = 0; i < skipIndexes.size(); ++i) {
                skips[i] = (Integer)skipIndexes.get(i);
            }
            array.putProp(11, skips);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformAssignment(Assignment node) {
        AstNode right = node.getRight();
        AstNode left = this.parser.removeParens(node.getLeft());
        left = this.transformAssignmentLeft(node, left, right);
        Node target = null;
        target = this.isDestructuring(left) ? left : this.transform(left);
        this.astNodePos.push(left);
        try {
            Node node2 = this.createAssignment(node.getType(), target, this.transform(right));
            return node2;
        }
        finally {
            this.astNodePos.pop();
        }
    }

    private AstNode transformAssignmentLeft(Assignment node, AstNode left, AstNode right) {
        if (right.getType() == 42 && node.getType() == 93 && left instanceof Name && right instanceof KeywordLiteral) {
            String identifier = ((Name)left).getIdentifier();
            for (AstNode p = node.getParent(); p != null; p = p.getParent()) {
                Name functionName;
                if (!(p instanceof FunctionNode) || (functionName = ((FunctionNode)p).getFunctionName()) == null || !functionName.getIdentifier().equals(identifier)) continue;
                PropertyGet propertyGet = new PropertyGet();
                KeywordLiteral thisKeyword = new KeywordLiteral();
                thisKeyword.setType(43);
                propertyGet.setLeft(thisKeyword);
                propertyGet.setRight(left);
                node.setLeft(propertyGet);
                return propertyGet;
            }
        }
        return left;
    }

    private Node transformBigInt(BigIntLiteral node) {
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformBlock(AstNode node) {
        if (node instanceof Scope) {
            this.parser.pushScope((Scope)node);
        }
        try {
            ArrayList<Node> kids = new ArrayList<Node>();
            for (Node kid : node) {
                kids.add(this.transform((AstNode)kid));
            }
            node.removeChildren();
            for (Node kid : kids) {
                node.addChildToBack(kid);
            }
            AstNode astNode = node;
            return astNode;
        }
        finally {
            if (node instanceof Scope) {
                this.parser.popScope();
            }
        }
    }

    private Node transformBreak(BreakStatement node) {
        return node;
    }

    private Node transformCondExpr(ConditionalExpression node) {
        Node test = this.transform(node.getTestExpression());
        Node ifTrue = this.transform(node.getTrueExpression());
        Node ifFalse = this.transform(node.getFalseExpression());
        return IRFactory.createCondExpr(test, ifTrue, ifFalse);
    }

    private Node transformContinue(ContinueStatement node) {
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformDoLoop(DoLoop loop) {
        loop.setType(140);
        this.parser.pushScope(loop);
        try {
            Node body = this.transform(loop.getBody());
            Node cond = this.transform(loop.getCondition());
            Node node = IRFactory.createLoop(loop, 0, body, cond, null, null);
            return node;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformElementGet(ElementGet node) {
        Node target = this.transform(node.getTarget());
        Node element = this.transform(node.getElement());
        Node getElem = new Node(36, target, element);
        if (node.type == 180) {
            getElem.putIntProp(30, 1);
        }
        return getElem;
    }

    private Node transformExprStmt(ExpressionStatement node) {
        Node expr = this.transform(node.getExpression());
        return new Node(node.getType(), expr, node.getLineno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForInLoop(ForInLoop loop) {
        loop.setType(140);
        this.parser.pushScope(loop);
        try {
            int declType = -1;
            AstNode iter = loop.getIterator();
            if (iter instanceof VariableDeclaration) {
                declType = iter.getType();
            }
            Node lhs = this.transform(iter);
            Node obj = this.transform(loop.getIteratedObject());
            Node body = this.transform(loop.getBody());
            Node node = this.createForIn(declType, loop, lhs, obj, body, loop, loop.isForEach(), loop.isForOf());
            return node;
        }
        finally {
            this.parser.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForLoop(ForLoop loop) {
        loop.setType(140);
        Scope savedScope = this.parser.currentScope;
        this.parser.currentScope = loop;
        try {
            Node init = this.transform(loop.getInitializer());
            Node test = this.transform(loop.getCondition());
            Node incr = this.transform(loop.getIncrement());
            Node body = this.transform(loop.getBody());
            Node node = IRFactory.createFor(loop, init, test, incr, body);
            return node;
        }
        finally {
            this.parser.currentScope = savedScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformFunction(FunctionNode fn) {
        Node mexpr = this.decompileFunctionHeader(fn);
        int index = this.parser.currentScriptOrFn.addFunction(fn);
        Parser.PerFunctionVariables savedVars = this.parser.createPerFunctionVariables(fn);
        try {
            List<Node[]> dfns;
            Node destructuring = (Node)fn.getProp(23);
            fn.removeProp(23);
            int lineno = fn.getBody().getLineno();
            ++this.parser.nestingOfFunction;
            Node body = this.transform(fn.getBody());
            List<Object> defaultParams = fn.getDefaultParams();
            if (defaultParams != null) {
                for (int i = defaultParams.size() - 1; i > 0; i -= 2) {
                    if (!(defaultParams.get(i) instanceof AstNode) || !(defaultParams.get(i - 1) instanceof String)) continue;
                    AstNode rhs = (AstNode)defaultParams.get(i);
                    String name = (String)defaultParams.get(i - 1);
                    body.addChildToFront(IRFactory.createIf(IRFactory.createBinary(46, this.parser.createName(name), this.parser.createName("undefined")), new Node(141, this.createAssignment(93, this.parser.createName(name), this.transform(rhs)), body.getLineno()), null, body.getLineno()));
                }
            }
            if ((dfns = fn.getDestructuringRvalues()) != null) {
                for (Node[] i : dfns) {
                    Node a = i[0];
                    if (!(i[1] instanceof AstNode)) continue;
                    AstNode b = (AstNode)i[1];
                    a.replaceChild(b, this.transform(b));
                }
            }
            if (destructuring != null) {
                body.addChildToFront(new Node(141, destructuring, lineno));
            }
            int syntheticType = fn.getFunctionType();
            Node pn = IRFactory.initFunction(fn, index, body, syntheticType);
            if (mexpr != null) {
                this.astNodePos.push(fn);
                try {
                    pn = this.createAssignment(93, mexpr, pn);
                }
                finally {
                    this.astNodePos.pop();
                }
                if (syntheticType != 2) {
                    pn = IRFactory.createExprStatementNoReturn(pn, fn.getLineno());
                }
            }
            Node node = pn;
            return node;
        }
        finally {
            --this.parser.nestingOfFunction;
            savedVars.restore();
        }
    }

    private Node transformFunctionCall(FunctionCall node) {
        Node call = this.createCallOrNew(38, this.transform(node.getTarget()));
        call.setLineno(node.getLineno());
        List<AstNode> args = node.getArguments();
        for (int i = 0; i < args.size(); ++i) {
            AstNode arg = args.get(i);
            call.addChildToBack(this.transform(arg));
        }
        if (node.isOptionalCall()) {
            call.putIntProp(30, 1);
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformGenExpr(GeneratorExpression node) {
        Node pn;
        block8: {
            FunctionNode fn = new FunctionNode();
            fn.setSourceName(this.parser.currentScriptOrFn.getNextTempName());
            fn.setIsGenerator();
            fn.setFunctionType(2);
            fn.setRequiresActivation();
            Node mexpr = this.decompileFunctionHeader(fn);
            int index = this.parser.currentScriptOrFn.addFunction(fn);
            Parser.PerFunctionVariables savedVars = this.parser.createPerFunctionVariables(fn);
            try {
                Node destructuring = (Node)fn.getProp(23);
                fn.removeProp(23);
                int lineno = node.lineno;
                ++this.parser.nestingOfFunction;
                Node body = this.genExprTransformHelper(node);
                if (destructuring != null) {
                    body.addChildToFront(new Node(141, destructuring, lineno));
                }
                int syntheticType = fn.getFunctionType();
                pn = IRFactory.initFunction(fn, index, body, syntheticType);
                if (mexpr == null) break block8;
                this.astNodePos.push(fn);
                try {
                    pn = this.createAssignment(93, mexpr, pn);
                }
                finally {
                    this.astNodePos.pop();
                }
                if (syntheticType != 2) {
                    pn = IRFactory.createExprStatementNoReturn(pn, fn.getLineno());
                }
            }
            finally {
                --this.parser.nestingOfFunction;
                savedVars.restore();
            }
        }
        Node call = this.createCallOrNew(38, pn);
        call.setLineno(node.getLineno());
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node genExprTransformHelper(GeneratorExpression node) {
        int i;
        int lineno = node.getLineno();
        Node expr = this.transform(node.getResult());
        List<GeneratorExpressionLoop> loops = node.getLoops();
        int numLoops = loops.size();
        Node[] iterators = new Node[numLoops];
        Node[] iteratedObjs = new Node[numLoops];
        for (int i2 = 0; i2 < numLoops; ++i2) {
            GeneratorExpressionLoop acl = loops.get(i2);
            AstNode iter = acl.getIterator();
            this.astNodePos.push(iter);
            try {
                String name = null;
                if (iter.getType() == 39) {
                    name = iter.getString();
                } else {
                    name = this.parser.currentScriptOrFn.getNextTempName();
                    this.parser.defineSymbol(90, name, false);
                    expr = IRFactory.createBinary(92, this.createAssignment(93, iter, this.parser.createName(name)), expr);
                }
                Node init = this.parser.createName(name);
                this.parser.defineSymbol(161, name, false);
                iterators[i2] = init;
            }
            finally {
                this.astNodePos.pop();
            }
            iteratedObjs[i2] = this.transform(acl.getIteratedObject());
        }
        Node yield = new Node(73, expr, node.getLineno());
        Node body = new Node(141, yield, lineno);
        if (node.getFilter() != null) {
            body = IRFactory.createIf(this.transform(node.getFilter()), body, null, lineno);
        }
        int pushed = 0;
        try {
            for (i = numLoops - 1; i >= 0; --i) {
                GeneratorExpressionLoop acl = loops.get(i);
                Scope loop = this.createLoopNode(null, acl.getLineno());
                this.parser.pushScope(loop);
                ++pushed;
                body = this.createForIn(161, loop, iterators[i], iteratedObjs[i], body, acl, acl.isForEach(), acl.isForOf());
            }
        }
        finally {
            for (i = 0; i < pushed; ++i) {
                this.parser.popScope();
            }
        }
        return body;
    }

    private Node transformIf(IfStatement n) {
        Node cond = this.transform(n.getCondition());
        Node ifTrue = this.transform(n.getThenPart());
        Node ifFalse = null;
        if (n.getElsePart() != null) {
            ifFalse = this.transform(n.getElsePart());
        }
        return IRFactory.createIf(cond, ifTrue, ifFalse, n.getLineno());
    }

    private Node transformInfix(InfixExpression node) {
        Node left = this.transform(node.getLeft());
        Node right = this.transform(node.getRight());
        return IRFactory.createBinary(node.getType(), left, right);
    }

    private Node transformLabeledStatement(LabeledStatement ls) {
        Label label = ls.getFirstLabel();
        Node statement = this.transform(ls.getStatement());
        Node breakTarget = Node.newTarget();
        Node block = new Node(137, (Node)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformLetNode(LetNode node) {
        this.parser.pushScope(node);
        try {
            boolean letExpr;
            Node vars = this.transformVariableInitializers(node.getVariables());
            node.addChildToBack(vars);
            boolean bl = letExpr = node.getType() == 166;
            if (node.getBody() != null) {
                node.addChildToBack(this.transform(node.getBody()));
            }
            LetNode letNode = node;
            return letNode;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformLiteral(AstNode node) {
        return node;
    }

    private Node transformName(Name node) {
        return node;
    }

    private Node transformNewExpr(NewExpression node) {
        Node nx = this.createCallOrNew(30, this.transform(node.getTarget()));
        nx.setLineno(node.getLineno());
        List<AstNode> args = node.getArguments();
        for (int i = 0; i < args.size(); ++i) {
            AstNode arg = args.get(i);
            nx.addChildToBack(this.transform(arg));
        }
        if (node.getInitializer() != null) {
            nx.addChildToBack(this.transformObjectLiteral(node.getInitializer()));
        }
        return nx;
    }

    private Node transformNumber(NumberLiteral node) {
        return node;
    }

    private Node transformObjectLiteral(ObjectLiteral node) {
        Object[] properties;
        if (node.isDestructuring()) {
            return node;
        }
        List<ObjectProperty> elems = node.getElements();
        Node object = new Node(67);
        if (elems.isEmpty()) {
            properties = ScriptRuntime.emptyArgs;
        } else {
            int size = elems.size();
            int i = 0;
            properties = new Object[size];
            for (ObjectProperty prop : elems) {
                Object propKey = Parser.getPropKey(prop.getLeft());
                if (propKey == null) {
                    Node theId = this.transform(prop.getLeft());
                    properties[i++] = theId;
                } else {
                    properties[i++] = propKey;
                }
                Node right = this.transform(prop.getRight());
                if (prop.isGetterMethod()) {
                    right = IRFactory.createUnary(159, right);
                } else if (prop.isSetterMethod()) {
                    right = IRFactory.createUnary(160, right);
                } else if (prop.isNormalMethod()) {
                    right = IRFactory.createUnary(171, right);
                }
                object.addChildToBack(right);
            }
        }
        object.putProp(12, properties);
        return object;
    }

    private Node transformParenExpr(ParenthesizedExpression node) {
        AstNode expr = node.getExpression();
        while (expr instanceof ParenthesizedExpression) {
            expr = ((ParenthesizedExpression)expr).getExpression();
        }
        Node result = this.transform(expr);
        result.putProp(19, Boolean.TRUE);
        return result;
    }

    private Node transformComputedPropertyKey(ComputedPropertyKey node) {
        Node transformedExpression = this.transform(node.getExpression());
        return new Node(node.type, transformedExpression);
    }

    private Node transformPropertyGet(PropertyGet node) {
        Node target = this.transform(node.getTarget());
        String name = node.getProperty().getIdentifier();
        return this.createPropertyGet(target, null, name, 0, node.type);
    }

    private Node transformTemplateLiteral(TemplateLiteral node) {
        List<AstNode> elems = node.getElements();
        Node pn = Node.newString("");
        for (AstNode elem : elems) {
            if (elem.getType() != 175) {
                pn = IRFactory.createBinary(21, pn, this.transform(elem));
                continue;
            }
            TemplateCharacters chars = (TemplateCharacters)elem;
            String value = chars.getValue();
            if (value.length() <= 0) continue;
            pn = IRFactory.createBinary(21, pn, Node.newString(value));
        }
        return pn;
    }

    private Node transformTemplateLiteralCall(TaggedTemplateLiteral node) {
        Node call = this.createCallOrNew(38, this.transform(node.getTarget()));
        call.setLineno(node.getLineno());
        TemplateLiteral templateLiteral = (TemplateLiteral)node.getTemplateLiteral();
        List<AstNode> elems = templateLiteral.getElements();
        call.addChildToBack(templateLiteral);
        for (AstNode elem : elems) {
            if (elem.getType() == 175) continue;
            call.addChildToBack(this.transform(elem));
        }
        this.parser.currentScriptOrFn.addTemplateLiteral(templateLiteral);
        return call;
    }

    private Node transformRegExp(RegExpLiteral node) {
        this.parser.currentScriptOrFn.addRegExp(node);
        return node;
    }

    private Node transformReturn(ReturnStatement node) {
        AstNode rv = node.getReturnValue();
        Node value = rv == null ? null : this.transform(rv);
        return rv == null ? new Node(4, node.getLineno()) : new Node(4, value, node.getLineno());
    }

    private Node transformScript(ScriptNode node) {
        if (this.parser.currentScope != null) {
            Kit.codeBug();
        }
        this.parser.currentScope = node;
        Node body = new Node(137);
        for (Node kid : node) {
            body.addChildToBack(this.transform((AstNode)kid));
        }
        node.removeChildren();
        Node children = body.getFirstChild();
        if (children != null) {
            node.addChildrenToBack(children);
        }
        return node;
    }

    private Node transformString(StringLiteral node) {
        return Node.newString(node.getValue());
    }

    private Node transformSwitch(SwitchStatement node) {
        Node switchExpr = this.transform(node.getExpression());
        node.addChildToBack(switchExpr);
        Node block = new Node(137, (Node)node, node.getLineno());
        for (SwitchCase sc : node.getCases()) {
            AstNode expr = sc.getExpression();
            Node caseExpr = null;
            if (expr != null) {
                caseExpr = this.transform(expr);
            }
            List<AstNode> stmts = sc.getStatements();
            Block body = new Block();
            if (stmts != null) {
                for (AstNode kid : stmts) {
                    body.addChildToBack(this.transform(kid));
                }
            }
            IRFactory.addSwitchCase(block, caseExpr, body);
        }
        IRFactory.closeSwitch(block);
        return block;
    }

    private Node transformThrow(ThrowStatement node) {
        Node value = this.transform(node.getExpression());
        return new Node(50, value, node.getLineno());
    }

    private Node transformTry(TryStatement node) {
        Node tryBlock = this.transform(node.getTryBlock());
        Block catchBlocks = new Block();
        for (CatchClause cc : node.getCatchClauses()) {
            Name varName = cc.getVarName();
            Node catchCond = null;
            Node varNameNode = null;
            if (varName != null) {
                varNameNode = this.parser.createName(varName.getIdentifier());
                AstNode ccc = cc.getCatchCondition();
                catchCond = ccc != null ? this.transform(ccc) : new EmptyExpression();
            }
            Node body = this.transform(cc.getBody());
            catchBlocks.addChildToBack(this.createCatch(varNameNode, catchCond, body, cc.getLineno()));
        }
        Node finallyBlock = null;
        if (node.getFinallyBlock() != null) {
            finallyBlock = this.transform(node.getFinallyBlock());
        }
        return this.createTryCatchFinally(tryBlock, catchBlocks, finallyBlock, node.getLineno());
    }

    private Node transformUnary(UnaryExpression node) {
        int type = node.getType();
        if (type == 76) {
            return this.transformDefaultXmlNamespace(node);
        }
        Node child = this.transform(node.getOperand());
        return IRFactory.createUnary(type, child);
    }

    private Node transformUpdate(UpdateExpression node) {
        int type = node.getType();
        Node child = this.transform(node.getOperand());
        return IRFactory.createIncDec(type, node.isPostfix(), child);
    }

    private Node transformVariables(VariableDeclaration node) {
        this.transformVariableInitializers(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformVariableInitializers(VariableDeclaration node) {
        List<VariableInitializer> vars = node.getVariables();
        for (VariableInitializer var : vars) {
            AstNode target = var.getTarget();
            AstNode init = var.getInitializer();
            Node left = null;
            left = var.isDestructuring() ? target : this.transform(target);
            Node right = null;
            if (init != null) {
                right = this.transform(init);
            }
            if (var.isDestructuring()) {
                if (right == null) {
                    node.addChildToBack(left);
                    continue;
                }
                this.astNodePos.push(var);
                try {
                    Node d = this.parser.createDestructuringAssignment(node.getType(), left, right, this::transform);
                    node.addChildToBack(d);
                    continue;
                }
                finally {
                    this.astNodePos.pop();
                    continue;
                }
            }
            if (right != null) {
                left.addChildToBack(right);
            }
            node.addChildToBack(left);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformWhileLoop(WhileLoop loop) {
        loop.setType(140);
        this.parser.pushScope(loop);
        try {
            Node cond = this.transform(loop.getCondition());
            Node body = this.transform(loop.getBody());
            Node node = IRFactory.createLoop(loop, 1, body, cond, null, null);
            return node;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformWith(WithStatement node) {
        Node expr = this.transform(node.getExpression());
        Node stmt = this.transform(node.getStatement());
        return this.createWith(expr, stmt, node.getLineno());
    }

    private Node transformYield(Yield node) {
        Node kid;
        Node node2 = kid = node.getValue() == null ? null : this.transform(node.getValue());
        if (kid != null) {
            return new Node(node.getType(), kid, node.getLineno());
        }
        return new Node(node.getType(), node.getLineno());
    }

    private Node transformXmlLiteral(XmlLiteral node) {
        Node pnXML = new Node(30, node.getLineno());
        List<XmlFragment> frags = node.getFragments();
        XmlString first = (XmlString)frags.get(0);
        boolean anon = first.getXml().trim().startsWith("<>");
        pnXML.addChildToBack(this.parser.createName(anon ? "XMLList" : "XML"));
        Node pn = null;
        for (XmlFragment frag : frags) {
            if (frag instanceof XmlString) {
                String xml = ((XmlString)frag).getXml();
                if (pn == null) {
                    pn = IRFactory.createString(xml);
                    continue;
                }
                pn = IRFactory.createBinary(21, pn, IRFactory.createString(xml));
                continue;
            }
            XmlExpression xexpr = (XmlExpression)frag;
            boolean isXmlAttr = xexpr.isXmlAttribute();
            Node expr = xexpr.getExpression() instanceof EmptyExpression ? IRFactory.createString("") : this.transform(xexpr.getExpression());
            if (isXmlAttr) {
                expr = IRFactory.createUnary(77, expr);
                Node prepend = IRFactory.createBinary(21, IRFactory.createString("\""), expr);
                expr = IRFactory.createBinary(21, prepend, IRFactory.createString("\""));
            } else {
                expr = IRFactory.createUnary(78, expr);
            }
            pn = IRFactory.createBinary(21, pn, expr);
        }
        pnXML.addChildToBack(pn);
        return pnXML;
    }

    private Node transformXmlMemberGet(XmlMemberGet node) {
        int flags;
        XmlRef ref = node.getMemberRef();
        Node pn = this.transform(node.getLeft());
        int n = flags = ref.isAttributeAccess() ? 2 : 0;
        if (node.getType() == 151) {
            flags |= 4;
        }
        return this.transformXmlRef(pn, ref, flags);
    }

    private Node transformXmlRef(XmlRef node) {
        int memberTypeFlags = node.isAttributeAccess() ? 2 : 0;
        return this.transformXmlRef(null, node, memberTypeFlags);
    }

    private Node transformXmlRef(Node pn, XmlRef node, int memberTypeFlags) {
        String ns;
        Name namespace = node.getNamespace();
        String string = ns = namespace != null ? namespace.getIdentifier() : null;
        if (node instanceof XmlPropRef) {
            String name = ((XmlPropRef)node).getPropName().getIdentifier();
            return this.createPropertyGet(pn, ns, name, memberTypeFlags, node.type);
        }
        Node expr = this.transform(((XmlElemRef)node).getExpression());
        return this.createElementGet(pn, ns, expr, memberTypeFlags);
    }

    private Node transformDefaultXmlNamespace(UnaryExpression node) {
        Node child = this.transform(node.getOperand());
        return IRFactory.createUnary(76, child);
    }

    private static void addSwitchCase(Node switchBlock, Node caseExpression, Node statements) {
        if (switchBlock.getType() != 137) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 121) {
            throw Kit.codeBug();
        }
        Node gotoTarget = Node.newTarget();
        if (caseExpression != null) {
            Jump caseNode = new Jump(122, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    private static void closeSwitch(Node switchBlock) {
        Node switchBreakTarget;
        if (switchBlock.getType() != 137) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 121) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = Node.newTarget();
        Node defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(IRFactory.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    private static Node createExprStatementNoReturn(Node expr, int lineno) {
        return new Node(141, expr, lineno);
    }

    private static Node createString(String string) {
        return Node.newString(string);
    }

    private Node createCatch(Node varName, Node catchCond, Node stmts, int lineno) {
        if (varName == null) {
            varName = new Node(135);
        }
        if (catchCond == null) {
            catchCond = new Node(135);
        }
        return new Node(131, varName, catchCond, stmts, lineno);
    }

    private static Node initFunction(FunctionNode fnNode, int functionIndex, Node statements, int functionType) {
        Node lastStmt;
        Name name;
        fnNode.setFunctionType(functionType);
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.setRequiresActivation();
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0 && fnNode.getSymbol(name.getIdentifier()) == null) {
            fnNode.putSymbol(new Symbol(116, name.getIdentifier()));
            Node setFn = new Node(141, new Node(8, Node.newString(49, name.getIdentifier()), new Node(64)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new Node(4));
        }
        Node result = Node.newString(116, fnNode.getName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    private Scope createLoopNode(Node loopLabel, int lineno) {
        Scope result = this.parser.createScopeNode(140, lineno);
        if (loopLabel != null) {
            ((Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    private static Node createFor(Scope loop, Node init, Node test, Node incr, Node body) {
        if (init.getType() == 161) {
            Scope let = Scope.splitScope(loop);
            let.setType(161);
            let.addChildrenToBack(init);
            let.addChildToBack(IRFactory.createLoop(loop, 2, body, test, new Node(135), incr));
            return let;
        }
        return IRFactory.createLoop(loop, 2, body, test, init, incr);
    }

    private static Node createLoop(Jump loop, int loopType, Node body, Node cond, Node init, Node incr) {
        Node bodyTarget = Node.newTarget();
        Node condTarget = Node.newTarget();
        if (loopType == 2 && cond.getType() == 135) {
            cond = new Node(45);
        }
        Jump IFEQ = new Jump(6, cond);
        IFEQ.target = bodyTarget;
        Node breakTarget = Node.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new Node(135, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(IRFactory.makeJump(5, condTarget));
            if (loopType == 2) {
                int initType = init.getType();
                if (initType != 135) {
                    if (initType != 129 && initType != 161) {
                        init = new Node(141, init);
                    }
                    loop.addChildToFront(init);
                }
                Node incrTarget = Node.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 135) {
                    incr = new Node(141, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node createForIn(int declType, Node loop, Node lhs, Node obj, Node body, AstNode ast, boolean isForEach, boolean isForOf) {
        this.astNodePos.push(ast);
        try {
            Node assign;
            Node lvalue;
            int type;
            int destructuringLen;
            int destructuring;
            block18: {
                block17: {
                    destructuring = -1;
                    destructuringLen = 0;
                    type = lhs.getType();
                    if (type != 129 && type != 161) break block17;
                    Node kid = lhs.getLastChild();
                    int kidType = kid.getType();
                    if (kidType == 66 || kidType == 67) {
                        type = destructuring = kidType;
                        lvalue = kid;
                        destructuringLen = 0;
                        if (kid instanceof ArrayLiteral) {
                            destructuringLen = ((ArrayLiteral)kid).getDestructuringLength();
                        }
                        break block18;
                    } else {
                        if (kidType != 39) {
                            this.parser.reportError("msg.bad.for.in.lhs");
                            Node node = null;
                            return node;
                        }
                        lvalue = Node.newString(39, kid.getString());
                    }
                    break block18;
                }
                if (type == 66 || type == 67) {
                    destructuring = type;
                    lvalue = lhs;
                    destructuringLen = 0;
                    if (lhs instanceof ArrayLiteral) {
                        destructuringLen = ((ArrayLiteral)lhs).getDestructuringLength();
                    }
                } else {
                    lvalue = IRFactory.makeReference(lhs);
                    if (lvalue == null) {
                        this.parser.reportError("msg.bad.for.in.lhs");
                        Node kid = null;
                        return kid;
                    }
                }
            }
            Node localBlock = new Node(149);
            int initType = isForEach ? 59 : (isForOf ? 61 : (destructuring != -1 ? 60 : 58));
            Node init = new Node(initType, obj);
            init.putProp(3, localBlock);
            Node cond = new Node(62);
            cond.putProp(3, localBlock);
            Node id = new Node(63);
            id.putProp(3, localBlock);
            Node newBody = new Node(137);
            if (destructuring != -1) {
                assign = this.parser.createDestructuringAssignment(declType, lvalue, id, this::transform);
                if (!(isForEach || isForOf || destructuring != 67 && destructuringLen == 2)) {
                    this.parser.reportError("msg.bad.for.in.destruct");
                }
            } else {
                assign = this.parser.simpleAssignment(lvalue, id);
            }
            newBody.addChildToBack(new Node(141, assign));
            newBody.addChildToBack(body);
            loop = IRFactory.createLoop((Jump)loop, 1, newBody, cond, null, null);
            loop.addChildToFront(init);
            if (type == 129 || type == 161) {
                loop.addChildToFront(lhs);
            }
            localBlock.addChildToBack(loop);
            Node node = localBlock;
            return node;
        }
        finally {
            this.astNodePos.pop();
        }
    }

    private Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 137 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 137 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        Node handlerBlock = new Node(149);
        Jump pn = new Jump(84, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            Node catchTarget;
            Node endCatch = Node.newTarget();
            pn.addChildToBack(IRFactory.makeJump(5, endCatch));
            pn.target = catchTarget = Node.newTarget();
            pn.addChildToBack(catchTarget);
            Node catchScopeBlock = new Node(149);
            Node cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                Node condStmt;
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node cond = name.getNext();
                Node catchStatement = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new Node(3));
                catchStatement.addChildToBack(IRFactory.makeJump(5, endCatch));
                if (cond.getType() == 135) {
                    condStmt = catchStatement;
                    hasDefault = true;
                } else {
                    condStmt = IRFactory.createIf(cond, catchStatement, null, catchLineNo);
                }
                Node catchScope = new Node(57, name, IRFactory.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(IRFactory.createUseLocal(catchScopeBlock), condStmt, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                Node rethrow = new Node(51);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            Node finallyTarget = Node.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(IRFactory.makeJump(143, finallyTarget));
            Node finallyEnd = Node.newTarget();
            pn.addChildToBack(IRFactory.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(132, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    private Node createWith(Node obj, Node body, int lineno) {
        this.parser.setRequiresActivation();
        Node result = new Node(137, lineno);
        result.addChildToBack(new Node(2, obj));
        Node bodyNode = new Node(130, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(3));
        return result;
    }

    private static Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(137, lineno);
        }
        Node result = new Node(137, lineno);
        Node ifNotTarget = Node.newTarget();
        Jump IFNE = new Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            Node endTarget = Node.newTarget();
            result.addChildToBack(IRFactory.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    private static Node createCondExpr(Node cond, Node ifTrue, Node ifFalse) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(109, cond, ifTrue, ifFalse);
    }

    private static Node createUnary(int nodeType, Node child) {
        int childType = child.getType();
        switch (nodeType) {
            case 31: {
                Node n;
                if (childType == 39) {
                    child.setType(49);
                    Node right = Node.newString(child.getString());
                    n = new Node(nodeType, child, right);
                } else if (childType == 33 || childType == 36) {
                    Node left = child.getFirstChild();
                    Node right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new Node(nodeType, left, right);
                } else if (childType == 68) {
                    Node ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new Node(70, ref);
                } else {
                    n = new Node(nodeType, new Node(45), child);
                }
                return n;
            }
            case 32: {
                if (childType != 39) break;
                child.setType(145);
                return child;
            }
            case 27: {
                if (childType != 40) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 29: {
                if (childType != 40) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 26: {
                int status = IRFactory.isAlwaysDefinedBoolean(child);
                if (status == 0) break;
                int type = status == 1 ? 44 : 45;
                if (childType == 45 || childType == 44) {
                    child.setType(type);
                    return child;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, child);
    }

    private Node createCallOrNew(int nodeType, Node child) {
        String name;
        int type = 0;
        if (child.getType() == 39) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child);
        if (type != 0) {
            this.parser.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    private static Node createIncDec(int nodeType, boolean post, Node child) {
        child = IRFactory.makeReference(child);
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                Node n = new Node(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 114) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    private Node createPropertyGet(Node target, String namespace, String name, int memberTypeFlags, int type) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.parser.createName(name);
            }
            this.parser.checkActivationName(name, 33);
            if (ScriptRuntime.isSpecialProperty(name)) {
                Node ref = new Node(72, target);
                ref.putProp(17, name);
                Node getRef = new Node(68, ref);
                if (type == 180) {
                    ref.putIntProp(30, 1);
                    getRef.putIntProp(30, 1);
                }
                return getRef;
            }
            Node node = new Node(33, target, Node.newString(name));
            if (type == 180) {
                node.putIntProp(30, 1);
            }
            return node;
        }
        Node elem = Node.newString(name);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1);
    }

    private Node createElementGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                throw Kit.codeBug();
            }
            return new Node(36, target, elem);
        }
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags);
    }

    private Node createMemberRefGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        Node nsNode = null;
        if (namespace != null) {
            nsNode = namespace.equals("*") ? new Node(42) : this.parser.createName(namespace);
        }
        Node ref = target == null ? (namespace == null ? new Node(81, elem) : new Node(82, nsNode, elem)) : (namespace == null ? new Node(79, target, elem) : new Node(80, target, nsNode, elem));
        if (memberTypeFlags != 0) {
            ref.putIntProp(16, memberTypeFlags);
        }
        return new Node(68, ref);
    }

    private static Node createBinary(int nodeType, Node left, Node right) {
        switch (nodeType) {
            case 21: {
                if (left.type == 41) {
                    String s2;
                    if (right.type == 41) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 40) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 40) break;
                if (right.type == 40) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 41) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(29, right);
                }
                if (right.type != 40 || right.getDouble() != 0.0) break;
                return new Node(28, left);
            }
            case 23: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(28, right);
                }
                if (right.type != 40 || right.getDouble() != 1.0) break;
                return new Node(28, left);
            }
            case 24: {
                if (right.type != 40) break;
                double rd = right.getDouble();
                if (left.type == 40) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(28, left);
            }
            case 112: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 111: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new Node(nodeType, left, right);
    }

    private Node createAssignment(int assignType, Node left, Node right) {
        int assignOp;
        Node ref = IRFactory.makeReference(left);
        if (ref == null) {
            if (left.getType() == 66 || left.getType() == 67) {
                if (assignType != 93) {
                    this.parser.reportError("msg.bad.destruct.op");
                    return right;
                }
                return this.parser.createDestructuringAssignment(-1, left, right, this::transform);
            }
            this.parser.reportError("msg.bad.assign.left");
            return right;
        }
        left = ref;
        switch (assignType) {
            case 93: {
                return this.parser.simpleAssignment(left, right);
            }
            case 94: {
                assignOp = 9;
                break;
            }
            case 95: {
                assignOp = 111;
                break;
            }
            case 96: {
                assignOp = 10;
                break;
            }
            case 97: {
                assignOp = 11;
                break;
            }
            case 98: {
                assignOp = 112;
                break;
            }
            case 99: {
                assignOp = 18;
                break;
            }
            case 100: {
                assignOp = 19;
                break;
            }
            case 101: {
                assignOp = 20;
                break;
            }
            case 102: {
                assignOp = 21;
                break;
            }
            case 103: {
                assignOp = 22;
                break;
            }
            case 104: {
                assignOp = 23;
                break;
            }
            case 105: {
                assignOp = 24;
                break;
            }
            case 106: {
                assignOp = 25;
                break;
            }
            case 107: {
                assignOp = 75;
                break;
            }
            case 108: {
                assignOp = 179;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                Node op = new Node(assignOp, left, right);
                Node lvalueLeft = Node.newString(49, left.getString());
                return new Node(8, lvalueLeft, op);
            }
            case 33: 
            case 36: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 147 : 148;
                Node opLeft = new Node(146);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
            case 68: {
                ref = left.getFirstChild();
                this.parser.checkMutableReference(ref);
                Node opLeft = new Node(146);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(150, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    private static Node createUseLocal(Node localBlock) {
        if (149 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        Node result = new Node(54);
        result.putProp(3, localBlock);
        return result;
    }

    private static Jump makeJump(int type, Node target) {
        Jump n = new Jump(type);
        n.target = target;
        return n;
    }

    private static Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                return node;
            }
            case 38: {
                node.setType(71);
                return new Node(68, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double num = node.getDouble();
                if (!Double.isNaN(num) && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    boolean isDestructuring(Node n) {
        return n instanceof DestructuringForm && ((DestructuringForm)((Object)n)).isDestructuring();
    }

    Node decompileFunctionHeader(FunctionNode fn) {
        if (fn.getFunctionName() != null) {
            return null;
        }
        if (fn.getMemberExprNode() != null) {
            return this.transform(fn.getMemberExprNode());
        }
        return null;
    }

    public static class AstNodePosition
    implements Parser.CurrentPositionReporter {
        private ArrayDeque<AstNode> stack = new ArrayDeque();
        private String sourceString;
        private int savedLineno = -1;
        private String savedLine;
        private int savedLineOffset;

        public AstNodePosition(String sourceString) {
            this.sourceString = sourceString;
        }

        public void push(AstNode node) {
            this.stack.push(node);
        }

        public void pop() {
            this.stack.pop();
        }

        @Override
        public int getPosition() {
            return this.stack.peek().getAbsolutePosition();
        }

        @Override
        public int getLength() {
            return this.stack.peek().getLength();
        }

        @Override
        public int getLineno() {
            return this.stack.peek().getLineno();
        }

        private void cutAndSaveLine() {
            char c;
            int end;
            int begin;
            int lineno = this.getLineno();
            if (this.savedLineno == lineno) {
                return;
            }
            int l = 1;
            boolean isPrevCR = false;
            for (begin = 0; begin < this.sourceString.length(); ++begin) {
                char c2 = this.sourceString.charAt(begin);
                if (isPrevCR && c2 == '\n') continue;
                boolean bl = isPrevCR = c2 == '\r';
                if (l == lineno) break;
                if (!ScriptRuntime.isJSLineTerminator(c2)) continue;
                ++l;
            }
            for (end = begin; end < this.sourceString.length() && !ScriptRuntime.isJSLineTerminator(c = this.sourceString.charAt(end)); ++end) {
            }
            this.savedLineno = lineno;
            if (end == 0) {
                this.savedLine = "";
                this.savedLineOffset = 0;
            } else {
                this.savedLine = this.sourceString.substring(begin, end);
                this.savedLineOffset = this.getPosition() - begin + 1;
            }
        }

        @Override
        public String getLine() {
            this.cutAndSaveLine();
            return this.savedLine;
        }

        @Override
        public int getOffset() {
            this.cutAndSaveLine();
            return this.savedLineOffset;
        }
    }
}

