/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.WeakHashMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeMap;
import org.htmlunit.corejs.javascript.NativeSet;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;

public class NativeWeakSet
extends ScriptableObject {
    private static final long serialVersionUID = 2065753364224029534L;
    private static final String CLASS_NAME = "WeakSet";
    private boolean instanceOfWeakSet = false;
    private transient WeakHashMap<Scriptable, Boolean> map = new WeakHashMap();

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 0, 2, NativeWeakSet::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeMethod(scope, "add", 1, (lcx, lscope, thisObj, args) -> NativeWeakSet.realThis(thisObj, "add").js_add(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "delete", 1, (lcx, lscope, thisObj, args) -> NativeWeakSet.realThis(thisObj, "delete").js_delete(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "has", 1, (lcx, lscope, thisObj, args) -> NativeWeakSet.realThis(thisObj, "has").js_has(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeWeakSet ns = new NativeWeakSet();
        ns.instanceOfWeakSet = true;
        if (args.length > 0) {
            NativeSet.loadFromIterable(cx, scope, ns, NativeMap.key(args));
        }
        return ns;
    }

    private Object js_add(Object key) {
        if (!NativeWeakSet.isValidValue(key)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(key));
        }
        this.map.put((Scriptable)key, Boolean.TRUE);
        return this;
    }

    private Object js_delete(Object key) {
        if (!NativeWeakSet.isValidValue(key)) {
            return Boolean.FALSE;
        }
        return this.map.remove(key) != null;
    }

    private Object js_has(Object key) {
        if (!NativeWeakSet.isValidValue(key)) {
            return Boolean.FALSE;
        }
        return this.map.containsKey(key);
    }

    private static boolean isValidValue(Object v) {
        return ScriptRuntime.isUnregisteredSymbol(v) || ScriptRuntime.isObject(v);
    }

    private static NativeWeakSet realThis(Scriptable thisObj, String name) {
        NativeWeakSet ns = LambdaConstructor.convertThisObject(thisObj, NativeWeakSet.class);
        if (!ns.instanceOfWeakSet) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", name);
        }
        return ns;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.map = new WeakHashMap();
    }
}

