/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Hashtable;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeCollectionIterator;
import org.htmlunit.corejs.javascript.NativeMap;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class NativeSet
extends ScriptableObject {
    private static final long serialVersionUID = -8442212766987072986L;
    private static final String CLASS_NAME = "Set";
    static final String ITERATOR_TAG = "Set Iterator";
    static final SymbolKey GETSIZE = new SymbolKey("[Symbol.getSize]");
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfSet = false;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 0, 2, NativeSet::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeMethod(scope, "add", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "add").js_add(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "delete", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "delete").js_delete(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "has", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "has").js_has(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "clear", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "clear").js_clear(), 2, 3);
        constructor.definePrototypeMethod(scope, "values", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "values").js_iterator(scope, NativeCollectionIterator.Type.VALUES), 2, 3);
        constructor.definePrototypeAlias("values", "keys", 3);
        constructor.definePrototypeAlias("values", SymbolKey.ITERATOR, 2);
        constructor.definePrototypeMethod(scope, "forEach", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "forEach").js_forEach(lcx, lscope, NativeMap.key(args), args.length > 1 ? args[1] : Undefined.instance), 2, 3);
        constructor.definePrototypeMethod(scope, "entries", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "entries").js_iterator(scope, NativeCollectionIterator.Type.BOTH), 2, 3);
        constructor.definePrototypeMethod(scope, "intersection", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "intersection").js_intersection(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "union", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "union").js_union(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "difference", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "difference").js_difference(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "symmetricDifference", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "symmetricDifference").js_symmetricDifference(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "isSubsetOf", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "isSubsetOf").js_isSubsetOf(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "isSupersetOf", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "isSupersetOf").js_isSupersetOf(lcx, lscope, args), 2, 3);
        constructor.definePrototypeMethod(scope, "isDisjointFrom", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "isDisjointFrom").js_isDisjointFrom(lcx, lscope, args), 2, 3);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put("configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        LambdaFunction sizeFunc = new LambdaFunction(scope, "get size", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "size").js_getSize());
        sizeFunc.setPrototypeProperty(Undefined.instance);
        desc.put("get", (Scriptable)desc, (Object)sizeFunc);
        constructor.definePrototypeProperty(cx, "size", desc);
        constructor.definePrototypeProperty(cx, GETSIZE, desc);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeSet ns = new NativeSet();
        ns.instanceOfSet = true;
        if (args.length > 0) {
            NativeSet.loadFromIterable(cx, scope, ns, NativeMap.key(args));
        }
        return ns;
    }

    private Object js_add(Object k) {
        if (k instanceof Number && ((Number)k).doubleValue() == ScriptRuntime.negativeZero) {
            this.entries.put(ScriptRuntime.zeroObj, ScriptRuntime.zeroObj);
            return this;
        }
        this.entries.put(k, k);
        return this;
    }

    private Object js_delete(Object arg) {
        return this.entries.deleteEntry(arg);
    }

    private Object js_has(Object arg) {
        if (arg instanceof Number && ((Number)arg).doubleValue() == ScriptRuntime.negativeZero) {
            return this.entries.has(ScriptRuntime.zeroObj);
        }
        return this.entries.has(arg);
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(arg1);
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = entry;
            f.call(cx, scope, thisObj, new Object[]{e.value, e.value, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject set, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeSet.ensureScriptableObject(cx.newObject(scope, set.getClassName()));
        ScriptRuntime.LookupResult addCall = ScriptRuntime.getPropAndThis(dummy.getPrototype(), "add", cx, scope);
        Callable add = addCall.getCallable();
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal = val == Scriptable.NOT_FOUND ? Undefined.instance : val;
                add.call(cx, scope, set, new Object[]{finalVal});
            }
        }
    }

    private static NativeSet realThis(Scriptable thisObj, String name) {
        NativeSet ns = LambdaConstructor.convertThisObject(thisObj, NativeSet.class);
        if (!ns.instanceOfSet) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", name);
        }
        return ns;
    }

    private Object js_intersection(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        NativeSet result = (NativeSet)cx.newObject(scope, CLASS_NAME);
        result.instanceOfSet = true;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        return this.js_intersectionSetLike(cx, scope, otherObj, result, sizeVal, hasVal, keysVal);
    }

    private Object js_intersectionSetLike(Context cx, Scriptable scope, Object otherObj, NativeSet result, Object sizeVal, Object hasVal, Object keysVal) {
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable hasMethod = (Callable)hasVal;
        Callable keysMethod = (Callable)keysVal;
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        int otherSize = Double.isInfinite(otherSizeDouble) ? Integer.MAX_VALUE : (int)Math.floor(otherSizeDouble);
        int thisSize = this.entries.size();
        if (thisSize <= otherSize) {
            for (Hashtable.Entry entry : this.entries) {
                Object key = entry.key;
                Object inOther = NativeSet.callHas(cx, scope, otherObj, hasMethod, key);
                if (!ScriptRuntime.toBoolean(inOther)) continue;
                result.js_add(key);
            }
        } else {
            Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, ScriptableObject.ensureScriptable(otherObj), ScriptRuntime.emptyArgs), cx, scope);
            try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
                for (Object key : it) {
                    if (this.js_has(key) != Boolean.TRUE) continue;
                    result.js_add(key);
                }
            }
        }
        return result;
    }

    private Object js_union(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        NativeSet result = (NativeSet)cx.newObject(scope, CLASS_NAME);
        result.instanceOfSet = true;
        for (Hashtable.Entry entry : this.entries) {
            result.js_add(entry.key);
        }
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable keysMethod = (Callable)keysVal;
        Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, scriptable, ScriptRuntime.emptyArgs), cx, scope);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
            for (Object key : it) {
                result.js_add(key);
            }
        }
        return result;
    }

    private Object js_difference(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        NativeSet result = (NativeSet)cx.newObject(scope, CLASS_NAME);
        result.instanceOfSet = true;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        return this.js_differenceSetLike(cx, scope, otherObj, result, sizeVal, hasVal, keysVal);
    }

    private Object js_differenceSetLike(Context cx, Scriptable scope, Object otherObj, NativeSet result, Object sizeVal, Object hasVal, Object keysVal) {
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable hasMethod = (Callable)hasVal;
        Callable keysMethod = (Callable)keysVal;
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        int otherSize = Double.isInfinite(otherSizeDouble) ? Integer.MAX_VALUE : (int)Math.floor(otherSizeDouble);
        int thisSize = this.entries.size();
        if (thisSize > otherSize) {
            for (Hashtable.Entry entry : this.entries) {
                result.js_add(entry.key);
            }
            Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, ScriptableObject.ensureScriptable(otherObj), ScriptRuntime.emptyArgs), cx, scope);
            try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
                for (Object key : it) {
                    if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
                        key = ScriptRuntime.zeroObj;
                    }
                    result.js_delete(key);
                }
            }
        } else {
            for (Hashtable.Entry entry : this.entries) {
                Object key = entry.key;
                Object inOther = NativeSet.callHas(cx, scope, otherObj, hasMethod, key);
                if (ScriptRuntime.toBoolean(inOther)) continue;
                result.js_add(key);
            }
        }
        return result;
    }

    private Object js_symmetricDifference(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        NativeSet result = (NativeSet)cx.newObject(scope, CLASS_NAME);
        result.instanceOfSet = true;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable hasMethod = (Callable)hasVal;
        Callable keysMethod = (Callable)keysVal;
        for (Hashtable.Entry entry : this.entries) {
            Object key = entry.key;
            Object inOther = NativeSet.callHas(cx, scope, otherObj, hasMethod, key);
            if (ScriptRuntime.toBoolean(inOther)) continue;
            result.js_add(key);
        }
        Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, scriptable, ScriptRuntime.emptyArgs), cx, scope);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
            for (Object key : it) {
                if (this.js_has(key) == Boolean.TRUE) continue;
                result.js_add(key);
            }
        }
        return result;
    }

    private Object js_isSubsetOf(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable hasMethod = (Callable)hasVal;
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        int otherSize = Double.isInfinite(otherSizeDouble) ? Integer.MAX_VALUE : (int)Math.floor(otherSizeDouble);
        int thisSize = this.entries.size();
        if (thisSize > otherSize) {
            return Boolean.FALSE;
        }
        for (Hashtable.Entry entry : this.entries) {
            Object key = entry.key;
            Object inOther = NativeSet.callHas(cx, scope, otherObj, hasMethod, key);
            if (ScriptRuntime.toBoolean(inOther)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object js_isSupersetOf(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable keysMethod = (Callable)keysVal;
        Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, scriptable, ScriptRuntime.emptyArgs), cx, scope);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
            for (Object value : it) {
                if (this.js_has(value) == Boolean.TRUE) continue;
                Boolean bl = Boolean.FALSE;
                return bl;
            }
        }
        return Boolean.TRUE;
    }

    private Object js_isDisjointFrom(Context cx, Scriptable scope, Object[] args) {
        Object otherObj = args.length > 0 ? args[0] : Undefined.instance;
        Scriptable scriptable = ScriptableObject.ensureScriptable(otherObj);
        Object sizeVal = ScriptableObject.getProperty(scriptable, "size");
        Object hasVal = ScriptableObject.getProperty(scriptable, "has");
        Object keysVal = ScriptableObject.getProperty(scriptable, "keys");
        NativeSet.validateSetLike(sizeVal, hasVal, keysVal);
        if (!(hasVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "has", ScriptRuntime.typeof(hasVal));
        }
        if (!(keysVal instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", "keys", ScriptRuntime.typeof(keysVal));
        }
        Callable hasMethod = (Callable)hasVal;
        Callable keysMethod = (Callable)keysVal;
        double otherSizeDouble = ScriptRuntime.toNumber(sizeVal);
        if (Double.isNaN(otherSizeDouble)) {
            throw ScriptRuntime.typeError("size is not a number");
        }
        int otherSize = Double.isInfinite(otherSizeDouble) ? Integer.MAX_VALUE : (int)Math.floor(otherSizeDouble);
        int thisSize = this.entries.size();
        if (thisSize <= otherSize) {
            for (Hashtable.Entry entry : this.entries) {
                Object key = entry.key;
                Object inOther = NativeSet.callHas(cx, scope, otherObj, hasMethod, key);
                if (!ScriptRuntime.toBoolean(inOther)) continue;
                return Boolean.FALSE;
            }
        } else {
            Object iterator = ScriptRuntime.callIterator(keysMethod.call(cx, scope, scriptable, ScriptRuntime.emptyArgs), cx, scope);
            try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
                for (Object key : it) {
                    if (this.js_has(key) != Boolean.TRUE) continue;
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
            }
        }
        return Boolean.TRUE;
    }

    private static Object callHas(Context cx, Scriptable scope, Object obj, Object hasMethod, Object key) {
        return ((Callable)hasMethod).call(cx, scope, ScriptableObject.ensureScriptable(obj), new Object[]{key});
    }

    private static void validateSetLike(Object sizeVal, Object hasVal, Object keysVal) {
        if (sizeVal == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeError("Set-like object must have a 'size' property");
        }
        if (hasVal == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeError("Set-like object must have a 'has' method");
        }
        if (keysVal == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeError("Set-like object must have a 'keys' method");
        }
    }
}

