/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import org.htmlunit.corejs.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    private boolean shorthand;

    public void setNodeType(int nodeType) {
        if (nodeType != 116 && nodeType != 165 && nodeType != 166 && nodeType != 177) {
            throw new IllegalArgumentException("invalid node type: " + nodeType);
        }
        this.setType(nodeType);
    }

    public ObjectProperty() {
        this.type = 116;
    }

    public ObjectProperty(int pos) {
        super(pos);
        this.type = 116;
    }

    public ObjectProperty(int pos, int len) {
        super(pos, len);
        this.type = 116;
    }

    public void setIsGetterMethod() {
        this.type = 165;
    }

    public boolean isGetterMethod() {
        return this.type == 165;
    }

    public void setIsSetterMethod() {
        this.type = 166;
    }

    public boolean isSetterMethod() {
        return this.type == 166;
    }

    public void setIsNormalMethod() {
        this.type = 177;
    }

    public boolean isNormalMethod() {
        return this.type == 177;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth + 1));
        if (this.isGetterMethod()) {
            sb.append("get ");
        } else if (this.isSetterMethod()) {
            sb.append("set ");
        }
        sb.append(this.left.toSource(this.getType() == 116 ? 0 : depth));
        if (!this.shorthand) {
            if (this.type == 116) {
                sb.append(": ");
            }
            sb.append(this.right.toSource(this.getType() == 116 ? 0 : depth + 1));
        }
        return sb.toString();
    }
}

