/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.htmlunit.corejs.javascript.EmbeddedSlotMap;
import org.htmlunit.corejs.javascript.HashSlotMap;
import org.htmlunit.corejs.javascript.Slot;
import org.htmlunit.corejs.javascript.SlotMap;

public abstract class SlotMapOwner {
    private static final long serialVersionUID = 1L;
    static final int LARGE_HASH_SIZE = 1536;
    static final SlotMap EMPTY_SLOT_MAP = new EmptySlotMap();
    private SlotMap slotMap;

    protected SlotMapOwner() {
        this.slotMap = SlotMapOwner.createSlotMap(0);
    }

    protected SlotMapOwner(int capacity) {
        this.slotMap = SlotMapOwner.createSlotMap(capacity);
    }

    protected SlotMapOwner(SlotMap map) {
        this.slotMap = map;
    }

    protected static SlotMap createSlotMap(int initialSize) {
        if (initialSize == 0) {
            return EMPTY_SLOT_MAP;
        }
        if (initialSize > 1536) {
            return new HashSlotMap();
        }
        return new EmbeddedSlotMap();
    }

    final SlotMap getMap() {
        return this.slotMap;
    }

    final void setMap(SlotMap newMap) {
        this.slotMap = newMap;
    }

    static class SingleEntrySlotMap
    implements SlotMap {
        protected final Slot slot;

        SingleEntrySlotMap(Slot slot) {
            assert (slot != null);
            this.slot = slot;
        }

        @Override
        public Iterator<Slot> iterator() {
            return new Iter(this.slot);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
            int indexOrHash;
            int n = indexOrHash = key != null ? key.hashCode() : index;
            if (indexOrHash == this.slot.indexOrHash && Objects.equals(this.slot.name, key)) {
                return this.slot;
            }
            Slot newSlot = new Slot(key, index, attributes);
            this.add(owner, newSlot);
            return newSlot;
        }

        @Override
        public Slot query(Object key, int index) {
            int indexOrHash;
            int n = indexOrHash = key != null ? key.hashCode() : index;
            if (indexOrHash == this.slot.indexOrHash && Objects.equals(this.slot.name, key)) {
                return this.slot;
            }
            return null;
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            if (owner == null) {
                throw new IllegalStateException();
            }
            EmbeddedSlotMap newMap = new EmbeddedSlotMap();
            owner.setMap(newMap);
            newMap.add(owner, this.slot);
            newMap.add(owner, newSlot);
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotMap.SlotComputer<S> c) {
            EmbeddedSlotMap newMap = new EmbeddedSlotMap();
            owner.setMap(newMap);
            newMap.add(owner, this.slot);
            return newMap.compute(owner, key, index, c);
        }
    }

    private static final class Iter
    implements Iterator<Slot> {
        private Slot next;

        Iter(Slot slot) {
            this.next = slot;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Slot next() {
            Slot ret = this.next;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.next = this.next.orderedNext;
            return ret;
        }
    }

    private static class EmptySlotMap
    implements SlotMap {
        private EmptySlotMap() {
        }

        @Override
        public Iterator<Slot> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
            Slot newSlot = new Slot(key, index, attributes);
            SingleEntrySlotMap map = new SingleEntrySlotMap(newSlot);
            owner.setMap(map);
            return newSlot;
        }

        @Override
        public Slot query(Object key, int index) {
            return null;
        }

        @Override
        public void add(SlotMapOwner owner, Slot newSlot) {
            if (newSlot != null) {
                SingleEntrySlotMap map = new SingleEntrySlotMap(newSlot);
                owner.setMap(map);
            }
        }

        @Override
        public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotMap.SlotComputer<S> c) {
            S newSlot = c.compute(key, index, null);
            if (newSlot != null) {
                SingleEntrySlotMap map = new SingleEntrySlotMap((Slot)newSlot);
                owner.setMap(map);
            }
            return newSlot;
        }
    }
}

