/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.htmlunit.corejs.javascript.CompilerEnvirons;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ErrorReporter;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.Node;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Token;
import org.htmlunit.corejs.javascript.TokenStream;
import org.htmlunit.corejs.javascript.ast.ArrayComprehension;
import org.htmlunit.corejs.javascript.ast.ArrayComprehensionLoop;
import org.htmlunit.corejs.javascript.ast.ArrayLiteral;
import org.htmlunit.corejs.javascript.ast.Assignment;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.AstRoot;
import org.htmlunit.corejs.javascript.ast.BigIntLiteral;
import org.htmlunit.corejs.javascript.ast.Block;
import org.htmlunit.corejs.javascript.ast.BreakStatement;
import org.htmlunit.corejs.javascript.ast.CatchClause;
import org.htmlunit.corejs.javascript.ast.Comment;
import org.htmlunit.corejs.javascript.ast.ComputedPropertyKey;
import org.htmlunit.corejs.javascript.ast.ConditionalExpression;
import org.htmlunit.corejs.javascript.ast.ContinueStatement;
import org.htmlunit.corejs.javascript.ast.DestructuringForm;
import org.htmlunit.corejs.javascript.ast.DoLoop;
import org.htmlunit.corejs.javascript.ast.ElementGet;
import org.htmlunit.corejs.javascript.ast.EmptyExpression;
import org.htmlunit.corejs.javascript.ast.EmptyStatement;
import org.htmlunit.corejs.javascript.ast.ErrorNode;
import org.htmlunit.corejs.javascript.ast.ExpressionStatement;
import org.htmlunit.corejs.javascript.ast.ForInLoop;
import org.htmlunit.corejs.javascript.ast.ForLoop;
import org.htmlunit.corejs.javascript.ast.FunctionCall;
import org.htmlunit.corejs.javascript.ast.FunctionNode;
import org.htmlunit.corejs.javascript.ast.GeneratorExpression;
import org.htmlunit.corejs.javascript.ast.GeneratorExpressionLoop;
import org.htmlunit.corejs.javascript.ast.GeneratorMethodDefinition;
import org.htmlunit.corejs.javascript.ast.IdeErrorReporter;
import org.htmlunit.corejs.javascript.ast.IfStatement;
import org.htmlunit.corejs.javascript.ast.InfixExpression;
import org.htmlunit.corejs.javascript.ast.Jump;
import org.htmlunit.corejs.javascript.ast.KeywordLiteral;
import org.htmlunit.corejs.javascript.ast.Label;
import org.htmlunit.corejs.javascript.ast.LabeledStatement;
import org.htmlunit.corejs.javascript.ast.LetNode;
import org.htmlunit.corejs.javascript.ast.Loop;
import org.htmlunit.corejs.javascript.ast.Name;
import org.htmlunit.corejs.javascript.ast.NewExpression;
import org.htmlunit.corejs.javascript.ast.NumberLiteral;
import org.htmlunit.corejs.javascript.ast.ObjectLiteral;
import org.htmlunit.corejs.javascript.ast.ObjectProperty;
import org.htmlunit.corejs.javascript.ast.ParenthesizedExpression;
import org.htmlunit.corejs.javascript.ast.PropertyGet;
import org.htmlunit.corejs.javascript.ast.RegExpLiteral;
import org.htmlunit.corejs.javascript.ast.ReturnStatement;
import org.htmlunit.corejs.javascript.ast.Scope;
import org.htmlunit.corejs.javascript.ast.ScriptNode;
import org.htmlunit.corejs.javascript.ast.StringLiteral;
import org.htmlunit.corejs.javascript.ast.SwitchCase;
import org.htmlunit.corejs.javascript.ast.SwitchStatement;
import org.htmlunit.corejs.javascript.ast.Symbol;
import org.htmlunit.corejs.javascript.ast.TaggedTemplateLiteral;
import org.htmlunit.corejs.javascript.ast.TemplateCharacters;
import org.htmlunit.corejs.javascript.ast.TemplateLiteral;
import org.htmlunit.corejs.javascript.ast.ThrowStatement;
import org.htmlunit.corejs.javascript.ast.TryStatement;
import org.htmlunit.corejs.javascript.ast.UnaryExpression;
import org.htmlunit.corejs.javascript.ast.UpdateExpression;
import org.htmlunit.corejs.javascript.ast.VariableDeclaration;
import org.htmlunit.corejs.javascript.ast.VariableInitializer;
import org.htmlunit.corejs.javascript.ast.WhileLoop;
import org.htmlunit.corejs.javascript.ast.WithStatement;
import org.htmlunit.corejs.javascript.ast.XmlDotQuery;
import org.htmlunit.corejs.javascript.ast.XmlElemRef;
import org.htmlunit.corejs.javascript.ast.XmlExpression;
import org.htmlunit.corejs.javascript.ast.XmlLiteral;
import org.htmlunit.corejs.javascript.ast.XmlMemberGet;
import org.htmlunit.corejs.javascript.ast.XmlPropRef;
import org.htmlunit.corejs.javascript.ast.XmlRef;
import org.htmlunit.corejs.javascript.ast.XmlString;
import org.htmlunit.corejs.javascript.ast.Yield;

public class Parser {
    public static final int ARGC_LIMIT = 65536;
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private IdeErrorReporter errorCollector;
    private String sourceURI;
    private char[] sourceChars;
    boolean calledByCompileFunction;
    private boolean parseFinished;
    private TokenStream ts;
    CurrentPositionReporter currentPos;
    private int currentFlaggedToken = 0;
    private int currentToken;
    private int syntaxErrorCount;
    private List<Comment> scannedComments;
    private Comment currentJsDocComment;
    protected int nestingOfFunction;
    protected int nestingOfFunctionParams;
    private LabeledStatement currentLabel;
    private boolean inDestructuringAssignment;
    protected boolean inUseStrictDirective;
    ScriptNode currentScriptOrFn;
    private boolean insideMethod;
    Scope currentScope;
    private int endFlags;
    private boolean inForInit;
    private Map<String, LabeledStatement> labelSet;
    private List<Loop> loopSet;
    private List<Jump> loopAndSwitchSet;
    private int prevNameTokenStart;
    private String prevNameTokenString = "";
    private int prevNameTokenLineno;
    private int prevNameTokenColumn;
    private int lastTokenLineno = -1;
    private int lastTokenColumn = -1;
    private boolean defaultUseStrictDirective;
    private static final int PROP_ENTRY = 1;
    private static final int GET_ENTRY = 2;
    private static final int SET_ENTRY = 4;
    private static final int METHOD_ENTRY = 8;

    public Parser() {
        this(new CompilerEnvirons());
    }

    public Parser(CompilerEnvirons compilerEnv) {
        this(compilerEnv, compilerEnv.getErrorReporter());
    }

    public Parser(CompilerEnvirons compilerEnv, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnv;
        this.errorReporter = errorReporter;
        if (errorReporter instanceof IdeErrorReporter) {
            this.errorCollector = (IdeErrorReporter)errorReporter;
        }
    }

    void addStrictWarning(String messageId, String messageArg) {
        this.addStrictWarning(messageId, messageArg, this.currentPos.getPosition(), this.currentPos.getLength());
    }

    void addStrictWarning(String messageId, String messageArg, int position, int length) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg, position, length);
        }
    }

    void addWarning(String messageId, String messageArg) {
        this.addWarning(messageId, messageArg, this.currentPos.getPosition(), this.currentPos.getLength());
    }

    void addWarning(String messageId, int position, int length) {
        this.addWarning(messageId, null, position, length);
    }

    void addWarning(String messageId, String messageArg, int position, int length) {
        String message = this.lookupMessage(messageId, messageArg);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(messageId, messageArg, position, length);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.warning(message, this.sourceURI, this.currentPos.getLineno(), this.currentPos.getLine(), this.currentPos.getOffset());
        }
    }

    void addError(String messageId) {
        this.addError(messageId, this.currentPos.getPosition(), this.currentPos.getLength());
    }

    void addError(String messageId, int position, int length) {
        this.addError(messageId, null, position, length);
    }

    void addError(String messageId, String messageArg) {
        this.addError(messageId, messageArg, this.currentPos.getPosition(), this.currentPos.getLength());
    }

    void addError(String messageId, int c) {
        String messageArg = Character.toString((char)c);
        this.addError(messageId, messageArg);
    }

    void addError(String messageId, String messageArg, int position, int length) {
        ++this.syntaxErrorCount;
        String message = this.lookupMessage(messageId, messageArg);
        if (this.errorCollector != null) {
            this.errorCollector.error(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.error(message, this.sourceURI, this.currentPos.getLineno(), this.currentPos.getLine(), this.currentPos.getOffset());
        }
    }

    private void addStrictWarning(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg, position, length, line, lineSource, lineOffset);
        }
    }

    private void addWarning(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        String message = this.lookupMessage(messageId, messageArg);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(messageId, messageArg, position, length, line, lineSource, lineOffset);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.warning(message, this.sourceURI, line, lineSource, lineOffset);
        }
    }

    private void addError(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        ++this.syntaxErrorCount;
        String message = this.lookupMessage(messageId, messageArg);
        if (this.errorCollector != null) {
            this.errorCollector.error(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.error(message, this.sourceURI, line, lineSource, lineOffset);
        }
    }

    String lookupMessage(String messageId) {
        return this.lookupMessage(messageId, null);
    }

    String lookupMessage(String messageId, String messageArg) {
        return messageArg == null ? ScriptRuntime.getMessageById(messageId, new Object[0]) : ScriptRuntime.getMessageById(messageId, messageArg);
    }

    void reportError(String messageId) {
        this.reportError(messageId, null);
    }

    void reportError(String messageId, String messageArg) {
        this.reportError(messageId, messageArg, this.currentPos.getPosition(), this.currentPos.getLength());
    }

    void reportError(String messageId, int position, int length) {
        this.reportError(messageId, null, position, length);
    }

    void reportError(String messageId, String messageArg, int position, int length) {
        this.addError(messageId, messageArg, position, length);
        if (!this.compilerEnv.recoverFromErrors()) {
            throw new ParserException();
        }
    }

    private static int getNodeEnd(AstNode n) {
        return n.getPosition() + n.getLength();
    }

    private void recordComment(int lineno, int column, String comment) {
        if (this.scannedComments == null) {
            this.scannedComments = new ArrayList<Comment>();
        }
        Comment commentNode = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, comment);
        if (this.ts.commentType == Token.CommentType.JSDOC && this.compilerEnv.isRecordingLocalJsDocComments()) {
            this.currentJsDocComment = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, comment);
            this.currentJsDocComment.setLineColumnNumber(lineno, column);
        }
        commentNode.setLineColumnNumber(lineno, column);
        this.scannedComments.add(commentNode);
    }

    private Comment getAndResetJsDoc() {
        Comment saved = this.currentJsDocComment;
        this.currentJsDocComment = null;
        return saved;
    }

    private int peekToken() throws IOException {
        if (this.currentFlaggedToken != 0) {
            return this.currentToken;
        }
        int tt = this.ts.getToken();
        boolean sawEOL = false;
        while (tt == 1 || tt == 175) {
            if (tt == 1) {
                sawEOL = true;
                tt = this.ts.getToken();
                continue;
            }
            if (this.compilerEnv.isRecordingComments()) {
                String comment = this.ts.getAndResetCurrentComment();
                this.recordComment(this.ts.getTokenStartLineno(), this.ts.getTokenColumn(), comment);
                break;
            }
            tt = this.ts.getToken();
        }
        this.currentToken = tt;
        this.currentFlaggedToken = tt | (sawEOL ? 65536 : 0);
        return this.currentToken;
    }

    private int lineNumber() {
        return this.lastTokenLineno;
    }

    private int columnNumber() {
        return this.lastTokenColumn;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
        this.lastTokenLineno = this.ts.getTokenStartLineno();
        this.lastTokenColumn = this.ts.getTokenColumn();
    }

    private int nextToken() throws IOException {
        int tt = this.peekToken();
        this.consumeToken();
        return tt;
    }

    private boolean matchToken(int toMatch, boolean ignoreComment) throws IOException {
        int tt = this.peekToken();
        while (tt == 175 && ignoreComment) {
            this.consumeToken();
            tt = this.peekToken();
        }
        if (tt != toMatch) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int tt = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            tt = 1;
        }
        return tt;
    }

    private boolean mustMatchToken(int toMatch, String messageId, boolean ignoreComment) throws IOException {
        return this.mustMatchToken(toMatch, messageId, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, ignoreComment);
    }

    private boolean mustMatchToken(int toMatch, String msgId, int pos, int len, boolean ignoreComment) throws IOException {
        if (this.matchToken(toMatch, ignoreComment)) {
            return true;
        }
        this.reportError(msgId, pos, len);
        return false;
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunctionBody() {
        return this.nestingOfFunction != 0;
    }

    boolean insideFunctionParams() {
        return this.nestingOfFunctionParams != 0;
    }

    void pushScope(Scope scope) {
        Scope parent = scope.getParentScope();
        if (parent != null) {
            if (parent != this.currentScope) {
                this.codeBug();
            }
        } else {
            this.currentScope.addChildScope(scope);
        }
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    private void enterLoop(Loop loop) {
        if (this.loopSet == null) {
            this.loopSet = new ArrayList<Loop>();
        }
        this.loopSet.add(loop);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(loop);
        this.pushScope(loop);
        if (this.currentLabel != null) {
            this.currentLabel.setStatement(loop);
            this.currentLabel.getFirstLabel().setLoop(loop);
            loop.setRelative(-this.currentLabel.getPosition());
        }
    }

    private void exitLoop() {
        this.loopSet.remove(this.loopSet.size() - 1);
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
        this.popScope();
    }

    private void restoreRelativeLoopPosition(Loop loop) {
        if (loop.getParent() != null) {
            loop.setRelative(loop.getParent().getPosition());
        }
    }

    private void enterSwitch(SwitchStatement node) {
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(node);
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
    }

    public AstRoot parse(String sourceString, String sourceURI, int lineno) {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        this.sourceURI = sourceURI;
        if (this.compilerEnv.isIdeMode()) {
            this.sourceChars = sourceString.toCharArray();
        }
        this.ts = new TokenStream(this, null, sourceString, lineno);
        this.currentPos = this.ts;
        try {
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        catch (IOException iox) {
            throw new IllegalStateException();
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public AstRoot parse(Reader sourceReader, String sourceURI, int lineno) throws IOException {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        if (this.compilerEnv.isIdeMode()) {
            return this.parse(Kit.readReader(sourceReader), sourceURI, lineno);
        }
        try {
            this.sourceURI = sourceURI;
            this.ts = new TokenStream(this, sourceReader, null, lineno);
            this.currentPos = this.ts;
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstRoot parse() throws IOException {
        int pos = 0;
        AstRoot root = new AstRoot(pos);
        this.currentScriptOrFn = root;
        this.currentScope = this.currentScriptOrFn;
        int baseLineno = this.ts.lineno;
        this.prevNameTokenLineno = this.ts.getLineno();
        this.prevNameTokenColumn = this.ts.getTokenColumn();
        int end = pos;
        boolean inDirectivePrologue = true;
        boolean savedStrictMode = this.inUseStrictDirective;
        this.inUseStrictDirective = this.defaultUseStrictDirective;
        if (this.inUseStrictDirective) {
            root.setInStrictMode(true);
        }
        try {
            while (true) {
                AstNode n;
                block21: {
                    int tt;
                    if ((tt = this.peekToken()) <= 0) {
                        break;
                    }
                    if (tt == 122) {
                        this.consumeToken();
                        try {
                            n = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block21;
                        }
                        catch (ParserException e) {
                            break;
                        }
                    }
                    if (tt == 175) {
                        n = this.scannedComments.get(this.scannedComments.size() - 1);
                        this.consumeToken();
                    } else {
                        n = this.statement();
                        if (inDirectivePrologue) {
                            String directive = Parser.getDirective(n);
                            if (directive == null) {
                                inDirectivePrologue = false;
                            } else if (directive.equals("use strict")) {
                                this.inUseStrictDirective = true;
                                root.setInStrictMode(true);
                            }
                        }
                    }
                }
                end = Parser.getNodeEnd(n);
                root.addChildToBack(n);
                n.setParent(root);
            }
        }
        catch (StackOverflowError ex) {
            String msg = this.lookupMessage("msg.too.deep.parser.recursion");
            if (!this.compilerEnv.isIdeMode()) {
                throw Context.reportRuntimeError(msg, this.sourceURI, this.lineNumber(), null, 0);
            }
        }
        finally {
            this.inUseStrictDirective = savedStrictMode;
        }
        this.reportErrorsIfExists(baseLineno);
        if (this.scannedComments != null) {
            int last = this.scannedComments.size() - 1;
            end = Math.max(end, Parser.getNodeEnd(this.scannedComments.get(last)));
            for (Comment c : this.scannedComments) {
                root.addComment(c);
            }
        }
        root.setLength(end - pos);
        root.setSourceName(this.sourceURI);
        root.setBaseLineno(baseLineno);
        root.setEndLineno(this.ts.getLineno());
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parseFunctionBody(int type, FunctionNode fnNode) throws IOException {
        boolean isExpressionClosure = false;
        if (!this.matchToken(94, true)) {
            isExpressionClosure = true;
        }
        boolean isArrow = type == 4;
        ++this.nestingOfFunction;
        int pos = this.ts.tokenBeg;
        Block pn = new Block(pos);
        boolean inDirectivePrologue = true;
        boolean savedStrictMode = this.inUseStrictDirective;
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        try {
            if (isExpressionClosure) {
                AstNode returnValue = this.assignExpr();
                ReturnStatement n = new ReturnStatement(returnValue.getPosition(), returnValue.getLength(), returnValue);
                n.putProp(25, Boolean.TRUE);
                n.setLineColumnNumber(returnValue.getLineno(), returnValue.getColumn());
                pn.putProp(25, Boolean.TRUE);
                if (isArrow) {
                    n.putProp(26, Boolean.TRUE);
                }
                pn.addStatement(n);
                pn.setLength(n.getLength());
            } else {
                block10: while (true) {
                    AstNode n;
                    int tt = this.peekToken();
                    switch (tt) {
                        case -1: 
                        case 0: 
                        case 95: {
                            break block10;
                        }
                        case 175: {
                            this.consumeToken();
                            n = this.scannedComments.get(this.scannedComments.size() - 1);
                            break;
                        }
                        case 122: {
                            this.consumeToken();
                            n = this.function(1);
                            break;
                        }
                        default: {
                            n = this.statement();
                            if (!inDirectivePrologue) break;
                            String directive = Parser.getDirective(n);
                            if (directive == null) {
                                inDirectivePrologue = false;
                                break;
                            }
                            if (!directive.equals("use strict")) break;
                            if (fnNode.getDefaultParams() != null) {
                                this.reportError("msg.default.args.use.strict");
                            }
                            this.inUseStrictDirective = true;
                            fnNode.setInStrictMode(true);
                            if (savedStrictMode) break;
                            this.setRequiresActivation();
                        }
                    }
                    pn.addStatement(n);
                }
                int end = this.ts.tokenEnd;
                if (this.mustMatchToken(95, "msg.no.brace.after.body", true)) {
                    end = this.ts.tokenEnd;
                }
                pn.setLength(end - pos);
            }
        }
        catch (ParserException parserException) {
        }
        finally {
            --this.nestingOfFunction;
            this.inUseStrictDirective = savedStrictMode;
        }
        this.getAndResetJsDoc();
        return pn;
    }

    private static String getDirective(AstNode n) {
        AstNode e;
        if (n instanceof ExpressionStatement && (e = ((ExpressionStatement)n).getExpression()) instanceof StringLiteral) {
            return ((StringLiteral)e).getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFunctionParams(FunctionNode fnNode) throws IOException {
        ++this.nestingOfFunctionParams;
        try {
            if (this.matchToken(97, true)) {
                fnNode.setRp(this.ts.tokenBeg - fnNode.getPosition());
                return;
            }
            HashMap<String, AstNode> destructuring = null;
            HashMap<String, AstNode> destructuringDefault = null;
            HashSet<String> paramNames = new HashSet<String>();
            do {
                int tt;
                if ((tt = this.peekToken()) == 97) {
                    if (fnNode.hasRestParameter()) {
                        this.reportError("msg.parm.after.rest", this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
                    }
                    fnNode.putIntProp(28, 1);
                    break;
                }
                if (tt == 92 || tt == 94) {
                    if (fnNode.hasRestParameter()) {
                        this.reportError("msg.parm.after.rest", this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
                    }
                    AstNode expr = this.destructuringAssignExpr();
                    if (destructuring == null) {
                        destructuring = new HashMap<String, AstNode>();
                    }
                    if (expr instanceof Assignment) {
                        AstNode lhs = ((Assignment)expr).getLeft();
                        AstNode rhs = ((Assignment)expr).getRight();
                        this.markDestructuring(lhs);
                        fnNode.addParam(lhs);
                        String pname = this.currentScriptOrFn.getNextTempName();
                        this.defineSymbol(96, pname, false);
                        if (destructuringDefault == null) {
                            destructuringDefault = new HashMap<String, AstNode>();
                        }
                        destructuring.put(pname, lhs);
                        destructuringDefault.put(pname, rhs);
                        continue;
                    }
                    this.markDestructuring(expr);
                    fnNode.addParam(expr);
                    String pname = this.currentScriptOrFn.getNextTempName();
                    this.defineSymbol(96, pname, false);
                    destructuring.put(pname, expr);
                    continue;
                }
                boolean wasRest = false;
                int restStartLineno = -1;
                int restStartColumn = -1;
                if (tt == 184) {
                    if (fnNode.hasRestParameter()) {
                        this.reportError("msg.parm.after.rest", this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
                    }
                    fnNode.setHasRestParameter(true);
                    wasRest = true;
                    this.consumeToken();
                    restStartLineno = this.lineNumber();
                    restStartColumn = this.columnNumber();
                }
                if (this.mustMatchToken(44, "msg.no.parm", true)) {
                    Comment jsdocNodeForName;
                    if (!wasRest && fnNode.hasRestParameter()) {
                        this.reportError("msg.parm.after.rest", this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
                    }
                    Name paramNameNode = this.createNameNode();
                    if (wasRest) {
                        paramNameNode.setLineColumnNumber(restStartLineno, restStartColumn);
                    }
                    if ((jsdocNodeForName = this.getAndResetJsDoc()) != null) {
                        paramNameNode.setJsDocNode(jsdocNodeForName);
                    }
                    fnNode.addParam(paramNameNode);
                    String paramName = this.ts.getString();
                    this.defineSymbol(96, paramName);
                    if (this.inUseStrictDirective) {
                        if ("eval".equals(paramName) || "arguments".equals(paramName)) {
                            this.reportError("msg.bad.id.strict", paramName);
                        }
                        if (paramNames.contains(paramName)) {
                            this.addError("msg.dup.param.strict", paramName);
                        }
                        paramNames.add(paramName);
                    }
                    if (!this.matchToken(99, true)) continue;
                    fnNode.putDefaultParams(paramName, this.assignExpr());
                    continue;
                }
                fnNode.addParam(this.makeErrorNode());
            } while (this.matchToken(98, true));
            if (destructuring != null) {
                Node destructuringNode = new Node(98);
                for (Map.Entry param : destructuring.entrySet()) {
                    AstNode defaultValue = null;
                    if (destructuringDefault != null) {
                        defaultValue = (AstNode)destructuringDefault.get(param.getKey());
                    }
                    Node assign = this.createDestructuringAssignment(135, (Node)param.getValue(), this.createName((String)param.getKey()), defaultValue);
                    destructuringNode.addChildToBack(assign);
                }
                fnNode.putProp(23, destructuringNode);
            }
            if (this.mustMatchToken(97, "msg.no.paren.after.parms", true)) {
                fnNode.setRp(this.ts.tokenBeg - fnNode.getPosition());
            }
        }
        finally {
            --this.nestingOfFunctionParams;
        }
    }

    private FunctionNode function(int type) throws IOException {
        return this.function(type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode function(int type, boolean isMethodDefiniton) throws IOException {
        int lpPos;
        boolean isGenerator = false;
        int syntheticType = type;
        int baseLineno = this.lineNumber();
        int functionSourceStart = this.ts.tokenBeg;
        int functionStartColumn = this.columnNumber();
        Name name = null;
        AstNode memberExprNode = null;
        do {
            if (this.matchToken(44, true)) {
                String id;
                name = this.createNameNode(true, 44);
                if (this.inUseStrictDirective && ("eval".equals(id = name.getIdentifier()) || "arguments".equals(id))) {
                    this.reportError("msg.bad.id.strict", id);
                }
                if (this.matchToken(96, true)) break;
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Name memberExprHead = name;
                    name = null;
                    memberExprNode = this.memberExprTail(false, memberExprHead);
                }
                this.mustMatchToken(96, "msg.no.paren.parms", true);
                break;
            }
            if (this.matchToken(96, true)) break;
            if (!this.matchToken(23, true)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    memberExprNode = this.memberExpr(false);
                }
                this.mustMatchToken(96, "msg.no.paren.parms", true);
                break;
            }
            isGenerator = true;
        } while (isGenerator);
        int n = lpPos = this.currentToken == 96 ? this.ts.tokenBeg : -1;
        if (memberExprNode != null) {
            syntheticType = 2;
        }
        if (syntheticType != 2 && name != null && name.length() > 0) {
            this.defineSymbol(122, name.getIdentifier());
        }
        FunctionNode fnNode = new FunctionNode(functionSourceStart, name);
        fnNode.setMethodDefinition(isMethodDefiniton);
        fnNode.setFunctionType(type);
        if (isGenerator) {
            fnNode.setIsES6Generator();
        }
        if (lpPos != -1) {
            fnNode.setLp(lpPos - functionSourceStart);
        }
        fnNode.setJsDocNode(this.getAndResetJsDoc());
        PerFunctionVariables savedVars = new PerFunctionVariables(fnNode);
        boolean wasInsideMethod = this.insideMethod;
        this.insideMethod = isMethodDefiniton;
        try {
            this.parseFunctionParams(fnNode);
            AstNode body = this.parseFunctionBody(type, fnNode);
            fnNode.setBody(body);
            int end = functionSourceStart + body.getPosition() + body.getLength();
            fnNode.setRawSourceBounds(functionSourceStart, end);
            fnNode.setLength(end - functionSourceStart);
            if (this.compilerEnv.isStrictMode() && !fnNode.getBody().hasConsistentReturnUsage()) {
                String msg = name != null && name.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(msg, name == null ? "" : name.getIdentifier());
            }
        }
        finally {
            savedVars.restore();
            this.insideMethod = wasInsideMethod;
        }
        if (memberExprNode != null) {
            Kit.codeBug();
            fnNode.setMemberExprNode(memberExprNode);
        }
        fnNode.setSourceName(this.sourceURI);
        fnNode.setLineColumnNumber(baseLineno, functionStartColumn);
        fnNode.setEndLineno(this.lineNumber());
        if (this.compilerEnv.isIdeMode()) {
            fnNode.setParentScope(this.currentScope);
        }
        return fnNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode arrowFunction(AstNode params, int startLine, int startColumn) throws IOException {
        int baseLineno = this.lineNumber();
        int functionSourceStart = params != null ? params.getPosition() : -1;
        FunctionNode fnNode = new FunctionNode(functionSourceStart);
        fnNode.setFunctionType(4);
        fnNode.setJsDocNode(this.getAndResetJsDoc());
        HashMap<String, Node> destructuring = new HashMap<String, Node>();
        HashMap<String, AstNode> destructuringDefault = new HashMap<String, AstNode>();
        HashSet<String> paramNames = new HashSet<String>();
        PerFunctionVariables savedVars = new PerFunctionVariables(fnNode);
        try {
            if (params instanceof ParenthesizedExpression) {
                AstNode p;
                fnNode.setParens(0, params.getLength());
                if (params.getIntProp(28, 0) == 1) {
                    fnNode.putIntProp(28, 1);
                }
                if (!((p = ((ParenthesizedExpression)params).getExpression()) instanceof EmptyExpression)) {
                    this.arrowFunctionParams(fnNode, p, destructuring, destructuringDefault, paramNames);
                }
            } else {
                this.arrowFunctionParams(fnNode, params, destructuring, destructuringDefault, paramNames);
            }
            if (!destructuring.isEmpty()) {
                Node destructuringNode = new Node(98);
                for (Map.Entry param : destructuring.entrySet()) {
                    AstNode defaultValue = null;
                    if (destructuringDefault != null) {
                        defaultValue = (AstNode)destructuringDefault.get(param.getKey());
                    }
                    Node assign = this.createDestructuringAssignment(135, (Node)param.getValue(), this.createName((String)param.getKey()), defaultValue);
                    destructuringNode.addChildToBack(assign);
                }
                fnNode.putProp(23, destructuringNode);
            }
            AstNode body = this.parseFunctionBody(4, fnNode);
            fnNode.setBody(body);
            int end = functionSourceStart + body.getPosition() + body.getLength();
            fnNode.setRawSourceBounds(functionSourceStart, end);
            fnNode.setLength(end - functionSourceStart);
        }
        finally {
            savedVars.restore();
        }
        if (fnNode.isGenerator()) {
            this.reportError("msg.arrowfunction.generator");
            return this.makeErrorNode();
        }
        fnNode.setSourceName(this.sourceURI);
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.lineNumber());
        fnNode.setLineColumnNumber(startLine, startColumn);
        return fnNode;
    }

    private void arrowFunctionParams(FunctionNode fnNode, AstNode params, Map<String, Node> destructuring, Map<String, AstNode> destructuringDefault, Set<String> paramNames) throws IOException {
        if (params instanceof ArrayLiteral || params instanceof ObjectLiteral) {
            this.markDestructuring(params);
            fnNode.addParam(params);
            String pname = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(96, pname, false);
            destructuring.put(pname, params);
        } else if (params instanceof InfixExpression && params.getType() == 98) {
            this.arrowFunctionParams(fnNode, ((InfixExpression)params).getLeft(), destructuring, destructuringDefault, paramNames);
            this.arrowFunctionParams(fnNode, ((InfixExpression)params).getRight(), destructuring, destructuringDefault, paramNames);
        } else if (params instanceof Name) {
            fnNode.addParam(params);
            String paramName = ((Name)params).getIdentifier();
            this.defineSymbol(96, paramName);
            if (this.inUseStrictDirective) {
                if ("eval".equals(paramName) || "arguments".equals(paramName)) {
                    this.reportError("msg.bad.id.strict", paramName);
                }
                if (paramNames.contains(paramName)) {
                    this.addError("msg.dup.param.strict", paramName);
                }
                paramNames.add(paramName);
            }
        } else if (params instanceof Assignment) {
            AstNode rhs = ((Assignment)params).getRight();
            AstNode lhs = ((Assignment)params).getLeft();
            if (lhs instanceof Name) {
                String paramName = ((Name)lhs).getIdentifier();
                fnNode.putDefaultParams(paramName, rhs);
                this.arrowFunctionParams(fnNode, lhs, destructuring, destructuringDefault, paramNames);
            } else if (lhs instanceof ArrayLiteral || lhs instanceof ObjectLiteral) {
                this.markDestructuring(lhs);
                fnNode.addParam(lhs);
                String pname = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(96, pname, false);
                destructuring.put(pname, lhs);
                destructuringDefault.put(pname, rhs);
            } else {
                this.reportError("msg.no.parm", params.getPosition(), params.getLength());
                fnNode.addParam(this.makeErrorNode());
            }
        } else {
            this.reportError("msg.no.parm", params.getPosition(), params.getLength());
            fnNode.addParam(this.makeErrorNode());
        }
    }

    private AstNode statements(AstNode parent) throws IOException {
        int tt;
        if (this.currentToken != 94 && !this.compilerEnv.isIdeMode()) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        AstNode block = parent != null ? parent : new Block(pos);
        block.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        while ((tt = this.peekToken()) > 0 && tt != 95) {
            block.addChild(this.statement());
        }
        block.setLength(this.ts.tokenBeg - pos);
        return block;
    }

    private AstNode statements() throws IOException {
        return this.statements(null);
    }

    private ConditionData condition() throws IOException {
        ConditionData data = new ConditionData();
        if (this.mustMatchToken(96, "msg.no.paren.cond", true)) {
            data.lp = this.ts.tokenBeg;
        }
        data.condition = this.expr(false);
        if (this.mustMatchToken(97, "msg.no.paren.after.cond", true)) {
            data.rp = this.ts.tokenBeg;
        }
        if (data.condition instanceof Assignment) {
            this.addStrictWarning("msg.equal.as.assign", "", data.condition.getPosition(), data.condition.getLength());
        }
        return data;
    }

    private AstNode statement() throws IOException {
        int pos = this.ts.tokenBeg;
        try {
            AstNode pn = this.statementHelper();
            if (pn != null) {
                int ntt;
                if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                    int beg = pn.getPosition();
                    beg = Math.max(beg, this.lineBeginningFor(beg));
                    this.addStrictWarning(pn instanceof EmptyStatement ? "msg.extra.trailing.semi" : "msg.no.side.effects", "", beg, Parser.nodeEnd(pn) - beg);
                }
                if ((ntt = this.peekToken()) == 175 && pn.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    pn.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
                return pn;
            }
        }
        catch (ParserException pn) {
            // empty catch block
        }
        block5: while (true) {
            int tt = this.peekTokenOrEOL();
            this.consumeToken();
            switch (tt) {
                case -1: 
                case 0: 
                case 1: 
                case 91: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return new EmptyStatement(pos, this.ts.tokenBeg - pos);
    }

    private AstNode statementHelper() throws IOException {
        if (this.currentLabel != null && this.currentLabel.getStatement() != null) {
            this.currentLabel = null;
        }
        AstNode pn = null;
        int tt = this.peekToken();
        int pos = this.ts.tokenBeg;
        switch (tt) {
            case 125: {
                return this.ifStatement();
            }
            case 127: {
                return this.switchStatement();
            }
            case 130: {
                return this.whileLoop();
            }
            case 131: {
                return this.doLoop();
            }
            case 132: {
                return this.forLoop();
            }
            case 90: {
                return this.tryStatement();
            }
            case 55: {
                pn = this.throwStatement();
                break;
            }
            case 133: {
                pn = this.breakStatement();
                break;
            }
            case 134: {
                pn = this.continueStatement();
                break;
            }
            case 136: {
                if (this.inUseStrictDirective) {
                    this.reportError("msg.no.with.strict");
                }
                return this.withStatement();
            }
            case 168: {
                this.currentToken = 167;
                pn = this.letStatement();
                if (pn instanceof VariableDeclaration && this.peekToken() == 91) break;
                return pn;
            }
            case 135: {
                this.consumeToken();
                int lineno = this.lineNumber();
                int column = this.columnNumber();
                pn = this.variables(this.currentToken, this.ts.tokenBeg, true);
                pn.setLineColumnNumber(lineno, column);
                break;
            }
            case 167: {
                pn = this.letStatement();
                if (pn instanceof VariableDeclaration && this.peekToken() == 91) break;
                return pn;
            }
            case 4: 
            case 78: {
                pn = this.returnOrYield(tt, false);
                break;
            }
            case 174: {
                this.consumeToken();
                pn = new KeywordLiteral(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, tt);
                pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                break;
            }
            case 94: {
                return this.block();
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 91: {
                this.consumeToken();
                pos = this.ts.tokenBeg;
                pn = new EmptyStatement(pos, this.ts.tokenEnd - pos);
                pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                return pn;
            }
            case 122: {
                this.consumeToken();
                return this.function(3);
            }
            case 129: {
                pn = this.defaultXmlNamespace();
                break;
            }
            case 44: {
                pn = this.nameOrLabel();
                if (pn instanceof ExpressionStatement) break;
                return pn;
            }
            case 175: {
                pn = this.scannedComments.get(this.scannedComments.size() - 1);
                return pn;
            }
            default: {
                int lineno = this.ts.getLineno();
                int column = this.ts.getTokenColumn();
                pn = new ExpressionStatement(this.expr(false), !this.insideFunctionBody());
                pn.setLineColumnNumber(lineno, column);
            }
        }
        this.autoInsertSemicolon(pn);
        return pn;
    }

    private void autoInsertSemicolon(AstNode pn) throws IOException {
        int ttFlagged = this.peekFlaggedToken();
        int pos = pn.getPosition();
        switch (ttFlagged & 0xFFFF) {
            case 91: {
                this.consumeToken();
                pn.setLength(this.ts.tokenEnd - pos);
                break;
            }
            case -1: 
            case 0: 
            case 95: {
                this.warnMissingSemi(pos, Math.max(pos + 1, Parser.nodeEnd(pn)));
                break;
            }
            default: {
                if ((ttFlagged & 0x10000) == 0) {
                    this.reportError("msg.no.semi.stmt");
                    break;
                }
                this.warnMissingSemi(pos, Parser.nodeEnd(pn));
            }
        }
    }

    private IfStatement ifStatement() throws IOException {
        if (this.currentToken != 125) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int elsePos = -1;
        int column = this.columnNumber();
        IfStatement pn = new IfStatement(pos);
        ConditionData data = this.condition();
        AstNode ifTrue = this.getNextStatementAfterInlineComments(pn);
        AstNode ifFalse = null;
        if (this.matchToken(126, true)) {
            int tt = this.peekToken();
            if (tt == 175) {
                pn.setElseKeyWordInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                this.consumeToken();
            }
            elsePos = this.ts.tokenBeg - pos;
            ifFalse = this.statement();
        }
        int end = Parser.getNodeEnd(ifFalse != null ? ifFalse : ifTrue);
        pn.setLength(end - pos);
        pn.setCondition(data.condition);
        pn.setParens(data.lp - pos, data.rp - pos);
        pn.setThenPart(ifTrue);
        pn.setElsePart(ifFalse);
        pn.setElsePosition(elsePos);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchStatement switchStatement() throws IOException {
        SwitchStatement pn;
        block18: {
            if (this.currentToken != 127) {
                this.codeBug();
            }
            this.consumeToken();
            int pos = this.ts.tokenBeg;
            pn = new SwitchStatement(pos);
            pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
            if (this.mustMatchToken(96, "msg.no.paren.switch", true)) {
                pn.setLp(this.ts.tokenBeg - pos);
            }
            AstNode discriminant = this.expr(false);
            pn.setExpression(discriminant);
            this.enterSwitch(pn);
            try {
                if (this.mustMatchToken(97, "msg.no.paren.after.switch", true)) {
                    pn.setRp(this.ts.tokenBeg - pos);
                }
                this.mustMatchToken(94, "msg.no.brace.switch", true);
                boolean hasDefault = false;
                block9: while (true) {
                    int tt = this.nextToken();
                    int casePos = this.ts.tokenBeg;
                    int caseLineno = this.lineNumber();
                    int caseColumn = this.columnNumber();
                    AstNode caseExpression = null;
                    switch (tt) {
                        case 95: {
                            pn.setLength(this.ts.tokenEnd - pos);
                            break block18;
                        }
                        case 128: {
                            caseExpression = this.expr(false);
                            this.mustMatchToken(116, "msg.no.colon.case", true);
                            break;
                        }
                        case 129: {
                            if (hasDefault) {
                                this.reportError("msg.double.switch.default");
                            }
                            hasDefault = true;
                            this.mustMatchToken(116, "msg.no.colon.case", true);
                            break;
                        }
                        case 175: {
                            AstNode n = this.scannedComments.get(this.scannedComments.size() - 1);
                            pn.addChild(n);
                            continue block9;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                            break block18;
                        }
                    }
                    SwitchCase caseNode = new SwitchCase(casePos);
                    caseNode.setExpression(caseExpression);
                    caseNode.setLength(this.ts.tokenEnd - pos);
                    caseNode.setLineColumnNumber(caseLineno, caseColumn);
                    while ((tt = this.peekToken()) != 95 && tt != 128 && tt != 129 && tt != 0) {
                        if (tt == 175) {
                            Comment inlineComment = this.scannedComments.get(this.scannedComments.size() - 1);
                            if (caseNode.getInlineComment() == null && inlineComment.getLineno() == caseNode.getLineno()) {
                                caseNode.setInlineComment(inlineComment);
                            } else {
                                caseNode.addStatement(inlineComment);
                            }
                            this.consumeToken();
                            continue;
                        }
                        AstNode nextStmt = this.statement();
                        caseNode.addStatement(nextStmt);
                    }
                    pn.addCase(caseNode);
                }
            }
            finally {
                this.exitSwitch();
            }
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhileLoop whileLoop() throws IOException {
        if (this.currentToken != 130) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        WhileLoop pn = new WhileLoop(pos);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        this.enterLoop(pn);
        try {
            ConditionData data = this.condition();
            pn.setCondition(data.condition);
            pn.setParens(data.lp - pos, data.rp - pos);
            AstNode body = this.getNextStatementAfterInlineComments(pn);
            pn.setLength(Parser.getNodeEnd(body) - pos);
            this.restoreRelativeLoopPosition(pn);
            pn.setBody(body);
        }
        finally {
            this.exitLoop();
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoLoop doLoop() throws IOException {
        int end;
        if (this.currentToken != 131) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        DoLoop pn = new DoLoop(pos);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        this.enterLoop(pn);
        try {
            AstNode body = this.getNextStatementAfterInlineComments(pn);
            this.mustMatchToken(130, "msg.no.while.do", true);
            pn.setWhilePosition(this.ts.tokenBeg - pos);
            ConditionData data = this.condition();
            pn.setCondition(data.condition);
            pn.setParens(data.lp - pos, data.rp - pos);
            end = Parser.getNodeEnd(body);
            this.restoreRelativeLoopPosition(pn);
            pn.setBody(body);
        }
        finally {
            this.exitLoop();
        }
        if (this.matchToken(91, true)) {
            end = this.ts.tokenEnd;
        }
        pn.setLength(end - pos);
        return pn;
    }

    private int peekUntilNonComment(int tt) throws IOException {
        while (tt == 175) {
            this.consumeToken();
            tt = this.peekToken();
        }
        return tt;
    }

    private AstNode getNextStatementAfterInlineComments(AstNode pn) throws IOException {
        AstNode body = this.statement();
        if (175 == body.getType()) {
            AstNode commentNode = body;
            body = this.statement();
            if (pn != null) {
                pn.setInlineComment(commentNode);
            } else {
                body.setInlineComment(commentNode);
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loop forLoop() throws IOException {
        if (this.currentToken != 132) {
            this.codeBug();
        }
        this.consumeToken();
        int forPos = this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        boolean isForEach = false;
        boolean isForIn = false;
        boolean isForOf = false;
        int eachPos = -1;
        int inPos = -1;
        int lp = -1;
        int rp = -1;
        AstNode init = null;
        AstNode cond = null;
        AstNode incr = null;
        Loop pn = null;
        Scope tempScope = new Scope();
        this.pushScope(tempScope);
        try {
            if (this.matchToken(44, true)) {
                if ("each".equals(this.ts.getString())) {
                    isForEach = true;
                    eachPos = this.ts.tokenBeg - forPos;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(96, "msg.no.paren.for", true)) {
                lp = this.ts.tokenBeg - forPos;
            }
            int tt = this.peekToken();
            init = this.forLoopInit(tt);
            if (this.matchToken(57, true)) {
                isForIn = true;
                inPos = this.ts.tokenBeg - forPos;
                this.markDestructuring(init);
                cond = this.expr(false);
            } else if (this.matchToken(44, true) && "of".equals(this.ts.getString())) {
                isForOf = true;
                inPos = this.ts.tokenBeg - forPos;
                this.markDestructuring(init);
                cond = this.expr(false);
            } else {
                this.mustMatchToken(91, "msg.no.semi.for", true);
                if (this.peekToken() == 91) {
                    cond = new EmptyExpression(this.ts.tokenBeg, 1);
                    cond.setLineColumnNumber(this.ts.getLineno(), this.ts.getTokenColumn());
                } else {
                    cond = this.expr(false);
                }
                this.mustMatchToken(91, "msg.no.semi.for.cond", true);
                int tmpPos = this.ts.tokenEnd;
                if (this.peekToken() == 97) {
                    incr = new EmptyExpression(tmpPos, 1);
                    incr.setLineColumnNumber(this.ts.getLineno(), this.ts.getTokenColumn());
                } else {
                    incr = this.expr(false);
                }
            }
            if (this.mustMatchToken(97, "msg.no.paren.for.ctrl", true)) {
                rp = this.ts.tokenBeg - forPos;
            }
            if (isForIn || isForOf) {
                ForInLoop fis = new ForInLoop(forPos);
                if (init instanceof VariableDeclaration && ((VariableDeclaration)init).getVariables().size() > 1) {
                    this.reportError("msg.mult.index");
                }
                if (isForOf && isForEach) {
                    this.reportError("msg.invalid.for.each");
                }
                fis.setIterator(init);
                fis.setIteratedObject(cond);
                fis.setInPosition(inPos);
                fis.setIsForEach(isForEach);
                fis.setEachPosition(eachPos);
                fis.setIsForOf(isForOf);
                pn = fis;
            } else {
                ForLoop fl = new ForLoop(forPos);
                fl.setInitializer(init);
                fl.setCondition(cond);
                fl.setIncrement(incr);
                pn = fl;
            }
            this.currentScope.replaceWith(pn);
            this.popScope();
            this.enterLoop(pn);
            try {
                AstNode body = this.getNextStatementAfterInlineComments(pn);
                pn.setLength(Parser.getNodeEnd(body) - forPos);
                this.restoreRelativeLoopPosition(pn);
                pn.setBody(body);
            }
            finally {
                this.exitLoop();
            }
        }
        finally {
            if (this.currentScope == tempScope) {
                this.popScope();
            }
        }
        pn.setParens(lp, rp);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode forLoopInit(int tt) throws IOException {
        try {
            this.inForInit = true;
            AstNode init = null;
            if (tt == 91) {
                init = new EmptyExpression(this.ts.tokenBeg, 1);
                init.setLineColumnNumber(this.ts.getLineno(), this.ts.getTokenColumn());
            } else if (tt == 135 || tt == 167) {
                this.consumeToken();
                init = this.variables(tt, this.ts.tokenBeg, false);
            } else if (tt == 168) {
                this.consumeToken();
                init = this.variables(167, this.ts.tokenBeg, false);
            } else {
                init = this.expr(false);
            }
            AstNode astNode = init;
            return astNode;
        }
        finally {
            this.inForInit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TryStatement tryStatement() throws IOException {
        if (this.currentToken != 90) {
            this.codeBug();
        }
        this.consumeToken();
        Comment jsdocNode = this.getAndResetJsDoc();
        int tryPos = this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int finallyPos = -1;
        TryStatement pn = new TryStatement(tryPos);
        int lctt = this.peekToken();
        while (lctt == 175) {
            Comment commentNode = this.scannedComments.get(this.scannedComments.size() - 1);
            pn.setInlineComment(commentNode);
            this.consumeToken();
            lctt = this.peekToken();
        }
        if (lctt != 94) {
            this.reportError("msg.no.brace.try");
        }
        AstNode tryBlock = this.getNextStatementAfterInlineComments(pn);
        int tryEnd = Parser.getNodeEnd(tryBlock);
        ArrayList<CatchClause> clauses = null;
        boolean sawDefaultCatch = false;
        int peek = this.peekToken();
        while (peek == 175) {
            Comment commentNode = this.scannedComments.get(this.scannedComments.size() - 1);
            pn.setInlineComment(commentNode);
            this.consumeToken();
            peek = this.peekToken();
        }
        if (peek == 137) {
            while (this.matchToken(137, true)) {
                int catchLineNum = this.lineNumber();
                if (sawDefaultCatch) {
                    this.reportError("msg.catch.unreachable");
                }
                int catchPos = this.ts.tokenBeg;
                int lp = -1;
                int rp = -1;
                int guardPos = -1;
                int catchLine = this.lineNumber();
                int catchColumn = this.columnNumber();
                Name varName = null;
                AstNode catchCond = null;
                switch (this.peekToken()) {
                    case 96: {
                        this.matchToken(96, true);
                        lp = this.ts.tokenBeg;
                        this.mustMatchToken(44, "msg.bad.catchcond", true);
                        varName = this.createNameNode();
                        Comment jsdocNodeForName = this.getAndResetJsDoc();
                        if (jsdocNodeForName != null) {
                            varName.setJsDocNode(jsdocNodeForName);
                        }
                        String varNameString = varName.getIdentifier();
                        if (this.inUseStrictDirective && ("eval".equals(varNameString) || "arguments".equals(varNameString))) {
                            this.reportError("msg.bad.id.strict", varNameString);
                        }
                        if (this.matchToken(125, true)) {
                            guardPos = this.ts.tokenBeg;
                            catchCond = this.expr(false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        if (this.mustMatchToken(97, "msg.bad.catchcond", true)) {
                            rp = this.ts.tokenBeg;
                        }
                        this.mustMatchToken(94, "msg.no.brace.catchblock", true);
                        break;
                    }
                    case 94: {
                        this.matchToken(94, true);
                        break;
                    }
                    default: {
                        this.reportError("msg.no.paren.catch");
                    }
                }
                Scope catchScope = new Scope(catchPos);
                CatchClause catchNode = new CatchClause(catchPos);
                catchNode.setLineColumnNumber(catchLine, catchColumn);
                this.pushScope(catchScope);
                try {
                    this.statements(catchScope);
                }
                finally {
                    this.popScope();
                }
                tryEnd = Parser.getNodeEnd(catchScope);
                catchNode.setVarName(varName);
                catchNode.setCatchCondition(catchCond);
                catchNode.setBody(catchScope);
                if (guardPos != -1) {
                    catchNode.setIfPosition(guardPos - catchPos);
                }
                catchNode.setParens(lp, rp);
                if (this.mustMatchToken(95, "msg.no.brace.after.body", true)) {
                    tryEnd = this.ts.tokenEnd;
                }
                catchNode.setLength(tryEnd - catchPos);
                if (clauses == null) {
                    clauses = new ArrayList<CatchClause>();
                }
                clauses.add(catchNode);
            }
        } else if (peek != 138) {
            this.mustMatchToken(138, "msg.try.no.catchfinally", true);
        }
        AstNode finallyBlock = null;
        if (this.matchToken(138, true)) {
            finallyPos = this.ts.tokenBeg;
            finallyBlock = this.statement();
            tryEnd = Parser.getNodeEnd(finallyBlock);
        }
        pn.setLength(tryEnd - tryPos);
        pn.setTryBlock(tryBlock);
        pn.setCatchClauses(clauses);
        pn.setFinallyBlock(finallyBlock);
        if (finallyPos != -1) {
            pn.setFinallyPosition(finallyPos - tryPos);
        }
        pn.setLineColumnNumber(lineno, column);
        if (jsdocNode != null) {
            pn.setJsDocNode(jsdocNode);
        }
        return pn;
    }

    private ThrowStatement throwStatement() throws IOException {
        if (this.currentToken != 55) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        if (this.peekTokenOrEOL() == 1) {
            this.reportError("msg.bad.throw.eol");
        }
        AstNode expr = this.expr(false);
        ThrowStatement pn = new ThrowStatement(pos, expr);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private LabeledStatement matchJumpLabelName() throws IOException {
        LabeledStatement label = null;
        if (this.peekTokenOrEOL() == 44) {
            this.consumeToken();
            if (this.labelSet != null) {
                label = this.labelSet.get(this.ts.getString());
            }
            if (label == null) {
                this.reportError("msg.undef.label");
            }
        }
        return label;
    }

    private BreakStatement breakStatement() throws IOException {
        LabeledStatement labels;
        Jump breakTarget;
        if (this.currentToken != 133) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.lineNumber();
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        int column = this.columnNumber();
        Name breakLabel = null;
        if (this.peekTokenOrEOL() == 44) {
            breakLabel = this.createNameNode();
            end = Parser.getNodeEnd(breakLabel);
        }
        Label label = breakTarget = (labels = this.matchJumpLabelName()) == null ? null : labels.getFirstLabel();
        if (breakTarget == null && breakLabel == null) {
            if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                this.reportError("msg.bad.break", pos, end - pos);
            } else {
                breakTarget = this.loopAndSwitchSet.get(this.loopAndSwitchSet.size() - 1);
            }
        }
        if (breakLabel != null) {
            breakLabel.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        }
        BreakStatement pn = new BreakStatement(pos, end - pos);
        pn.setBreakLabel(breakLabel);
        if (breakTarget != null) {
            pn.setBreakTarget(breakTarget);
        }
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private ContinueStatement continueStatement() throws IOException {
        if (this.currentToken != 134) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.lineNumber();
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        int column = this.columnNumber();
        Name label = null;
        if (this.peekTokenOrEOL() == 44) {
            label = this.createNameNode();
            end = Parser.getNodeEnd(label);
        }
        LabeledStatement labels = this.matchJumpLabelName();
        Loop target = null;
        if (labels == null && label == null) {
            if (this.loopSet == null || this.loopSet.size() == 0) {
                this.reportError("msg.continue.outside");
            } else {
                target = this.loopSet.get(this.loopSet.size() - 1);
            }
        } else {
            if (labels == null || !(labels.getStatement() instanceof Loop)) {
                this.reportError("msg.continue.nonloop", pos, end - pos);
            }
            Loop loop = target = labels == null ? null : (Loop)labels.getStatement();
        }
        if (label != null) {
            label.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        }
        ContinueStatement pn = new ContinueStatement(pos, end - pos);
        if (target != null) {
            pn.setTarget(target);
        }
        pn.setLabel(label);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private WithStatement withStatement() throws IOException {
        if (this.currentToken != 136) {
            this.codeBug();
        }
        this.consumeToken();
        Comment withComment = this.getAndResetJsDoc();
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int pos = this.ts.tokenBeg;
        int lp = -1;
        int rp = -1;
        if (this.mustMatchToken(96, "msg.no.paren.with", true)) {
            lp = this.ts.tokenBeg;
        }
        AstNode obj = this.expr(false);
        if (this.mustMatchToken(97, "msg.no.paren.after.with", true)) {
            rp = this.ts.tokenBeg;
        }
        WithStatement pn = new WithStatement(pos);
        AstNode body = this.getNextStatementAfterInlineComments(pn);
        pn.setLength(Parser.getNodeEnd(body) - pos);
        pn.setJsDocNode(withComment);
        pn.setExpression(obj);
        pn.setStatement(body);
        pn.setParens(lp, rp);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private AstNode letStatement() throws IOException {
        if (this.currentToken != 167) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.lineNumber();
        int pos = this.ts.tokenBeg;
        int column = this.columnNumber();
        AstNode pn = this.peekToken() == 96 ? this.let(true, pos) : this.variables(167, pos, true);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private static final boolean nowAllSet(int before, int after, int mask) {
        return (before & mask) != mask && (after & mask) == mask;
    }

    private AstNode returnOrYield(int tt, boolean exprContext) throws IOException {
        FunctionNode fn;
        AstNode ret;
        if (!this.insideFunctionBody()) {
            this.reportError(tt == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        boolean yieldStar = false;
        if (tt == 78 && this.peekToken() == 23) {
            yieldStar = true;
            this.consumeToken();
        }
        AstNode e = null;
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 91: 
            case 93: 
            case 95: 
            case 97: {
                break;
            }
            default: {
                e = this.expr(false);
                end = Parser.getNodeEnd(e);
            }
        }
        int before = this.endFlags;
        if (tt == 4) {
            this.endFlags |= e == null ? 2 : 4;
            ret = new ReturnStatement(pos, end - pos, e);
            if (Parser.nowAllSet(before, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", pos, end - pos);
            }
        } else {
            if (!this.insideFunctionBody()) {
                this.reportError("msg.bad.yield");
            }
            this.endFlags |= 8;
            ret = new Yield(pos, end - pos, e, yieldStar);
            this.setRequiresActivation();
            this.setIsGenerator();
            if (!exprContext) {
                ret.setLineColumnNumber(lineno, column);
                ret = new ExpressionStatement(ret);
            }
        }
        if (this.insideFunctionBody() && Parser.nowAllSet(before, this.endFlags, 12) && !(fn = (FunctionNode)this.currentScriptOrFn).isES6Generator()) {
            Name name = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (name == null || name.length() == 0) {
                this.addError("msg.anon.generator.returns", "");
            } else {
                this.addError("msg.generator.returns", name.getIdentifier());
            }
        }
        ret.setLineColumnNumber(lineno, column);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode block() throws IOException {
        if (this.currentToken != 94) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        Scope block = new Scope(pos);
        block.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        this.pushScope(block);
        try {
            this.statements(block);
            this.mustMatchToken(95, "msg.no.brace.block", true);
            block.setLength(this.ts.tokenEnd - pos);
            Scope scope = block;
            return scope;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode defaultXmlNamespace() throws IOException {
        if (this.currentToken != 129) {
            this.codeBug();
        }
        this.consumeToken();
        this.mustHaveXML();
        this.setRequiresActivation();
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int pos = this.ts.tokenBeg;
        if (!this.matchToken(44, true) || !"xml".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(44, true) || !"namespace".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(99, true)) {
            this.reportError("msg.bad.namespace");
        }
        AstNode e = this.expr(false);
        UnaryExpression dxmln = new UnaryExpression(pos, Parser.getNodeEnd(e) - pos);
        dxmln.setOperator(82);
        dxmln.setOperand(e);
        dxmln.setLineColumnNumber(lineno, column);
        ExpressionStatement es = new ExpressionStatement(dxmln, true);
        return es;
    }

    private void recordLabel(Label label, LabeledStatement bundle) throws IOException {
        if (this.peekToken() != 116) {
            this.codeBug();
        }
        this.consumeToken();
        String name = label.getName();
        if (this.labelSet == null) {
            this.labelSet = new HashMap<String, LabeledStatement>();
        } else {
            LabeledStatement ls = this.labelSet.get(name);
            if (ls != null) {
                if (this.compilerEnv.isIdeMode()) {
                    Label dup = ls.getLabelByName(name);
                    this.reportError("msg.dup.label", dup.getAbsolutePosition(), dup.getLength());
                }
                this.reportError("msg.dup.label", label.getPosition(), label.getLength());
            }
        }
        bundle.addLabel(label);
        this.labelSet.put(name, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode nameOrLabel() throws IOException {
        if (this.currentToken != 44) {
            throw this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        this.currentFlaggedToken |= 0x20000;
        AstNode expr = this.expr(false);
        if (expr.getType() != 144) {
            ExpressionStatement n = new ExpressionStatement(expr, !this.insideFunctionBody());
            n.setLineColumnNumber(expr.getLineno(), expr.getColumn());
            return n;
        }
        LabeledStatement bundle = new LabeledStatement(pos);
        this.recordLabel((Label)expr, bundle);
        bundle.setLineColumnNumber(expr.getLineno(), expr.getColumn());
        AstNode stmt = null;
        while (this.peekToken() == 44) {
            this.currentFlaggedToken |= 0x20000;
            expr = this.expr(false);
            if (expr.getType() != 144) {
                stmt = new ExpressionStatement(expr, !this.insideFunctionBody());
                this.autoInsertSemicolon(stmt);
                break;
            }
            this.recordLabel((Label)expr, bundle);
        }
        try {
            this.currentLabel = bundle;
            if (stmt == null) {
                stmt = this.statementHelper();
                int ntt = this.peekToken();
                if (ntt == 175 && stmt.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    stmt.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
            }
        }
        finally {
            this.currentLabel = null;
            for (Label lb : bundle.getLabels()) {
                this.labelSet.remove(lb.getName());
            }
        }
        bundle.setLength(stmt.getParent() == null ? Parser.getNodeEnd(stmt) - pos : Parser.getNodeEnd(stmt));
        bundle.setStatement(stmt);
        return bundle;
    }

    private VariableDeclaration variables(int declType, int pos, boolean isStatement) throws IOException {
        int end;
        VariableDeclaration pn = new VariableDeclaration(pos);
        pn.setType(declType);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        Comment varjsdocNode = this.getAndResetJsDoc();
        if (varjsdocNode != null) {
            pn.setJsDocNode(varjsdocNode);
        }
        do {
            AstNode destructuring = null;
            Name name = null;
            int tt = this.peekToken();
            int kidPos = this.ts.tokenBeg;
            end = this.ts.tokenEnd;
            if (tt == 92 || tt == 94) {
                destructuring = this.destructuringPrimaryExpr();
                end = Parser.getNodeEnd(destructuring);
                if (!(destructuring instanceof DestructuringForm)) {
                    this.reportError("msg.bad.assign.left", kidPos, end - kidPos);
                }
                this.markDestructuring(destructuring);
            } else {
                String id;
                this.mustMatchToken(44, "msg.bad.var", true);
                name = this.createNameNode();
                name.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                if (this.inUseStrictDirective && ("eval".equals(id = this.ts.getString()) || "arguments".equals(this.ts.getString()))) {
                    this.reportError("msg.bad.id.strict", id);
                }
                this.defineSymbol(declType, this.ts.getString(), this.inForInit);
            }
            int lineno = this.lineNumber();
            int column = this.columnNumber();
            Comment jsdocNode = this.getAndResetJsDoc();
            AstNode init = null;
            if (this.matchToken(99, true)) {
                init = this.assignExpr();
                end = Parser.getNodeEnd(init);
            }
            VariableInitializer vi = new VariableInitializer(kidPos, end - kidPos);
            if (destructuring != null) {
                if (init == null && !this.inForInit) {
                    this.reportError("msg.destruct.assign.no.init");
                }
                vi.setTarget(destructuring);
            } else {
                vi.setTarget(name);
            }
            vi.setInitializer(init);
            vi.setType(declType);
            vi.setJsDocNode(jsdocNode);
            vi.setLineColumnNumber(lineno, column);
            pn.addVariable(vi);
        } while (this.matchToken(98, true));
        pn.setLength(end - pos);
        pn.setIsStatement(isStatement);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode let(boolean isStatement, int pos) throws IOException {
        LetNode pn = new LetNode(pos);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        if (this.mustMatchToken(96, "msg.no.paren.after.let", true)) {
            pn.setLp(this.ts.tokenBeg - pos);
        }
        this.pushScope(pn);
        try {
            VariableDeclaration vars = this.variables(167, this.ts.tokenBeg, isStatement);
            pn.setVariables(vars);
            if (this.mustMatchToken(97, "msg.no.paren.let", true)) {
                pn.setRp(this.ts.tokenBeg - pos);
            }
            if (isStatement && this.peekToken() == 94) {
                this.consumeToken();
                int beg = this.ts.tokenBeg;
                AstNode stmt = this.statements();
                this.mustMatchToken(95, "msg.no.curly.let", true);
                stmt.setLength(this.ts.tokenEnd - beg);
                pn.setLength(this.ts.tokenEnd - pos);
                pn.setBody(stmt);
                pn.setType(167);
            } else {
                AstNode expr = this.expr(false);
                pn.setLength(Parser.getNodeEnd(expr) - pos);
                pn.setBody(expr);
                if (isStatement) {
                    ExpressionStatement es = new ExpressionStatement(pn, !this.insideFunctionBody());
                    es.setLineColumnNumber(pn.getLineno(), pn.getColumn());
                    ExpressionStatement expressionStatement = es;
                    return expressionStatement;
                }
            }
        }
        finally {
            this.popScope();
        }
        return pn;
    }

    void defineSymbol(int declType, String name) {
        this.defineSymbol(declType, name, false);
    }

    void defineSymbol(int declType, String name, boolean ignoreNotInBlock) {
        int symDeclType;
        Scope definingScope;
        if (name == null) {
            if (this.compilerEnv.isIdeMode()) {
                return;
            }
            this.codeBug();
        }
        Symbol symbol = (definingScope = this.currentScope.getDefiningScope(name)) != null ? definingScope.getSymbol(name) : null;
        int n = symDeclType = symbol != null ? symbol.getDeclType() : -1;
        if (symbol != null && (symDeclType == 168 || declType == 168 || definingScope == this.currentScope && symDeclType == 167)) {
            this.addError(symDeclType == 168 ? "msg.const.redecl" : (symDeclType == 167 ? "msg.let.redecl" : (symDeclType == 135 ? "msg.var.redecl" : (symDeclType == 122 ? "msg.fn.redecl" : "msg.parm.redecl"))), name);
            return;
        }
        switch (declType) {
            case 167: {
                if (!ignoreNotInBlock && (this.currentScope.getType() == 125 || this.currentScope instanceof Loop)) {
                    this.addError("msg.let.decl.not.in.block");
                    return;
                }
                this.currentScope.putSymbol(new Symbol(declType, name));
                return;
            }
            case 122: 
            case 135: 
            case 168: {
                if (symbol != null) {
                    if (symDeclType == 135) {
                        this.addStrictWarning("msg.var.redecl", name);
                    } else if (symDeclType == 96) {
                        this.addStrictWarning("msg.var.hides.arg", name);
                    }
                } else {
                    this.currentScriptOrFn.putSymbol(new Symbol(declType, name));
                }
                return;
            }
            case 96: {
                if (symbol != null) {
                    this.addWarning("msg.dup.parms", name);
                }
                this.currentScriptOrFn.putSymbol(new Symbol(declType, name));
                return;
            }
        }
        throw this.codeBug();
    }

    private AstNode expr(boolean allowTrailingComma) throws IOException {
        AstNode pn = this.assignExpr();
        int pos = pn.getPosition();
        while (this.matchToken(98, true)) {
            int opPos = this.ts.tokenBeg;
            if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", pos, Parser.nodeEnd(pn) - pos);
            }
            if (this.peekToken() == 78) {
                this.reportError("msg.yield.parenthesized");
            }
            if (allowTrailingComma && this.peekToken() == 97) {
                pn.putIntProp(28, 1);
                return pn;
            }
            pn = new InfixExpression(98, pn, this.assignExpr(), opPos);
        }
        return pn;
    }

    private AstNode assignExpr() throws IOException {
        int tt = this.peekToken();
        if (tt == 78) {
            return this.returnOrYield(tt, true);
        }
        int startLine = this.ts.lineno;
        int startColumn = this.ts.getTokenColumn();
        AstNode pn = this.condExpr();
        boolean hasEOL = false;
        tt = this.peekTokenOrEOL();
        if (tt == 1) {
            hasEOL = true;
            tt = this.peekToken();
        }
        if (99 <= tt && tt <= 114) {
            this.consumeToken();
            Comment jsdocNode = this.getAndResetJsDoc();
            this.markDestructuring(pn);
            int opPos = this.ts.tokenBeg;
            if (Parser.isNotValidSimpleAssignmentTarget(pn)) {
                this.reportError("msg.syntax.invalid.assignment.lhs");
            }
            pn = new Assignment(tt, pn, this.assignExpr(), opPos);
            if (jsdocNode != null) {
                pn.setJsDocNode(jsdocNode);
            }
        } else if (tt == 91) {
            if (this.currentJsDocComment != null) {
                pn.setJsDocNode(this.getAndResetJsDoc());
            }
        } else if (!hasEOL && tt == 178) {
            this.consumeToken();
            pn = this.arrowFunction(pn, startLine, startColumn);
        } else if (pn.getIntProp(29, 0) == 1 && !this.inDestructuringAssignment) {
            this.reportError("msg.syntax");
        }
        return pn;
    }

    private static boolean isNotValidSimpleAssignmentTarget(AstNode pn) {
        if (pn.getType() == 33) {
            return Parser.isNotValidSimpleAssignmentTarget(((PropertyGet)pn).getLeft());
        }
        return pn.getType() == 186;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode condExpr() throws IOException {
        AstNode pn = this.nullishCoalescingExpr();
        if (this.matchToken(115, true)) {
            AstNode ifTrue;
            int qmarkPos = this.ts.tokenBeg;
            int colonPos = -1;
            boolean wasInForInit = this.inForInit;
            this.inForInit = false;
            try {
                ifTrue = this.assignExpr();
            }
            finally {
                this.inForInit = wasInForInit;
            }
            if (this.mustMatchToken(116, "msg.no.colon.cond", true)) {
                colonPos = this.ts.tokenBeg;
            }
            AstNode ifFalse = this.assignExpr();
            int beg = pn.getPosition();
            int len = Parser.getNodeEnd(ifFalse) - beg;
            ConditionalExpression ce = new ConditionalExpression(beg, len);
            ce.setLineColumnNumber(pn.getLineno(), pn.getColumn());
            ce.setTestExpression(pn);
            ce.setTrueExpression(ifTrue);
            ce.setFalseExpression(ifFalse);
            ce.setQuestionMarkPosition(qmarkPos - beg);
            ce.setColonPosition(colonPos - beg);
            pn = ce;
        }
        return pn;
    }

    private AstNode nullishCoalescingExpr() throws IOException {
        AstNode pn = this.orExpr();
        if (this.matchToken(185, true)) {
            int opPos = this.ts.tokenBeg;
            AstNode rn = this.nullishCoalescingExpr();
            if (pn.getType() == 117 || pn.getType() == 118 || rn.getType() == 117 || rn.getType() == 118) {
                this.reportError("msg.nullish.bad.token");
            }
            pn = new InfixExpression(185, pn, rn, opPos);
        }
        return pn;
    }

    private AstNode orExpr() throws IOException {
        AstNode pn = this.andExpr();
        if (this.matchToken(117, true)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(117, pn, this.orExpr(), opPos);
        }
        return pn;
    }

    private AstNode andExpr() throws IOException {
        AstNode pn = this.bitOrExpr();
        if (this.matchToken(118, true)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(118, pn, this.andExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitOrExpr() throws IOException {
        AstNode pn = this.bitXorExpr();
        while (this.matchToken(9, true)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(9, pn, this.bitXorExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitXorExpr() throws IOException {
        AstNode pn = this.bitAndExpr();
        while (this.matchToken(10, true)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(10, pn, this.bitAndExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitAndExpr() throws IOException {
        AstNode pn = this.eqExpr();
        while (this.matchToken(11, true)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(11, pn, this.eqExpr(), opPos);
        }
        return pn;
    }

    private AstNode eqExpr() throws IOException {
        AstNode pn = this.relExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 12: 
                case 13: 
                case 51: 
                case 52: {
                    this.consumeToken();
                    int parseToken = tt;
                    pn = new InfixExpression(parseToken, pn, this.relExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode relExpr() throws IOException {
        AstNode pn = this.shiftExpr();
        block4: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 57: {
                    if (this.inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 58: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.shiftExpr(), opPos);
                    continue block4;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode shiftExpr() throws IOException {
        AstNode pn = this.addExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.addExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode addExpr() throws IOException {
        AstNode pn = this.mulExpr();
        while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            if (tt != 21 && tt != 22) break;
            this.consumeToken();
            pn = new InfixExpression(tt, pn, this.mulExpr(), opPos);
        }
        return pn;
    }

    private AstNode mulExpr() throws IOException {
        AstNode pn = this.expExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.expExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode expExpr() throws IOException {
        AstNode pn = this.unaryExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 81: {
                    if (pn instanceof UnaryExpression) {
                        this.reportError("msg.no.unary.expr.on.left.exp", AstNode.operatorToString(pn.getType()));
                        return this.makeErrorNode();
                    }
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.expExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode unaryExpr() throws IOException {
        int tt = this.peekToken();
        if (tt == 175) {
            this.consumeToken();
            tt = this.peekUntilNonComment(tt);
        }
        switch (tt) {
            case 26: 
            case 27: 
            case 32: 
            case 139: {
                this.consumeToken();
                int line = this.lineNumber();
                int column = this.columnNumber();
                UnaryExpression node = new UnaryExpression(tt, this.ts.tokenBeg, this.unaryExpr());
                node.setLineColumnNumber(line, column);
                return node;
            }
            case 21: {
                this.consumeToken();
                int line = this.lineNumber();
                int column = this.columnNumber();
                UnaryExpression node = new UnaryExpression(28, this.ts.tokenBeg, this.unaryExpr());
                node.setLineColumnNumber(line, column);
                return node;
            }
            case 22: {
                this.consumeToken();
                int line = this.lineNumber();
                int column = this.columnNumber();
                UnaryExpression node = new UnaryExpression(29, this.ts.tokenBeg, this.unaryExpr());
                node.setLineColumnNumber(line, column);
                return node;
            }
            case 119: 
            case 120: {
                this.consumeToken();
                int line = this.lineNumber();
                int column = this.columnNumber();
                UpdateExpression expr = new UpdateExpression(tt, this.ts.tokenBeg, this.memberExpr(true));
                expr.setLineColumnNumber(line, column);
                this.checkBadIncDec(expr);
                return expr;
            }
            case 31: {
                this.consumeToken();
                int line = this.lineNumber();
                int column = this.columnNumber();
                UnaryExpression node = new UnaryExpression(tt, this.ts.tokenBeg, this.unaryExpr());
                node.setLineColumnNumber(line, column);
                return node;
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 14: {
                if (!this.compilerEnv.isXmlAvailable()) break;
                this.consumeToken();
                return this.memberExprTail(true, this.xmlInitializer());
            }
        }
        AstNode pn = this.memberExpr(true);
        tt = this.peekTokenOrEOL();
        if (tt != 119 && tt != 120) {
            return pn;
        }
        this.consumeToken();
        UpdateExpression uexpr = new UpdateExpression(tt, this.ts.tokenBeg, pn, true);
        uexpr.setLineColumnNumber(pn.getLineno(), pn.getColumn());
        this.checkBadIncDec(uexpr);
        return uexpr;
    }

    private AstNode xmlInitializer() throws IOException {
        if (this.currentToken != 14) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int tt = this.ts.getFirstXMLToken();
        if (tt != 159 && tt != 162) {
            this.reportError("msg.syntax");
            return this.makeErrorNode();
        }
        XmlLiteral pn = new XmlLiteral(pos);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        while (true) {
            switch (tt) {
                case 159: {
                    pn.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    this.mustMatchToken(94, "msg.syntax", true);
                    int beg = this.ts.tokenBeg;
                    AstNode expr = this.peekToken() == 95 ? new EmptyExpression(beg, this.ts.tokenEnd - beg) : this.expr(false);
                    this.mustMatchToken(95, "msg.syntax", true);
                    XmlExpression xexpr = new XmlExpression(beg, expr);
                    xexpr.setIsXmlAttribute(this.ts.isXMLAttribute());
                    xexpr.setLength(this.ts.tokenEnd - beg);
                    pn.addFragment(xexpr);
                    break;
                }
                case 162: {
                    pn.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    return pn;
                }
                default: {
                    this.reportError("msg.syntax");
                    return this.makeErrorNode();
                }
            }
            tt = this.ts.getNextXMLToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AstNode> argumentList() throws IOException {
        if (this.matchToken(97, true)) {
            return null;
        }
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        boolean wasInForInit = this.inForInit;
        this.inForInit = false;
        try {
            do {
                if (this.peekToken() == 97) {
                    break;
                }
                if (this.peekToken() == 78) {
                    this.reportError("msg.yield.parenthesized");
                }
                AstNode en = this.assignExpr();
                if (this.peekToken() == 132) {
                    try {
                        result.add(this.generatorExpression(en, 0, true));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                result.add(en);
            } while (this.matchToken(98, true));
        }
        finally {
            this.inForInit = wasInForInit;
        }
        this.mustMatchToken(97, "msg.no.paren.arg", true);
        return result;
    }

    private AstNode memberExpr(boolean allowCallSyntax) throws IOException {
        AstNode pn;
        int tt = this.peekToken();
        if (tt != 30) {
            pn = this.primaryExpr();
        } else {
            this.consumeToken();
            int pos = this.ts.tokenBeg;
            int lineno = this.lineNumber();
            int column = this.columnNumber();
            NewExpression nx = new NewExpression(pos);
            AstNode target = this.memberExpr(false);
            int end = Parser.getNodeEnd(target);
            nx.setTarget(target);
            nx.setLineColumnNumber(lineno, column);
            int lp = -1;
            if (this.matchToken(96, true)) {
                lp = this.ts.tokenBeg;
                List<AstNode> args = this.argumentList();
                if (args != null && args.size() > 65536) {
                    this.reportError("msg.too.many.constructor.args");
                }
                int rp = this.ts.tokenBeg;
                end = this.ts.tokenEnd;
                if (args != null) {
                    nx.setArguments(args);
                }
                nx.setParens(lp - pos, rp - pos);
            }
            if (this.matchToken(94, true)) {
                ObjectLiteral initializer = this.objectLiteral();
                end = Parser.getNodeEnd(initializer);
                nx.setInitializer(initializer);
            }
            nx.setLength(end - pos);
            pn = nx;
        }
        return this.memberExprTail(allowCallSyntax, pn);
    }

    private AstNode memberExprTail(boolean allowCallSyntax, AstNode pn) throws IOException {
        if (pn == null) {
            this.codeBug();
        }
        int pos = pn.getPosition();
        boolean isOptionalChain = false;
        block8: while (true) {
            int lineno = this.lineNumber();
            int column = this.columnNumber();
            int tt = this.peekToken();
            switch (tt) {
                case 121: 
                case 157: 
                case 186: {
                    pn = this.propertyAccess(tt, pn, isOptionalChain |= tt == 186);
                    continue block8;
                }
                case 160: {
                    this.consumeToken();
                    int opPos = this.ts.tokenBeg;
                    int rp = -1;
                    this.mustHaveXML();
                    this.setRequiresActivation();
                    AstNode filter = this.expr(false);
                    int end = Parser.getNodeEnd(filter);
                    if (this.mustMatchToken(97, "msg.no.paren", true)) {
                        rp = this.ts.tokenBeg;
                        end = this.ts.tokenEnd;
                    }
                    XmlDotQuery q = new XmlDotQuery(pos, end - pos);
                    q.setLeft(pn);
                    q.setRight(filter);
                    q.setOperatorPosition(opPos);
                    q.setRp(rp - pos);
                    q.setLineColumnNumber(lineno, column);
                    pn = q;
                    continue block8;
                }
                case 92: {
                    this.consumeToken();
                    pn = this.makeElemGet(pn, this.ts.tokenBeg);
                    continue block8;
                }
                case 96: {
                    if (!allowCallSyntax) break block8;
                    pn = this.makeFunctionCall(pn, pos, isOptionalChain);
                    continue block8;
                }
                case 175: {
                    int currentFlagTOken = this.currentFlaggedToken;
                    this.peekUntilNonComment(tt);
                    this.currentFlaggedToken = (this.currentFlaggedToken & 0x10000) != 0 ? this.currentFlaggedToken : currentFlagTOken;
                    continue block8;
                }
                case 180: {
                    this.consumeToken();
                    pn = this.taggedTemplateLiteral(pn);
                    continue block8;
                }
            }
            break;
        }
        return pn;
    }

    private FunctionCall makeFunctionCall(AstNode pn, int pos, boolean isOptionalChain) throws IOException {
        this.consumeToken();
        this.checkCallRequiresActivation(pn);
        FunctionCall f = new FunctionCall(pos);
        f.setTarget(pn);
        f.setLp(this.ts.tokenBeg - pos);
        List<AstNode> args = this.argumentList();
        if (args != null && args.size() > 65536) {
            this.reportError("msg.too.many.function.args");
        }
        f.setArguments(args);
        f.setRp(this.ts.tokenBeg - pos);
        f.setLength(this.ts.tokenEnd - pos);
        if (isOptionalChain) {
            f.markIsOptionalCall();
        }
        return f;
    }

    private AstNode taggedTemplateLiteral(AstNode pn) throws IOException {
        AstNode templateLiteral = this.templateLiteral(true);
        TaggedTemplateLiteral tagged = new TaggedTemplateLiteral();
        tagged.setTarget(pn);
        tagged.setTemplateLiteral(templateLiteral);
        tagged.setLineColumnNumber(pn.getLineno(), pn.getColumn());
        return tagged;
    }

    private AstNode propertyAccess(int tt, AstNode pn, boolean isOptionalChain) throws IOException {
        InfixExpression result;
        if (pn == null) {
            this.codeBug();
        }
        if (pn.getType() == 79 && isOptionalChain) {
            this.reportError("msg.optional.super");
            return this.makeErrorNode();
        }
        int memberTypeFlags = 0;
        int lineno = this.lineNumber();
        int dotPos = this.ts.tokenBeg;
        int column = this.columnNumber();
        this.consumeToken();
        if (tt == 157) {
            this.mustHaveXML();
            memberTypeFlags = 4;
        }
        if (!this.compilerEnv.isXmlAvailable()) {
            int maybeName = this.nextToken();
            if (!(maybeName == 44 || this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective))) {
                this.reportError("msg.no.name.after.dot");
            }
            Name name = this.createNameNode(true, 33);
            PropertyGet pg = new PropertyGet(pn, name, dotPos);
            pg.setLineColumnNumber(lineno, column);
            return pg;
        }
        AstNode ref = null;
        int token = this.nextToken();
        switch (token) {
            case 55: {
                this.saveNameTokenData(this.ts.tokenBeg, "throw", this.lineNumber(), this.columnNumber());
                ref = this.propertyName(-1, memberTypeFlags);
                break;
            }
            case 44: {
                ref = this.propertyName(-1, memberTypeFlags);
                break;
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.lineNumber(), this.columnNumber());
                ref = this.propertyName(-1, memberTypeFlags);
                break;
            }
            case 161: {
                ref = this.attributeAccess();
                break;
            }
            case 140: {
                String name = this.ts.getString();
                this.saveNameTokenData(this.ts.tokenBeg, name, this.lineNumber(), this.columnNumber());
                ref = this.propertyName(-1, memberTypeFlags);
                break;
            }
            case 92: {
                if (tt == 186) {
                    this.consumeToken();
                    ElementGet g = this.makeElemGet(pn, this.ts.tokenBeg);
                    g.setType(186);
                    return g;
                }
                this.reportError("msg.no.name.after.dot");
                return this.makeErrorNode();
            }
            case 96: {
                if (tt == 186) {
                    return this.makeFunctionCall(pn, pn.getPosition(), isOptionalChain);
                }
                this.reportError("msg.no.name.after.dot");
                return this.makeErrorNode();
            }
            default: {
                String name;
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && (name = Token.keywordToName(token)) != null) {
                    this.saveNameTokenData(this.ts.tokenBeg, name, this.lineNumber(), this.columnNumber());
                    ref = this.propertyName(-1, memberTypeFlags);
                    break;
                }
                this.reportError("msg.no.name.after.dot");
                return this.makeErrorNode();
            }
        }
        boolean xml = ref instanceof XmlRef;
        InfixExpression infixExpression = result = xml ? new XmlMemberGet() : new PropertyGet();
        if (xml && tt == 121) {
            result.setType(121);
        }
        if (isOptionalChain) {
            result.setType(186);
        }
        int pos = pn.getPosition();
        result.setPosition(pos);
        result.setLength(Parser.getNodeEnd(ref) - pos);
        result.setOperatorPosition(dotPos - pos);
        result.setLineColumnNumber(lineno, column);
        result.setLeft(pn);
        result.setRight(ref);
        return result;
    }

    private ElementGet makeElemGet(AstNode pn, int lb) throws IOException {
        int pos = pn.getPosition();
        AstNode expr = this.expr(false);
        int end = Parser.getNodeEnd(expr);
        int rb = -1;
        if (this.mustMatchToken(93, "msg.no.bracket.index", true)) {
            rb = this.ts.tokenBeg;
            end = this.ts.tokenEnd;
        }
        ElementGet g = new ElementGet(pos, end - pos);
        g.setTarget(pn);
        g.setElement(expr);
        g.setParens(lb, rb);
        return g;
    }

    private AstNode attributeAccess() throws IOException {
        int tt = this.nextToken();
        int atPos = this.ts.tokenBeg;
        switch (tt) {
            case 44: {
                return this.propertyName(atPos, 0);
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.lineNumber(), this.columnNumber());
                return this.propertyName(atPos, 0);
            }
            case 92: {
                return this.xmlElemRef(atPos, null, -1);
            }
        }
        this.reportError("msg.no.name.after.xmlAttr");
        return this.makeErrorNode();
    }

    private AstNode propertyName(int atPos, int memberTypeFlags) throws IOException {
        int pos = atPos != -1 ? atPos : this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int colonPos = -1;
        Name name = this.createNameNode(true, this.currentToken);
        Name ns = null;
        if (this.matchToken(158, true)) {
            ns = name;
            colonPos = this.ts.tokenBeg;
            switch (this.nextToken()) {
                case 44: {
                    name = this.createNameNode();
                    break;
                }
                case 23: {
                    this.saveNameTokenData(this.ts.tokenBeg, "*", this.lineNumber(), this.columnNumber());
                    name = this.createNameNode(false, -1);
                    break;
                }
                case 92: {
                    return this.xmlElemRef(atPos, ns, colonPos);
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    return this.makeErrorNode();
                }
            }
        }
        if (ns == null && memberTypeFlags == 0 && atPos == -1) {
            return name;
        }
        XmlPropRef ref = new XmlPropRef(pos, Parser.getNodeEnd(name) - pos);
        ref.setAtPos(atPos);
        ref.setNamespace(ns);
        ref.setColonPos(colonPos);
        ref.setPropName(name);
        ref.setLineColumnNumber(lineno, column);
        return ref;
    }

    private XmlElemRef xmlElemRef(int atPos, Name namespace, int colonPos) throws IOException {
        int lb = this.ts.tokenBeg;
        int rb = -1;
        int pos = atPos != -1 ? atPos : lb;
        AstNode expr = this.expr(false);
        int end = Parser.getNodeEnd(expr);
        if (this.mustMatchToken(93, "msg.no.bracket.index", true)) {
            rb = this.ts.tokenBeg;
            end = this.ts.tokenEnd;
        }
        XmlElemRef ref = new XmlElemRef(pos, end - pos);
        ref.setNamespace(namespace);
        ref.setColonPos(colonPos);
        ref.setAtPos(atPos);
        ref.setExpression(expr);
        ref.setBrackets(lb, rb);
        return ref;
    }

    private AstNode destructuringAssignExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.assignExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private AstNode destructuringPrimaryExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.primaryExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private AstNode primaryExpr() throws IOException {
        int ttFlagged = this.peekFlaggedToken();
        int tt = ttFlagged & 0xFFFF;
        switch (tt) {
            case 122: {
                this.consumeToken();
                return this.function(2);
            }
            case 92: {
                this.consumeToken();
                return this.arrayLiteral();
            }
            case 94: {
                this.consumeToken();
                return this.objectLiteral();
            }
            case 167: {
                this.consumeToken();
                return this.let(false, this.ts.tokenBeg);
            }
            case 96: {
                this.consumeToken();
                return this.parenExpr();
            }
            case 161: {
                this.consumeToken();
                this.mustHaveXML();
                return this.attributeAccess();
            }
            case 44: {
                this.consumeToken();
                return this.name(ttFlagged, tt);
            }
            case 45: 
            case 89: {
                this.consumeToken();
                return this.createNumericLiteral(tt, false);
            }
            case 46: {
                this.consumeToken();
                return this.createStringLiteral();
            }
            case 24: 
            case 111: {
                this.consumeToken();
                this.ts.readRegExp(tt);
                int pos = this.ts.tokenBeg;
                int end = this.ts.tokenEnd;
                RegExpLiteral re = new RegExpLiteral(pos, end - pos);
                re.setValue(this.ts.getString());
                re.setFlags(this.ts.readAndClearRegExpFlags());
                re.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                return re;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.consumeToken();
                int pos = this.ts.tokenBeg;
                int end = this.ts.tokenEnd;
                KeywordLiteral keywordLiteral = new KeywordLiteral(pos, end - pos, tt);
                keywordLiteral.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                return keywordLiteral;
            }
            case 79: {
                if ((this.insideFunctionParams() || this.insideFunctionBody()) && this.insideMethod || this.compilerEnv.isAllowSuper()) {
                    this.consumeToken();
                    int pos = this.ts.tokenBeg;
                    int end = this.ts.tokenEnd;
                    KeywordLiteral keywordLiteral = new KeywordLiteral(pos, end - pos, tt);
                    keywordLiteral.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                    return keywordLiteral;
                }
                this.reportError("msg.super.shorthand.function");
                break;
            }
            case 180: {
                this.consumeToken();
                return this.templateLiteral(false);
            }
            case 140: {
                this.consumeToken();
                this.reportError("msg.reserved.id", this.ts.getString());
                break;
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 0: {
                this.consumeToken();
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.consumeToken();
                this.reportError("msg.syntax");
            }
        }
        this.consumeToken();
        return this.makeErrorNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parenExpr() throws IOException {
        boolean wasInForInit = this.inForInit;
        this.inForInit = false;
        try {
            boolean hasTrailingComma;
            AstNode e;
            Comment jsdocNode = this.getAndResetJsDoc();
            int lineno = this.lineNumber();
            int column = this.columnNumber();
            int begin = this.ts.tokenBeg;
            AstNode astNode = e = this.peekToken() == 97 ? new EmptyExpression(begin) : this.expr(true);
            if (this.peekToken() == 132) {
                AstNode astNode2 = this.generatorExpression(e, begin);
                return astNode2;
            }
            this.mustMatchToken(97, "msg.no.paren", true);
            int length = this.ts.tokenEnd - begin;
            boolean hasObjectLiteralDestructuring = e.getIntProp(29, 0) == 1;
            boolean bl = hasTrailingComma = e.getIntProp(28, 0) == 1;
            if ((hasTrailingComma || hasObjectLiteralDestructuring || e.getType() == 141) && this.peekToken() != 178) {
                this.reportError("msg.syntax");
                ErrorNode errorNode = this.makeErrorNode();
                return errorNode;
            }
            ParenthesizedExpression pn = new ParenthesizedExpression(begin, length, e);
            pn.setLineColumnNumber(lineno, column);
            if (jsdocNode == null) {
                jsdocNode = this.getAndResetJsDoc();
            }
            if (jsdocNode != null) {
                pn.setJsDocNode(jsdocNode);
            }
            if (hasTrailingComma) {
                pn.putIntProp(28, 1);
            }
            ParenthesizedExpression parenthesizedExpression = pn;
            return parenthesizedExpression;
        }
        finally {
            this.inForInit = wasInForInit;
        }
    }

    private AstNode name(int ttFlagged, int tt) throws IOException {
        String nameString = this.ts.getString();
        int namePos = this.ts.tokenBeg;
        int nameLineno = this.lineNumber();
        int nameColumn = this.columnNumber();
        if (0 != (ttFlagged & 0x20000) && this.peekToken() == 116) {
            Label label = new Label(namePos, this.ts.tokenEnd - namePos);
            label.setName(nameString);
            label.setLineColumnNumber(this.lineNumber(), this.columnNumber());
            return label;
        }
        this.saveNameTokenData(namePos, nameString, nameLineno, nameColumn);
        if (this.compilerEnv.isXmlAvailable()) {
            return this.propertyName(-1, 0);
        }
        return this.createNameNode(true, 44);
    }

    private AstNode arrayLiteral() throws IOException {
        if (this.currentToken != 92) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        ArrayList<AstNode> elements = new ArrayList<AstNode>();
        ArrayLiteral pn = new ArrayLiteral(pos);
        boolean after_lb_or_comma = true;
        int afterComma = -1;
        int skipCount = 0;
        while (true) {
            int tt;
            if ((tt = this.peekToken()) == 98) {
                this.consumeToken();
                afterComma = this.ts.tokenEnd;
                if (!after_lb_or_comma) {
                    after_lb_or_comma = true;
                    continue;
                }
                elements.add(new EmptyExpression(this.ts.tokenBeg, 1));
                ++skipCount;
                continue;
            }
            if (tt == 175) {
                this.consumeToken();
                continue;
            }
            if (tt == 93) {
                this.consumeToken();
                end = this.ts.tokenEnd;
                pn.setDestructuringLength(elements.size() + (after_lb_or_comma ? 1 : 0));
                pn.setSkipCount(skipCount);
                if (afterComma == -1) break;
                this.warnTrailingComma(pos, elements, afterComma);
                break;
            }
            if (tt == 132 && !after_lb_or_comma && elements.size() == 1) {
                return this.arrayComprehension((AstNode)elements.get(0), pos);
            }
            if (tt == 0) {
                this.reportError("msg.no.bracket.arg");
                break;
            }
            if (!after_lb_or_comma) {
                this.reportError("msg.no.bracket.arg");
            }
            elements.add(this.assignExpr());
            after_lb_or_comma = false;
            afterComma = -1;
        }
        for (AstNode e : elements) {
            pn.addElement(e);
        }
        pn.setLength(end - pos);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private AstNode arrayComprehension(AstNode result, int pos) throws IOException {
        ArrayList<ArrayComprehensionLoop> loops = new ArrayList<ArrayComprehensionLoop>();
        while (this.peekToken() == 132) {
            loops.add(this.arrayComprehensionLoop());
        }
        int ifPos = -1;
        ConditionData data = null;
        if (this.peekToken() == 125) {
            this.consumeToken();
            ifPos = this.ts.tokenBeg - pos;
            data = this.condition();
        }
        this.mustMatchToken(93, "msg.no.bracket.arg", true);
        ArrayComprehension pn = new ArrayComprehension(pos, this.ts.tokenEnd - pos);
        pn.setResult(result);
        pn.setLoops(loops);
        if (data != null) {
            pn.setIfPosition(ifPos);
            pn.setFilter(data.condition);
            pn.setFilterLp(data.lp - pos);
            pn.setFilterRp(data.rp - pos);
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayComprehensionLoop arrayComprehensionLoop() throws IOException {
        if (this.nextToken() != 132) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int eachPos = -1;
        int lp = -1;
        int rp = -1;
        int inPos = -1;
        boolean isForOf = false;
        ArrayComprehensionLoop pn = new ArrayComprehensionLoop(pos);
        this.pushScope(pn);
        try {
            if (this.matchToken(44, true)) {
                if (this.ts.getString().equals("each")) {
                    eachPos = this.ts.tokenBeg - pos;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(96, "msg.no.paren.for", true)) {
                lp = this.ts.tokenBeg - pos;
            }
            AstNode iter = null;
            switch (this.peekToken()) {
                case 92: 
                case 94: {
                    iter = this.destructuringPrimaryExpr();
                    this.markDestructuring(iter);
                    break;
                }
                case 44: {
                    this.consumeToken();
                    iter = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (iter.getType() == 44) {
                this.defineSymbol(167, this.ts.getString(), true);
            }
            switch (this.nextToken()) {
                case 57: {
                    inPos = this.ts.tokenBeg - pos;
                    break;
                }
                case 44: {
                    if ("of".equals(this.ts.getString())) {
                        if (eachPos != -1) {
                            this.reportError("msg.invalid.for.each");
                        }
                        inPos = this.ts.tokenBeg - pos;
                        isForOf = true;
                        break;
                    }
                }
                default: {
                    this.reportError("msg.in.after.for.name");
                }
            }
            AstNode obj = this.expr(false);
            if (this.mustMatchToken(97, "msg.no.paren.for.ctrl", true)) {
                rp = this.ts.tokenBeg - pos;
            }
            pn.setLength(this.ts.tokenEnd - pos);
            pn.setIterator(iter);
            pn.setIteratedObject(obj);
            pn.setInPosition(inPos);
            pn.setEachPosition(eachPos);
            pn.setIsForEach(eachPos != -1);
            pn.setParens(lp, rp);
            pn.setIsForOf(isForOf);
            ArrayComprehensionLoop arrayComprehensionLoop = pn;
            return arrayComprehensionLoop;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode generatorExpression(AstNode result, int pos) throws IOException {
        return this.generatorExpression(result, pos, false);
    }

    private AstNode generatorExpression(AstNode result, int pos, boolean inFunctionParams) throws IOException {
        ArrayList<GeneratorExpressionLoop> loops = new ArrayList<GeneratorExpressionLoop>();
        while (this.peekToken() == 132) {
            loops.add(this.generatorExpressionLoop());
        }
        int ifPos = -1;
        ConditionData data = null;
        if (this.peekToken() == 125) {
            this.consumeToken();
            ifPos = this.ts.tokenBeg - pos;
            data = this.condition();
        }
        if (!inFunctionParams) {
            this.mustMatchToken(97, "msg.no.paren.let", true);
        }
        GeneratorExpression pn = new GeneratorExpression(pos, this.ts.tokenEnd - pos);
        pn.setResult(result);
        pn.setLoops(loops);
        if (data != null) {
            pn.setIfPosition(ifPos);
            pn.setFilter(data.condition);
            pn.setFilterLp(data.lp - pos);
            pn.setFilterRp(data.rp - pos);
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneratorExpressionLoop generatorExpressionLoop() throws IOException {
        if (this.nextToken() != 132) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int lp = -1;
        int rp = -1;
        int inPos = -1;
        GeneratorExpressionLoop pn = new GeneratorExpressionLoop(pos);
        this.pushScope(pn);
        try {
            if (this.mustMatchToken(96, "msg.no.paren.for", true)) {
                lp = this.ts.tokenBeg - pos;
            }
            AstNode iter = null;
            switch (this.peekToken()) {
                case 92: 
                case 94: {
                    iter = this.destructuringPrimaryExpr();
                    this.markDestructuring(iter);
                    break;
                }
                case 44: {
                    this.consumeToken();
                    iter = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (iter.getType() == 44) {
                this.defineSymbol(167, this.ts.getString(), true);
            }
            if (this.mustMatchToken(57, "msg.in.after.for.name", true)) {
                inPos = this.ts.tokenBeg - pos;
            }
            AstNode obj = this.expr(false);
            if (this.mustMatchToken(97, "msg.no.paren.for.ctrl", true)) {
                rp = this.ts.tokenBeg - pos;
            }
            pn.setLength(this.ts.tokenEnd - pos);
            pn.setIterator(iter);
            pn.setIteratedObject(obj);
            pn.setInPosition(inPos);
            pn.setParens(lp, rp);
            GeneratorExpressionLoop generatorExpressionLoop = pn;
            return generatorExpressionLoop;
        }
        finally {
            this.popScope();
        }
    }

    private ObjectLiteral objectLiteral() throws IOException {
        int pos = this.ts.tokenBeg;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        int afterComma = -1;
        ArrayList<ObjectProperty> elems = new ArrayList<ObjectProperty>();
        HashSet<String> getterNames = null;
        HashSet<String> setterNames = null;
        if (this.inUseStrictDirective) {
            getterNames = new HashSet<String>();
            setterNames = new HashSet<String>();
        }
        Comment objJsdocNode = this.getAndResetJsDoc();
        boolean objectLiteralDestructuringDefault = false;
        while (true) {
            String propertyName = null;
            int entryKind = 1;
            int tt = this.peekToken();
            Comment jsdocNode = this.getAndResetJsDoc();
            if (tt == 175) {
                this.consumeToken();
                tt = this.peekUntilNonComment(tt);
            }
            if (tt == 95) {
                if (afterComma == -1) break;
                this.warnTrailingComma(pos, elems, afterComma);
                break;
            }
            AstNode pname = this.objliteralProperty();
            if (pname == null) {
                this.reportError("msg.bad.prop");
            } else {
                propertyName = this.ts.getString();
                int ppos = this.ts.tokenBeg;
                this.consumeToken();
                if (pname instanceof Name || pname instanceof StringLiteral) {
                    pname.setLineColumnNumber(this.lineNumber(), this.columnNumber());
                } else if (pname instanceof GeneratorMethodDefinition) {
                    ((GeneratorMethodDefinition)pname).getMethodName().setLineColumnNumber(this.lineNumber(), this.columnNumber());
                }
                int peeked = this.peekToken();
                if (peeked != 98 && peeked != 116 && peeked != 95) {
                    if (peeked == 99) {
                        objectLiteralDestructuringDefault = true;
                        elems.add(this.plainProperty(pname, tt));
                        if (!this.matchToken(98, true)) break;
                        continue;
                    }
                    if (peeked == 96) {
                        entryKind = 8;
                    } else if (pname.getType() == 44) {
                        if ("get".equals(propertyName)) {
                            entryKind = 2;
                        } else if ("set".equals(propertyName)) {
                            entryKind = 4;
                        }
                    }
                    if (entryKind == 2 || entryKind == 4) {
                        pname = this.objliteralProperty();
                        if (pname == null) {
                            this.reportError("msg.bad.prop");
                        }
                        this.consumeToken();
                    }
                    if (pname == null) {
                        propertyName = null;
                    } else {
                        propertyName = this.ts.getString();
                        ObjectProperty objectProp = this.methodDefinition(ppos, pname, entryKind, pname instanceof GeneratorMethodDefinition, true);
                        pname.setJsDocNode(jsdocNode);
                        elems.add(objectProp);
                    }
                } else {
                    pname.setJsDocNode(jsdocNode);
                    elems.add(this.plainProperty(pname, tt));
                }
                if (pname instanceof GeneratorMethodDefinition && entryKind != 8) {
                    this.reportError("msg.bad.prop");
                }
            }
            if (this.inUseStrictDirective && propertyName != null && !(pname instanceof ComputedPropertyKey)) {
                switch (entryKind) {
                    case 1: 
                    case 8: {
                        if (getterNames.contains(propertyName) || setterNames.contains(propertyName)) {
                            this.addError("msg.dup.obj.lit.prop.strict", propertyName);
                        }
                        getterNames.add(propertyName);
                        setterNames.add(propertyName);
                        break;
                    }
                    case 2: {
                        if (getterNames.contains(propertyName)) {
                            this.addError("msg.dup.obj.lit.prop.strict", propertyName);
                        }
                        getterNames.add(propertyName);
                        break;
                    }
                    case 4: {
                        if (setterNames.contains(propertyName)) {
                            this.addError("msg.dup.obj.lit.prop.strict", propertyName);
                        }
                        setterNames.add(propertyName);
                    }
                }
            }
            this.getAndResetJsDoc();
            if (!this.matchToken(98, true)) break;
            afterComma = this.ts.tokenEnd;
        }
        this.mustMatchToken(95, "msg.no.brace.prop", true);
        ObjectLiteral pn = new ObjectLiteral(pos, this.ts.tokenEnd - pos);
        if (objectLiteralDestructuringDefault) {
            pn.putIntProp(29, 1);
        }
        if (objJsdocNode != null) {
            pn.setJsDocNode(objJsdocNode);
        }
        pn.setElements(elems);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private AstNode objliteralProperty() throws IOException {
        AstNode pname;
        int tt = this.peekToken();
        switch (tt) {
            case 44: {
                pname = this.createNameNode();
                break;
            }
            case 46: {
                pname = this.createStringLiteral();
                break;
            }
            case 45: 
            case 89: {
                pname = this.createNumericLiteral(tt, true);
                break;
            }
            case 92: {
                int pos = this.ts.tokenBeg;
                this.nextToken();
                int lineno = this.lineNumber();
                int column = this.columnNumber();
                AstNode expr = this.assignExpr();
                if (this.peekToken() != 93) {
                    this.reportError("msg.bad.prop");
                }
                this.nextToken();
                pname = new ComputedPropertyKey(pos, this.ts.tokenEnd - pos);
                pname.setLineColumnNumber(lineno, column);
                ((ComputedPropertyKey)pname).setExpression(expr);
                break;
            }
            case 23: {
                int pos = this.ts.tokenBeg;
                this.nextToken();
                int lineno = this.lineNumber();
                int column = this.columnNumber();
                pname = this.objliteralProperty();
                pname = new GeneratorMethodDefinition(pos, this.ts.tokenEnd - pos, pname);
                pname.setLineColumnNumber(lineno, column);
                break;
            }
            default: {
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective)) {
                    pname = this.createNameNode();
                    break;
                }
                return null;
            }
        }
        return pname;
    }

    private ObjectProperty plainProperty(AstNode property, int ptt) throws IOException {
        int tt = this.peekToken();
        if ((tt == 98 || tt == 95) && ptt == 44) {
            if (!this.inDestructuringAssignment) {
                // empty if block
            }
            Name nn = new Name(property.getPosition(), property.getString());
            ObjectProperty pn = new ObjectProperty();
            pn.setLeftAndRight(property, nn);
            return pn;
        }
        if (tt == 99) {
            ObjectProperty pn = new ObjectProperty();
            this.consumeToken();
            Assignment defaultValue = new Assignment(property, this.assignExpr());
            defaultValue.setType(99);
            pn.setLeftAndRight(property, defaultValue);
            return pn;
        }
        this.mustMatchToken(116, "msg.no.colon.prop", true);
        ObjectProperty pn = new ObjectProperty();
        pn.setOperatorPosition(this.ts.tokenBeg);
        pn.setLeftAndRight(property, this.assignExpr());
        return pn;
    }

    private ObjectProperty methodDefinition(int pos, AstNode propName, int entryKind, boolean isGenerator, boolean isShorthand) throws IOException {
        FunctionNode fn = this.function(2, true);
        Name name = fn.getFunctionName();
        if (name != null && name.length() != 0) {
            this.reportError("msg.bad.prop");
        }
        ObjectProperty pn = new ObjectProperty(pos);
        switch (entryKind) {
            case 2: {
                pn.setIsGetterMethod();
                fn.setFunctionIsGetterMethod();
                break;
            }
            case 4: {
                pn.setIsSetterMethod();
                fn.setFunctionIsSetterMethod();
                break;
            }
            case 8: {
                pn.setIsNormalMethod();
                fn.setFunctionIsNormalMethod();
                if (isGenerator) {
                    fn.setIsES6Generator();
                }
                if (!isShorthand) break;
                fn.setIsShorthand();
            }
        }
        int end = Parser.getNodeEnd(fn);
        pn.setLeft(propName);
        pn.setRight(fn);
        pn.setLength(end - pos);
        return pn;
    }

    private Name createNameNode() {
        return this.createNameNode(false, 44);
    }

    private Name createNameNode(boolean checkActivation, int token) {
        int beg = this.ts.tokenBeg;
        String s = this.ts.getString();
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        if (!"".equals(this.prevNameTokenString)) {
            beg = this.prevNameTokenStart;
            s = this.prevNameTokenString;
            lineno = this.prevNameTokenLineno;
            column = this.prevNameTokenColumn;
            this.prevNameTokenStart = 0;
            this.prevNameTokenString = "";
            this.prevNameTokenLineno = 0;
            this.prevNameTokenColumn = 0;
        }
        if (s == null) {
            if (this.compilerEnv.isIdeMode()) {
                s = "";
            } else {
                this.codeBug();
            }
        }
        Name name = new Name(beg, s);
        name.setLineColumnNumber(lineno, column);
        if (checkActivation) {
            this.checkActivationName(s, token);
        }
        return name;
    }

    private StringLiteral createStringLiteral() {
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        StringLiteral s = new StringLiteral(pos, end - pos);
        s.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        s.setValue(this.ts.getString());
        s.setQuoteCharacter(this.ts.getQuoteChar());
        return s;
    }

    private AstNode templateLiteral(boolean isTaggedLiteral) throws IOException {
        if (this.currentToken != 180) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        int lineno = this.lineNumber();
        int column = this.columnNumber();
        ArrayList<AstNode> elements = new ArrayList<AstNode>();
        TemplateLiteral pn = new TemplateLiteral(pos);
        int posChars = this.ts.tokenBeg + 1;
        int tt = this.ts.readTemplateLiteral(isTaggedLiteral);
        while (tt == 182) {
            elements.add(this.createTemplateLiteralCharacters(posChars));
            elements.add(this.expr(false));
            this.mustMatchToken(95, "msg.syntax", true);
            posChars = this.ts.tokenBeg + 1;
            tt = this.ts.readTemplateLiteral(isTaggedLiteral);
        }
        if (tt == -1) {
            return this.makeErrorNode();
        }
        assert (tt == 180);
        elements.add(this.createTemplateLiteralCharacters(posChars));
        end = this.ts.tokenEnd;
        pn.setElements(elements);
        pn.setLength(end - pos);
        pn.setLineColumnNumber(lineno, column);
        return pn;
    }

    private TemplateCharacters createTemplateLiteralCharacters(int pos) {
        TemplateCharacters chars = new TemplateCharacters(pos, this.ts.tokenEnd - pos - 1);
        chars.setValue(this.ts.getString());
        chars.setRawValue(this.ts.getRawString());
        return chars;
    }

    private AstNode createNumericLiteral(int tt, boolean isProperty) {
        String s = this.ts.getString();
        if (this.inUseStrictDirective && this.ts.isNumericOldOctal()) {
            if (tt == 89) {
                this.reportError("msg.no.old.octal.bigint");
            } else {
                this.reportError("msg.no.old.octal.strict");
            }
        }
        if (this.ts.isNumericBinary()) {
            s = "0b" + s;
        } else if (this.ts.isNumericOldOctal()) {
            s = "0" + s;
        } else if (this.ts.isNumericOctal()) {
            s = "0o" + s;
        } else if (this.ts.isNumericHex()) {
            s = "0x" + s;
        }
        AstNode result = tt == 89 ? new BigIntLiteral(this.ts.tokenBeg, s + "n", this.ts.getBigInt()) : new NumberLiteral(this.ts.tokenBeg, s, this.ts.getNumber());
        result.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        return result;
    }

    protected void checkActivationName(String name, int token) {
        if ("arguments".equals(name) && this.currentScriptOrFn instanceof FunctionNode) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresArgumentObject();
        }
        if (!this.insideFunctionBody()) {
            return;
        }
        boolean activation = false;
        if ("arguments".equals(name) && ((FunctionNode)this.currentScriptOrFn).getFunctionType() != 4) {
            activation = true;
        } else if (this.compilerEnv.getActivationNames() != null && this.compilerEnv.getActivationNames().contains(name)) {
            activation = true;
        } else if (!"length".equals(name) || token == 33) {
            // empty if block
        }
        if (activation) {
            this.setRequiresActivation();
        }
    }

    protected void setRequiresActivation() {
        if (this.insideFunctionBody()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresActivation();
        }
    }

    private void checkCallRequiresActivation(AstNode pn) {
        if (pn.getType() == 44 && "eval".equals(((Name)pn).getIdentifier()) || pn.getType() == 33 && "eval".equals(((PropertyGet)pn).getProperty().getIdentifier())) {
            this.setRequiresActivation();
            this.setRequiresArgumentObject();
        }
    }

    protected void setIsGenerator() {
        if (this.insideFunctionBody()) {
            ((FunctionNode)this.currentScriptOrFn).setIsGenerator();
        }
    }

    private void setRequiresArgumentObject() {
        if (this.insideFunctionBody()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresArgumentObject();
        }
    }

    private void checkBadIncDec(UpdateExpression expr) {
        AstNode op = this.removeParens(expr.getOperand());
        int tt = op.getType();
        if (tt != 44 && tt != 33 && tt != 39 && tt != 73 && tt != 43) {
            this.reportError(expr.getType() == 119 ? "msg.bad.incr" : "msg.bad.decr");
        }
    }

    private ErrorNode makeErrorNode() {
        ErrorNode pn = new ErrorNode(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        pn.setLineColumnNumber(this.lineNumber(), this.columnNumber());
        return pn;
    }

    private static int nodeEnd(AstNode node) {
        return node.getPosition() + node.getLength();
    }

    private void saveNameTokenData(int pos, String name, int lineno, int column) {
        this.prevNameTokenStart = pos;
        this.prevNameTokenString = name;
        this.prevNameTokenLineno = lineno;
        this.prevNameTokenColumn = column;
    }

    private int lineBeginningFor(int pos) {
        if (this.sourceChars == null) {
            return -1;
        }
        if (pos <= 0) {
            return 0;
        }
        char[] buf = this.sourceChars;
        if (pos >= buf.length) {
            pos = buf.length - 1;
        }
        while (--pos >= 0) {
            char c = buf[pos];
            if (!ScriptRuntime.isJSLineTerminator(c)) continue;
            return pos + 1;
        }
        return 0;
    }

    private void warnMissingSemi(int pos, int end) {
        if (this.compilerEnv.isStrictMode()) {
            int beg;
            int[] linep = new int[2];
            String line = this.ts.getLine(end, linep);
            int n = beg = this.compilerEnv.isIdeMode() ? Math.max(pos, end - linep[1]) : pos;
            if (line != null) {
                this.addStrictWarning("msg.missing.semi", "", beg, end - beg, linep[0], line, linep[1]);
            } else {
                this.addStrictWarning("msg.missing.semi", "", beg, end - beg);
            }
        }
    }

    private void warnTrailingComma(int pos, List<?> elems, int commaPos) {
        if (this.compilerEnv.getWarnTrailingComma()) {
            if (!elems.isEmpty()) {
                pos = ((AstNode)elems.get(0)).getPosition();
            }
            pos = Math.max(pos, this.lineBeginningFor(commaPos));
            this.addWarning("msg.extra.trailing.comma", pos, commaPos - pos);
        }
    }

    PerFunctionVariables createPerFunctionVariables(FunctionNode fnNode) {
        return new PerFunctionVariables(fnNode);
    }

    Node createDestructuringAssignment(int type, Node left, Node right, AstNode defaultValue, Transformer transformer) {
        String tempName = this.currentScriptOrFn.getNextTempName();
        Node result = this.destructuringAssignmentHelper(type, left, right, tempName, defaultValue, transformer);
        Node comma = result.getLastChild();
        comma.addChildToBack(this.createName(tempName));
        return result;
    }

    Node createDestructuringAssignment(int type, Node left, Node right, Transformer transformer) {
        return this.createDestructuringAssignment(type, left, right, null, transformer);
    }

    Node createDestructuringAssignment(int type, Node left, Node right, AstNode defaultValue) {
        return this.createDestructuringAssignment(type, left, right, defaultValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node destructuringAssignmentHelper(int variableType, Node left, Node right, String tempName, AstNode defaultValue, Transformer transformer) {
        Scope result = this.createScopeNode(172, left.getLineno(), left.getColumn());
        result.addChildToFront(new Node(167, this.createName(44, tempName, right)));
        try {
            this.pushScope(result);
            this.defineSymbol(167, tempName, true);
        }
        finally {
            this.popScope();
        }
        Node comma = new Node(98);
        result.addChildToBack(comma);
        ArrayList<String> destructuringNames = new ArrayList<String>();
        boolean empty = true;
        if (left instanceof ArrayLiteral) {
            empty = this.destructuringArray((ArrayLiteral)left, variableType, tempName, comma, destructuringNames, defaultValue, transformer);
        } else if (left instanceof ObjectLiteral) {
            empty = this.destructuringObject((ObjectLiteral)left, variableType, tempName, comma, destructuringNames, defaultValue, transformer);
        } else if (left.getType() == 33 || left.getType() == 39) {
            switch (variableType) {
                case 135: 
                case 167: 
                case 168: {
                    this.reportError("msg.bad.assign.left");
                }
            }
            comma.addChildToBack(this.simpleAssignment(left, this.createName(tempName), transformer));
        } else {
            this.reportError("msg.bad.assign.left");
        }
        if (empty) {
            comma.addChildToBack(this.createNumber(0.0));
        }
        result.putProp(22, destructuringNames);
        return result;
    }

    boolean destructuringArray(ArrayLiteral array, int variableType, String tempName, Node parent, List<String> destructuringNames, AstNode defaultValue, Transformer transformer) {
        boolean empty = true;
        int setOp = variableType == 168 ? 169 : 8;
        int index = 0;
        boolean defaultValuesSetup = false;
        for (AstNode n : array.getElements()) {
            if (n.getType() == 141) {
                ++index;
                continue;
            }
            Node rightElem = new Node(39, this.createName(tempName), this.createNumber(index));
            if (defaultValue != null && !defaultValuesSetup) {
                this.setupDefaultValues(tempName, parent, defaultValue, setOp, transformer);
                defaultValuesSetup = true;
            }
            if (n.getType() == 44) {
                String name = n.getString();
                parent.addChildToBack(new Node(setOp, this.createName(54, name, null), rightElem));
                if (variableType != -1) {
                    this.defineSymbol(variableType, name, true);
                    destructuringNames.add(name);
                }
            } else if (n.getType() == 99) {
                this.processDestructuringDefaults(variableType, parent, destructuringNames, (Assignment)n, rightElem, setOp, transformer);
            } else {
                parent.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.currentScriptOrFn.getNextTempName(), null, transformer));
            }
            ++index;
            empty = false;
        }
        return empty;
    }

    private void processDestructuringDefaults(int variableType, Node parent, List<String> destructuringNames, Assignment n, Node rightElem, int setOp, Transformer transformer) {
        AstNode left = n.getLeft();
        AstNode right = null;
        if (left.getType() == 44) {
            String name = left.getString();
            right = transformer != null ? transformer.transform(n.getRight()) : n.getRight();
            Node cond_inner = new Node(115, new Node(51, this.createName("undefined"), rightElem), right, rightElem);
            Node cond = new Node(115, new Node(51, this.createName("undefined"), this.createName(name)), cond_inner, left);
            if (transformer == null) {
                this.currentScriptOrFn.putDestructuringRvalues(cond_inner, right);
            }
            parent.addChildToBack(new Node(setOp, this.createName(54, name, null), cond));
            if (variableType != -1) {
                this.defineSymbol(variableType, name, true);
                destructuringNames.add(name);
            }
        }
    }

    static Object getPropKey(Node id) {
        Object key;
        if (id instanceof Name) {
            String s = ((Name)id).getIdentifier();
            key = ScriptRuntime.getIndexObject(s);
        } else if (id instanceof StringLiteral) {
            String s = ((StringLiteral)id).getValue();
            key = ScriptRuntime.getIndexObject(s);
        } else if (id instanceof NumberLiteral) {
            double n = ((NumberLiteral)id).getNumber();
            key = ScriptRuntime.getIndexObject(n);
        } else {
            key = id instanceof GeneratorMethodDefinition ? Parser.getPropKey(((GeneratorMethodDefinition)id).getMethodName()) : null;
        }
        return key;
    }

    private void setupDefaultValues(String tempName, Node parent, AstNode defaultValue, int setOp, Transformer transformer) {
        if (defaultValue != null) {
            AstNode defaultRvalue = transformer != null ? transformer.transform(defaultValue) : defaultValue;
            Node cond_default = new Node(115, new Node(51, this.createName(tempName), this.createName("undefined")), defaultRvalue, this.createName(tempName));
            if (transformer == null) {
                this.currentScriptOrFn.putDestructuringRvalues(cond_default, defaultRvalue);
            }
            Node set_default = new Node(setOp, this.createName(54, tempName, null), cond_default);
            parent.addChildToBack(set_default);
        }
    }

    boolean destructuringObject(ObjectLiteral node, int variableType, String tempName, Node parent, List<String> destructuringNames, AstNode defaultValue, Transformer transformer) {
        boolean empty = true;
        int setOp = variableType == 168 ? 169 : 8;
        boolean defaultValuesSetup = false;
        for (ObjectProperty prop : node.getElements()) {
            AstNode value;
            Node s;
            int lineno = 0;
            int column = 0;
            if (this.ts != null) {
                lineno = this.lineNumber();
                column = this.columnNumber();
            }
            AstNode id = prop.getLeft();
            Node rightElem = null;
            if (id instanceof Name) {
                s = Node.newString(((Name)id).getIdentifier());
                rightElem = new Node(33, this.createName(tempName), s);
            } else if (id instanceof StringLiteral) {
                s = Node.newString(((StringLiteral)id).getValue());
                rightElem = new Node(33, this.createName(tempName), s);
            } else if (id instanceof NumberLiteral) {
                s = this.createNumber((int)((NumberLiteral)id).getNumber());
                rightElem = new Node(39, this.createName(tempName), s);
            } else {
                if (id instanceof ComputedPropertyKey) {
                    this.reportError("msg.bad.computed.property.in.destruct");
                    return false;
                }
                throw this.codeBug();
            }
            rightElem.setLineColumnNumber(lineno, column);
            if (defaultValue != null && !defaultValuesSetup) {
                this.setupDefaultValues(tempName, parent, defaultValue, setOp, transformer);
                defaultValuesSetup = true;
            }
            if ((value = prop.getRight()).getType() == 44) {
                String name = ((Name)value).getIdentifier();
                parent.addChildToBack(new Node(setOp, this.createName(54, name, null), rightElem));
                if (variableType != -1) {
                    this.defineSymbol(variableType, name, true);
                    destructuringNames.add(name);
                }
            } else if (value.getType() == 99) {
                this.processDestructuringDefaults(variableType, parent, destructuringNames, (Assignment)value, rightElem, setOp, transformer);
            } else {
                parent.addChildToBack(this.destructuringAssignmentHelper(variableType, value, rightElem, this.currentScriptOrFn.getNextTempName(), null, transformer));
            }
            empty = false;
        }
        return empty;
    }

    protected Node createName(String name) {
        this.checkActivationName(name, 44);
        return Node.newString(44, name);
    }

    protected Node createName(int type, String name, Node child) {
        Node result = this.createName(name);
        result.setType(type);
        if (child != null) {
            result.addChildToBack(child);
        }
        return result;
    }

    protected Node createNumber(double number) {
        return Node.newNumber(number);
    }

    protected Scope createScopeNode(int token, int lineno, int column) {
        Scope scope = new Scope();
        scope.setType(token);
        scope.setLineColumnNumber(lineno, column);
        return scope;
    }

    protected Node simpleAssignment(Node left, Node right) {
        return this.simpleAssignment(left, right, null);
    }

    protected Node simpleAssignment(Node left, Node right, Transformer transformer) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 44: {
                String name = ((Name)left).getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(name) || "arguments".equals(name))) {
                    this.reportError("msg.bad.id.strict", name);
                }
                left.setType(54);
                return new Node(8, left, right);
            }
            case 33: 
            case 39: {
                int type;
                Node id;
                Node obj;
                AstNode target;
                if (left instanceof PropertyGet) {
                    target = ((PropertyGet)left).getTarget();
                    obj = transformer != null ? transformer.transform(target) : target;
                    id = ((PropertyGet)left).getProperty();
                } else if (left instanceof ElementGet) {
                    target = ((ElementGet)left).getTarget();
                    AstNode elem = ((ElementGet)left).getElement();
                    obj = transformer != null ? transformer.transform(target) : target;
                    id = transformer != null ? transformer.transform(elem) : elem;
                } else {
                    obj = left.getFirstChild();
                    id = left.getLastChild();
                }
                if (nodeType == 33) {
                    type = 37;
                    id.setType(46);
                } else {
                    type = 41;
                }
                return new Node(type, obj, id, right);
            }
            case 73: {
                Node ref = left.getFirstChild();
                this.checkMutableReference(ref);
                return new Node(74, ref, right);
            }
        }
        throw this.codeBug();
    }

    protected void checkMutableReference(Node n) {
        int memberTypeFlags = n.getIntProp(16, 0);
        if ((memberTypeFlags & 4) != 0) {
            this.reportError("msg.bad.assign.left");
        }
    }

    protected AstNode removeParens(AstNode node) {
        while (node instanceof ParenthesizedExpression) {
            node = ((ParenthesizedExpression)node).getExpression();
        }
        return node;
    }

    void markDestructuring(AstNode node) {
        if (node instanceof DestructuringForm) {
            ((DestructuringForm)((Object)node)).setIsDestructuring(true);
        } else if (node instanceof ParenthesizedExpression) {
            this.markDestructuring(((ParenthesizedExpression)node).getExpression());
        }
    }

    private RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug("ts.cursor=" + this.ts.cursor + ", ts.tokenBeg=" + this.ts.tokenBeg + ", currentToken=" + this.currentToken);
    }

    public void setDefaultUseStrictDirective(boolean useStrict) {
        this.defaultUseStrictDirective = useStrict;
    }

    public boolean inUseStrictDirective() {
        return this.inUseStrictDirective;
    }

    public void reportErrorsIfExists(int baseLineno) {
        if (this.syntaxErrorCount != 0) {
            String msg = String.valueOf(this.syntaxErrorCount);
            msg = this.lookupMessage("msg.got.syntax.errors", msg);
            if (!this.compilerEnv.isIdeMode()) {
                throw this.errorReporter.runtimeError(msg, this.sourceURI, baseLineno, null, 0);
            }
        }
    }

    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    public static interface CurrentPositionReporter {
        public int getPosition();

        public int getLength();

        public int getLineno();

        public String getLine();

        public int getOffset();
    }

    protected class PerFunctionVariables {
        private ScriptNode savedCurrentScriptOrFn;
        private Scope savedCurrentScope;
        private int savedEndFlags;
        private boolean savedInForInit;
        private Map<String, LabeledStatement> savedLabelSet;
        private List<Loop> savedLoopSet;
        private List<Jump> savedLoopAndSwitchSet;

        PerFunctionVariables(FunctionNode fnNode) {
            this.savedCurrentScriptOrFn = Parser.this.currentScriptOrFn;
            Parser.this.currentScriptOrFn = fnNode;
            this.savedCurrentScope = Parser.this.currentScope;
            Parser.this.currentScope = fnNode;
            this.savedLabelSet = Parser.this.labelSet;
            Parser.this.labelSet = null;
            this.savedLoopSet = Parser.this.loopSet;
            Parser.this.loopSet = null;
            this.savedLoopAndSwitchSet = Parser.this.loopAndSwitchSet;
            Parser.this.loopAndSwitchSet = null;
            this.savedEndFlags = Parser.this.endFlags;
            Parser.this.endFlags = 0;
            this.savedInForInit = Parser.this.inForInit;
            Parser.this.inForInit = false;
        }

        void restore() {
            Parser.this.currentScriptOrFn = this.savedCurrentScriptOrFn;
            Parser.this.currentScope = this.savedCurrentScope;
            Parser.this.labelSet = this.savedLabelSet;
            Parser.this.loopSet = this.savedLoopSet;
            Parser.this.loopAndSwitchSet = this.savedLoopAndSwitchSet;
            Parser.this.endFlags = this.savedEndFlags;
            Parser.this.inForInit = this.savedInForInit;
        }
    }

    private static class ConditionData {
        AstNode condition;
        int lp = -1;
        int rp = -1;

        private ConditionData() {
        }
    }

    static interface Transformer {
        public Node transform(AstNode var1);
    }

    public static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 5882582646773765630L;
    }
}

