/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.SerializableConstructable;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;

public class LambdaConstructor
extends LambdaFunction {
    private static final long serialVersionUID = 2691205302914111400L;
    public static final int CONSTRUCTOR_FUNCTION = 1;
    public static final int CONSTRUCTOR_NEW = 2;
    public static final int CONSTRUCTOR_DEFAULT = 3;
    protected final SerializableConstructable targetConstructor;
    private final int flags;

    public LambdaConstructor(Scriptable scope, String name, int length, SerializableConstructable target) {
        super(scope, name, length, null);
        this.targetConstructor = target;
        this.flags = 3;
    }

    public LambdaConstructor(Scriptable scope, String name, int length, int flags, SerializableConstructable target) {
        super(scope, name, length, null);
        this.targetConstructor = target;
        this.flags = flags;
    }

    public LambdaConstructor(Scriptable scope, String name, int length, SerializableCallable target, SerializableConstructable targetConstructor) {
        super(scope, name, length, target);
        this.targetConstructor = targetConstructor;
        this.flags = 3;
    }

    protected Constructable getTargetConstructor() {
        return this.targetConstructor;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if ((this.flags & 1) == 0) {
            throw ScriptRuntime.typeErrorById("msg.constructor.no.function", this.getFunctionName());
        }
        if (this.target == null) {
            return this.fireConstructor(cx, scope, args);
        }
        return this.target.call(cx, scope, thisObj, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if ((this.flags & 2) == 0) {
            throw ScriptRuntime.typeErrorById("msg.no.new", this.getFunctionName());
        }
        return this.fireConstructor(cx, scope, args);
    }

    private Scriptable fireConstructor(Context cx, Scriptable scope, Object[] args) {
        Scriptable obj = this.targetConstructor.construct(cx, scope, args);
        obj.setPrototype(this.getClassPrototype());
        obj.setParentScope(scope);
        return obj;
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, SerializableCallable target) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, 0);
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        this.definePrototypeMethod(scope, name, length, target, attributes, propertyAttributes, true);
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes, boolean defaultPrototype) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, defaultPrototype);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeMethod(Scriptable scope, SymbolKey name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, "[" + name.getName() + "]", length, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeProperty(String name, Object value, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, value, attributes);
    }

    public void definePrototypeProperty(Symbol key, Object value, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(key, value, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject descriptor) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineOwnProperty(cx, name, descriptor);
    }

    public void definePrototypeProperty(Context cx, Symbol key, ScriptableObject descriptor) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineOwnProperty(cx, key, descriptor);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, name, getter, null, attributes);
    }

    public void definePrototypeProperty(Context cx, Symbol key, ScriptableObject.LambdaGetterFunction getter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, key, getter, null, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, name, getter, setter, attributes);
    }

    public void definePrototypeAlias(String name, SymbolKey alias, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        Object val = proto.get(name, (Scriptable)proto);
        proto.defineProperty(alias, val, attributes);
    }

    public void definePrototypeAlias(String name, String alias, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        Object val = proto.get(name, (Scriptable)proto);
        proto.defineProperty(alias, val, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, Symbol key, String name, int length, SerializableCallable target, int attributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target);
        this.defineProperty(key, (Object)f, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void setPrototypeScriptable(ScriptableObject proto) {
        proto.setParentScope(this.getParentScope());
        this.setPrototypeProperty(proto);
        Scriptable objectProto = LambdaConstructor.getObjectPrototype(this);
        if (proto != objectProto) {
            proto.setPrototype(objectProto);
        }
        proto.defineProperty("constructor", (Object)this, 2);
    }

    public static <T> T convertThisObject(Scriptable thisObj, Class<T> targetClass) {
        if (!targetClass.isInstance(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.this.not.instance", new Object[0]);
        }
        return (T)thisObj;
    }

    private ScriptableObject getPrototypeScriptable() {
        Object prop = this.getPrototypeProperty();
        if (!(prop instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError("Not properly a lambda constructor");
        }
        return (ScriptableObject)prop;
    }
}

