/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file.service;

import java.io.File;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.hswebframework.web.file.FileUploadProperties;
import org.hswebframework.web.file.service.FileStorageService;
import org.springframework.http.codec.multipart.FilePart;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LocalFileStorageService
implements FileStorageService {
    private final FileUploadProperties properties;
    private static final OpenOption[] FILE_CHANNEL_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};

    @Override
    public Mono<String> saveFile(FilePart filePart) {
        FileUploadProperties.StaticFileInfo info = this.properties.createStaticSavePath(filePart.filename());
        return this.createStaticFileInfo(filePart.filename()).flatMap(into -> {
            File file = new File(info.getSavePath());
            return filePart.transferTo(file).then(Mono.fromRunnable(() -> this.properties.applyFilePermission(file))).thenReturn((Object)info.getLocation());
        });
    }

    protected Mono<FileUploadProperties.StaticFileInfo> createStaticFileInfo(String fileName) {
        return Mono.just((Object)this.properties.createStaticSavePath(fileName));
    }

    @Override
    public Mono<String> saveFile(InputStream inputStream, String fileType) {
        String fileName = "_temp" + (String)(fileType.startsWith(".") ? fileType : "." + fileType);
        return this.createStaticFileInfo(fileName).flatMap(info -> Mono.fromCallable(() -> {
            try (ReadableByteChannel input = Channels.newChannel(inputStream);){
                String string;
                block13: {
                    FileChannel output = FileChannel.open(Paths.get(info.getSavePath(), new String[0]), FILE_CHANNEL_OPTIONS);
                    try {
                        long written;
                        long size = input instanceof FileChannel ? ((FileChannel)input).size() : Long.MAX_VALUE;
                        for (long totalWritten = 0L; totalWritten < size && (written = output.transferFrom(input, totalWritten, size - totalWritten)) > 0L; totalWritten += written) {
                        }
                        string = info.getLocation();
                        if (output == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    output.close();
                }
                return string;
            }
        }).doOnSuccess(ignore -> this.properties.applyFilePermission(new File(info.getSavePath()))).subscribeOn(Schedulers.boundedElastic()));
    }

    @Generated
    public LocalFileStorageService(FileUploadProperties properties) {
        this.properties = properties;
    }
}

