/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.api.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.MultipleI18nSupportEntity;
import org.hswebframework.web.system.authorization.api.entity.ActionEntity;
import org.hswebframework.web.system.authorization.api.entity.OptionalField;
import org.hswebframework.web.system.authorization.api.entity.ParentPermission;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.util.CollectionUtils;

@Table(name="s_permission")
@Comment(value="\u6743\u9650\u4fe1\u606f")
public class PermissionEntity
extends GenericEntity<String>
implements RecordCreationEntity,
RecordModifierEntity,
MultipleI18nSupportEntity {
    @Column
    @Comment(value="\u6743\u9650\u540d\u79f0")
    @Schema(description="\u6743\u9650\u540d\u79f0")
    @NotBlank(message="\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    private @NotBlank(message="\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String name;
    @Column
    @Comment(value="\u8bf4\u660e")
    @Schema(description="\u8bf4\u660e")
    private String describe;
    @Column(nullable=false)
    @Comment(value="\u72b6\u6001")
    @Schema(description="\u72b6\u6001")
    @DefaultValue(value="1")
    private Byte status;
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @JsonCodec
    @Comment(value="\u53ef\u9009\u64cd\u4f5c")
    @Schema(description="\u53ef\u9009\u64cd\u4f5c")
    private List<ActionEntity> actions;
    @Column(name="optional_fields")
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @JsonCodec
    @Comment(value="\u53ef\u64cd\u4f5c\u7684\u5b57\u6bb5")
    @Schema(description="\u53ef\u64cd\u4f5c\u5b57\u6bb5")
    private List<OptionalField> optionalFields;
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @JsonCodec
    @Comment(value="\u5173\u8054\u6743\u9650")
    @Schema(description="\u5173\u8054\u6743\u9650")
    private List<ParentPermission> parents;
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @JsonCodec
    @Comment(value="\u5176\u4ed6\u914d\u7f6e")
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    private Map<String, Object> properties;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Schema(description="\u521b\u5efa\u4ebaID")
    @Column(length=64, updatable=false)
    private String creatorId;
    @Schema(description="\u4fee\u6539\u65f6\u95f4")
    @Column
    @DefaultValue(generator="current_time")
    private Long modifyTime;
    @Schema(description="\u4fee\u6539\u4ebaID")
    @Column(length=64, updatable=false)
    private String modifierId;
    @Schema(title="\u56fd\u9645\u5316\u4fe1\u606f\u5b9a\u4e49")
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private Map<String, Map<String, String>> i18nMessages;

    @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class})
    public @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class}) String getId() {
        return (String)super.getId();
    }

    public String getI18nName() {
        return this.getI18nMessage("name", this.name);
    }

    public String getI18nDescribe() {
        return this.getI18nMessage("describe", this.describe);
    }

    public PermissionEntity copy(Predicate<ActionEntity> actionFilter, Predicate<OptionalField> fieldFilter) {
        PermissionEntity entity = (PermissionEntity)((Object)FastBeanCopier.copy((Object)((Object)this), (Object)((Object)new PermissionEntity()), (String[])new String[0]));
        if (!CollectionUtils.isEmpty(entity.getActions())) {
            entity.setActions(entity.getActions().stream().filter(actionFilter).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(entity.getOptionalFields())) {
            entity.setOptionalFields(entity.getOptionalFields().stream().filter(fieldFilter).collect(Collectors.toList()));
        }
        return entity;
    }

    @Generated
    public static PermissionEntityBuilder builder() {
        return new PermissionEntityBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescribe() {
        return this.describe;
    }

    @Generated
    public Byte getStatus() {
        return this.status;
    }

    @Generated
    public List<ActionEntity> getActions() {
        return this.actions;
    }

    @Generated
    public List<OptionalField> getOptionalFields() {
        return this.optionalFields;
    }

    @Generated
    public List<ParentPermission> getParents() {
        return this.parents;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getCreatorId() {
        return this.creatorId;
    }

    @Generated
    public Long getModifyTime() {
        return this.modifyTime;
    }

    @Generated
    public String getModifierId() {
        return this.modifierId;
    }

    @Generated
    public Map<String, Map<String, String>> getI18nMessages() {
        return this.i18nMessages;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescribe(String describe) {
        this.describe = describe;
    }

    @Generated
    public void setStatus(Byte status) {
        this.status = status;
    }

    @Generated
    public void setActions(List<ActionEntity> actions) {
        this.actions = actions;
    }

    @Generated
    public void setOptionalFields(List<OptionalField> optionalFields) {
        this.optionalFields = optionalFields;
    }

    @Generated
    public void setParents(List<ParentPermission> parents) {
        this.parents = parents;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Generated
    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    @Generated
    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Generated
    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    @Generated
    public void setI18nMessages(Map<String, Map<String, String>> i18nMessages) {
        this.i18nMessages = i18nMessages;
    }

    @Generated
    public PermissionEntity() {
    }

    @Generated
    public PermissionEntity(String name, String describe, Byte status, List<ActionEntity> actions, List<OptionalField> optionalFields, List<ParentPermission> parents, Map<String, Object> properties, Long createTime, String creatorId, Long modifyTime, String modifierId, Map<String, Map<String, String>> i18nMessages) {
        this.name = name;
        this.describe = describe;
        this.status = status;
        this.actions = actions;
        this.optionalFields = optionalFields;
        this.parents = parents;
        this.properties = properties;
        this.createTime = createTime;
        this.creatorId = creatorId;
        this.modifyTime = modifyTime;
        this.modifierId = modifierId;
        this.i18nMessages = i18nMessages;
    }

    @Generated
    public static class PermissionEntityBuilder {
        @Generated
        private String name;
        @Generated
        private String describe;
        @Generated
        private Byte status;
        @Generated
        private List<ActionEntity> actions;
        @Generated
        private List<OptionalField> optionalFields;
        @Generated
        private List<ParentPermission> parents;
        @Generated
        private Map<String, Object> properties;
        @Generated
        private Long createTime;
        @Generated
        private String creatorId;
        @Generated
        private Long modifyTime;
        @Generated
        private String modifierId;
        @Generated
        private Map<String, Map<String, String>> i18nMessages;

        @Generated
        PermissionEntityBuilder() {
        }

        @Generated
        public PermissionEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PermissionEntityBuilder describe(String describe) {
            this.describe = describe;
            return this;
        }

        @Generated
        public PermissionEntityBuilder status(Byte status) {
            this.status = status;
            return this;
        }

        @Generated
        public PermissionEntityBuilder actions(List<ActionEntity> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public PermissionEntityBuilder optionalFields(List<OptionalField> optionalFields) {
            this.optionalFields = optionalFields;
            return this;
        }

        @Generated
        public PermissionEntityBuilder parents(List<ParentPermission> parents) {
            this.parents = parents;
            return this;
        }

        @Generated
        public PermissionEntityBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public PermissionEntityBuilder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public PermissionEntityBuilder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        @Generated
        public PermissionEntityBuilder modifyTime(Long modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        @Generated
        public PermissionEntityBuilder modifierId(String modifierId) {
            this.modifierId = modifierId;
            return this;
        }

        @Generated
        public PermissionEntityBuilder i18nMessages(Map<String, Map<String, String>> i18nMessages) {
            this.i18nMessages = i18nMessages;
            return this;
        }

        @Generated
        public PermissionEntity build() {
            return new PermissionEntity(this.name, this.describe, this.status, this.actions, this.optionalFields, this.parents, this.properties, this.createTime, this.creatorId, this.modifyTime, this.modifierId, this.i18nMessages);
        }

        @Generated
        public String toString() {
            return "PermissionEntity.PermissionEntityBuilder(name=" + this.name + ", describe=" + this.describe + ", status=" + this.status + ", actions=" + this.actions + ", optionalFields=" + this.optionalFields + ", parents=" + this.parents + ", properties=" + this.properties + ", createTime=" + this.createTime + ", creatorId=" + this.creatorId + ", modifyTime=" + this.modifyTime + ", modifierId=" + this.modifierId + ", i18nMessages=" + this.i18nMessages + ")";
        }
    }
}

