/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.api.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.sql.JDBCType;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.system.authorization.api.enums.DimensionUserFeature;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;

@Table(name="s_dimension_user", indexes={@Index(name="idx_dimsu_dimension_id", columnList="dimension_id"), @Index(name="idx_dimsu_dimension_type_id", columnList="dimension_type_id"), @Index(name="idx_dimsu_user_id", columnList="user_id")})
@Comment(value="\u7528\u6237\u7ef4\u5ea6\u5173\u8054\u8868")
@EnableEntityEvent
public class DimensionUserEntity
extends GenericEntity<String> {
    @Comment(value="\u7ef4\u5ea6\u7c7b\u578bID")
    @Column(name="dimension_type_id", nullable=false, length=32)
    @Schema(description="\u7ef4\u5ea6\u7c7b\u578bID,\u5982: org,tenant")
    private String dimensionTypeId;
    @Comment(value="\u7ef4\u5ea6ID")
    @Column(name="dimension_id", nullable=false, length=64)
    @Schema(description="\u7ef4\u5ea6ID")
    private String dimensionId;
    @Comment(value="\u7ef4\u5ea6\u540d\u79f0")
    @Column(name="dimension_name", nullable=false)
    @NotBlank
    @Schema(description="\u7ef4\u5ea6\u540d\u79f0")
    private String dimensionName;
    @Comment(value="\u7528\u6237ID")
    @Column(name="user_id", nullable=false, length=64)
    @Schema(description="\u7528\u6237ID")
    @NotBlank
    private String userId;
    @Comment(value="\u7528\u6237\u540d")
    @Column(name="user_name", nullable=false)
    @Schema(description="\u7528\u6237\u540d")
    private String userName;
    @Comment(value="\u5173\u7cfb")
    @Column(length=32)
    @Schema(description="\u7ef4\u5ea6\u5173\u7cfb")
    private String relation;
    @Column(name="relation_name")
    @Comment(value="\u5173\u7cfb\u540d\u79f0")
    @Schema(description="\u7ef4\u5ea6\u5173\u7cfb\u540d\u79f0")
    private String relationName;
    @Column(name="features")
    @ColumnType(jdbcType=JDBCType.NUMERIC, javaType=Long.class)
    @EnumCodec(toMask=true)
    @Schema(description="\u5176\u4ed6\u529f\u80fd")
    private DimensionUserFeature[] features;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u5173\u8054\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    private Long relationTime;

    public void generateId() {
        if (ObjectUtils.isEmpty((Object)this.getId())) {
            String id = DigestUtils.md5DigestAsHex((byte[])String.format("%s-%s-%s", this.dimensionTypeId, this.dimensionId, this.userId).getBytes());
            this.setId(id);
        }
    }

    public boolean hasFeature(DimensionUserFeature feature) {
        return this.features != null && EnumDict.in((Enum)feature, (Enum[])this.features);
    }

    @Generated
    public String getDimensionTypeId() {
        return this.dimensionTypeId;
    }

    @Generated
    public String getDimensionId() {
        return this.dimensionId;
    }

    @Generated
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getRelation() {
        return this.relation;
    }

    @Generated
    public String getRelationName() {
        return this.relationName;
    }

    @Generated
    public DimensionUserFeature[] getFeatures() {
        return this.features;
    }

    @Generated
    public Long getRelationTime() {
        return this.relationTime;
    }

    @Generated
    public void setDimensionTypeId(String dimensionTypeId) {
        this.dimensionTypeId = dimensionTypeId;
    }

    @Generated
    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    @Generated
    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setRelation(String relation) {
        this.relation = relation;
    }

    @Generated
    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    @Generated
    public void setFeatures(DimensionUserFeature[] features) {
        this.features = features;
    }

    @Generated
    public void setRelationTime(Long relationTime) {
        this.relationTime = relationTime;
    }
}

