/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.api.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.sql.JDBCType;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.system.authorization.api.entity.DataAccessEntity;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.util.CollectionUtils;

@Table(name="s_autz_setting_info", indexes={@Index(name="idx_sasi_dss", columnList="dimension_type,dimension_target,state desc"), @Index(name="idx_sasi_pdd", columnList="permission,dimension_type,dimension_target", unique=true)})
@Comment(value="\u6388\u6743\u4fe1\u606f")
@EnableEntityEvent
public class AuthorizationSettingEntity
implements Entity {
    @Id
    @Column(length=32)
    @GeneratedValue(generator="md5")
    @Schema(description="ID")
    private String id;
    @Column(length=32, nullable=false, updatable=false)
    @Comment(value="\u6743\u9650ID")
    @NotBlank(message="\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u6743\u9650ID")
    private @NotBlank(message="\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String permission;
    @Column(name="dimension_type", length=32, nullable=false, updatable=false)
    @Comment(value="\u7ef4\u5ea6\u7c7b\u578b")
    @NotBlank(message="\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u7ef4\u5ea6\u7c7b\u578b,\u5982: user,role")
    private @NotBlank(message="\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String dimensionType;
    @Column(name="dimension_type_name", length=64)
    @Comment(value="\u7ef4\u5ea6\u7c7b\u578b\u540d\u79f0")
    @Schema(description="\u7ef4\u5ea6\u7c7b\u578b\u540d\u79f0,\u5982: \u7528\u6237,\u89d2\u8272")
    private String dimensionTypeName;
    @Column(name="dimension_target", length=32, updatable=false)
    @Comment(value="\u7ef4\u5ea6\u76ee\u6807")
    @NotBlank(message="\u7ef4\u5ea6\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u7ef4\u5ea6\u76ee\u6807,\u5982: \u7528\u6237\u7684ID,\u89d2\u8272\u7684ID")
    private @NotBlank(message="\u7ef4\u5ea6\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String dimensionTarget;
    @Column(name="dimension_target_name", length=64)
    @Comment(value="\u7ef4\u5ea6\u76ee\u6807\u540d\u79f0")
    @Schema(description="\u7ef4\u5ea6\u7c7b\u578b,\u5982: \u7528\u6237\u540d,\u89d2\u8272\u540d")
    private String dimensionTargetName;
    @Column(name="state", nullable=false)
    @Comment(value="\u72b6\u6001")
    @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u72b6\u6001,0\u7981\u7528,1\u542f\u7528")
    @DefaultValue(value="1")
    private @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) Byte state;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB)
    @JsonCodec
    @Comment(value="\u53ef\u64cd\u4f5c\u6743\u9650")
    @Schema(description="\u6388\u6743\u53ef\u5bf9\u6b64\u6743\u9650\u8fdb\u884c\u7684\u64cd\u4f5c")
    private Set<String> actions;
    @Column(name="data_accesses")
    @ColumnType(jdbcType=JDBCType.CLOB)
    @JsonCodec
    @Comment(value="\u6570\u636e\u6743\u9650")
    @Schema(description="\u6570\u636e\u6743\u9650\u914d\u7f6e")
    private List<DataAccessEntity> dataAccesses;
    @Column
    @Comment(value="\u4f18\u5148\u7ea7")
    @Schema(description="\u51b2\u7a81\u65f6,\u5408\u5e76\u4f18\u5148\u7ea7")
    private Integer priority;
    @Column
    @Comment(value="\u662f\u5426\u5408\u5e76")
    @Schema(description="\u51b2\u7a81\u65f6,\u662f\u5426\u5408\u5e76")
    private Boolean merge;

    public AuthorizationSettingEntity copy(Predicate<String> actionFilter, Predicate<DataAccessEntity> dataAccessFilter) {
        AuthorizationSettingEntity newSetting = (AuthorizationSettingEntity)FastBeanCopier.copy((Object)this, (Object)new AuthorizationSettingEntity(), (String[])new String[0]);
        if (!CollectionUtils.isEmpty(newSetting.getActions())) {
            newSetting.setActions(newSetting.getActions().stream().filter(actionFilter).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(newSetting.getDataAccesses())) {
            newSetting.setDataAccesses(newSetting.getDataAccesses().stream().filter(dataAccessFilter).collect(Collectors.toList()));
        }
        return newSetting;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public String getDimensionType() {
        return this.dimensionType;
    }

    @Generated
    public String getDimensionTypeName() {
        return this.dimensionTypeName;
    }

    @Generated
    public String getDimensionTarget() {
        return this.dimensionTarget;
    }

    @Generated
    public String getDimensionTargetName() {
        return this.dimensionTargetName;
    }

    @Generated
    public Byte getState() {
        return this.state;
    }

    @Generated
    public Set<String> getActions() {
        return this.actions;
    }

    @Generated
    public List<DataAccessEntity> getDataAccesses() {
        return this.dataAccesses;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getMerge() {
        return this.merge;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setDimensionType(String dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Generated
    public void setDimensionTypeName(String dimensionTypeName) {
        this.dimensionTypeName = dimensionTypeName;
    }

    @Generated
    public void setDimensionTarget(String dimensionTarget) {
        this.dimensionTarget = dimensionTarget;
    }

    @Generated
    public void setDimensionTargetName(String dimensionTargetName) {
        this.dimensionTargetName = dimensionTargetName;
    }

    @Generated
    public void setState(Byte state) {
        this.state = state;
    }

    @Generated
    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    @Generated
    public void setDataAccesses(List<DataAccessEntity> dataAccesses) {
        this.dataAccesses = dataAccesses;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setMerge(Boolean merge) {
        this.merge = merge;
    }
}

