/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.starter.jackson.CustomDeserializers;
import org.hswebframework.web.starter.jackson.CustomJackson2JsonDecoder;
import org.hswebframework.web.starter.jackson.CustomJackson2jsonEncoder;
import org.hswebframework.web.starter.jackson.CustomMappingJackson2HttpMessageConverter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.MimeType;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
public class CustomCodecsAutoConfiguration {

    @AutoConfiguration
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonDecoderConfiguration {
        JacksonDecoderConfiguration() {
        }

        @Bean
        SimpleModule springWebModule() {
            SimpleModule module = new SimpleModule();
            module.addSerializer(HttpMethod.class, (JsonSerializer)new JsonSerializer<HttpMethod>(){

                public void serialize(HttpMethod httpMethod, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeString(httpMethod.name());
                }
            });
            module.addDeserializer(HttpMethod.class, (JsonDeserializer)new JsonDeserializer<HttpMethod>(){

                public HttpMethod deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    return HttpMethod.valueOf((String)jsonParser.getValueAsString());
                }
            });
            module.addSerializer(HttpStatus.class, (JsonSerializer)new JsonSerializer<HttpStatus>(){

                public void serialize(HttpStatus httpStatus, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeNumber(httpStatus.value());
                }
            });
            module.addDeserializer(HttpStatus.class, (JsonDeserializer)new JsonDeserializer<HttpStatus>(){

                public HttpStatus deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    return HttpStatus.valueOf((int)jsonParser.getValueAsInt());
                }
            });
            return module;
        }

        @Bean
        SimpleModule entityAndEnumDictModule(EntityFactory entityFactory) {
            SimpleModule module = new SimpleModule();
            module.setDeserializers((SimpleDeserializers)new CustomDeserializers(entityFactory));
            return module;
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jacksonDecoderCustomizer(EntityFactory entityFactory, ObjectMapper objectMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jackson2JsonDecoder((Decoder)new CustomJackson2JsonDecoder(entityFactory, objectMapper, new MimeType[0]));
                defaults.jackson2JsonEncoder((Encoder)new CustomJackson2jsonEncoder(objectMapper, new MimeType[0]));
            };
        }

        @Bean
        CustomMappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(EntityFactory entityFactory, ObjectMapper objectMapper) {
            return new CustomMappingJackson2HttpMessageConverter(objectMapper, entityFactory);
        }
    }
}

