/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenParser;
import org.hswebframework.web.authorization.events.AuthorizationSuccessEvent;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.logger.ReactiveLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Order(value=1)
public class UserTokenWebFilter
implements WebFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserTokenWebFilter.class);
    private final List<ReactiveUserTokenParser> parsers = new ArrayList<ReactiveUserTokenParser>();
    private final Map<String, ReactiveUserTokenGenerator> tokenGeneratorMap = new HashMap<String, ReactiveUserTokenGenerator>();
    private final UserTokenManager userTokenManager;

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, WebFilterChain chain) {
        return Flux.fromIterable(this.parsers).flatMap(parser -> parser.parseToken(exchange)).next().map(token -> chain.filter(exchange).contextWrite((ContextView)Context.of(ParsedToken.class, (Object)token))).defaultIfEmpty((Object)chain.filter(exchange)).flatMap(Function.identity()).contextWrite(ReactiveLogger.start((String)"requestId", (String)exchange.getRequest().getId()));
    }

    @EventListener
    public void handleUserSign(AuthorizationSuccessEvent event) {
        ReactiveUserTokenGenerator generator = event.getParameter("tokenType").map(this.tokenGeneratorMap::get).orElseGet(() -> this.tokenGeneratorMap.get("default"));
        if (generator != null) {
            GeneratedToken token = generator.generate(event.getAuthentication());
            event.getResult().putAll(token.getResponse());
            if (StringUtils.hasText((String)token.getToken())) {
                event.getResult().put("token", token.getToken());
                long expires = event.getParameter("expires").map(String::valueOf).map(Long::parseLong).orElse(token.getTimeout());
                event.async((Publisher)this.userTokenManager.signIn(token.getToken(), token.getType(), event.getAuthentication().getUser().getId(), expires).doOnNext(t -> {
                    event.getResult().put("expires", t.getMaxInactiveInterval());
                    log.debug("user [{}] sign in", (Object)t.getUserId());
                }).then());
            }
        }
    }

    public void register(ReactiveUserTokenGenerator generator) {
        this.tokenGeneratorMap.put(generator.getTokenType(), generator);
    }

    public void register(ReactiveUserTokenParser parser) {
        this.parsers.add(parser);
    }

    @Generated
    public UserTokenWebFilter(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }
}

