/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.embed;

import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationProperties;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Mono;

@Order(value=10)
public class EmbedReactiveAuthenticationManager
implements ReactiveAuthenticationManagerProvider {
    private final EmbedAuthenticationProperties properties;

    public Mono<Authentication> authenticate(Mono<AuthenticationRequest> request) {
        if (MapUtils.isEmpty(this.properties.getUsers())) {
            return Mono.empty();
        }
        return request.handle((req, sink) -> {
            Authentication auth = this.properties.authenticate((AuthenticationRequest)req);
            if (auth != null) {
                sink.next((Object)auth);
            }
        });
    }

    public Mono<Authentication> getByUserId(String userId) {
        return Mono.justOrEmpty(this.properties.getAuthentication(userId));
    }

    @Generated
    public EmbedReactiveAuthenticationManager(EmbedAuthenticationProperties properties) {
        this.properties = properties;
    }
}

