/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.configuration;

import java.util.List;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.web.ServletUserTokenGenPar;
import org.hswebframework.web.authorization.basic.web.SessionIdUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.SessionIdUserTokenParser;
import org.hswebframework.web.authorization.basic.web.UserOnSignIn;
import org.hswebframework.web.authorization.basic.web.UserOnSignOut;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.basic.web.WebUserTokenInterceptor;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnClass(name={"org.springframework.web.servlet.config.annotation.WebMvcConfigurer"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebMvcAuthorizingConfiguration {
    @Bean
    @Order(value=-2147483648)
    @ConditionalOnBean(value={AopMethodAuthorizeDefinitionParser.class})
    public WebMvcConfigurer webUserTokenInterceptorConfigurer(final UserTokenManager userTokenManager, final AopMethodAuthorizeDefinitionParser parser, final List<UserTokenParser> userTokenParser) {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new WebUserTokenInterceptor(userTokenManager, userTokenParser, parser));
            }
        };
    }

    @Bean
    public UserOnSignIn userOnSignIn(UserTokenManager userTokenManager) {
        return new UserOnSignIn(userTokenManager);
    }

    @Bean
    public UserOnSignOut userOnSignOut(UserTokenManager userTokenManager) {
        return new UserOnSignOut(userTokenManager);
    }

    @ConfigurationProperties(prefix="hsweb.authorize.token.default")
    public ServletUserTokenGenPar servletUserTokenGenPar() {
        return new ServletUserTokenGenPar();
    }

    @Bean
    @ConditionalOnMissingBean(value={UserTokenParser.class})
    public UserTokenParser userTokenParser() {
        return new SessionIdUserTokenParser();
    }

    @Bean
    public SessionIdUserTokenGenerator sessionIdUserTokenGenerator() {
        return new SessionIdUserTokenGenerator();
    }
}

