/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.configuration;

import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.basic.configuration.BasicAuthorizationTokenParser;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationProperties;
import org.hswebframework.web.authorization.basic.embed.EmbedReactiveAuthenticationManager;
import org.hswebframework.web.authorization.basic.handler.AuthorizationLoginLoggerInfoHandler;
import org.hswebframework.web.authorization.basic.handler.DefaultAuthorizingHandler;
import org.hswebframework.web.authorization.basic.handler.UserAllowPermissionHandler;
import org.hswebframework.web.authorization.basic.web.AuthorizationController;
import org.hswebframework.web.authorization.basic.web.BearerTokenParser;
import org.hswebframework.web.authorization.basic.web.DefaultUserTokenGenPar;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenController;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.ReactiveUserTokenParser;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.basic.web.UserTokenWebFilter;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@AutoConfiguration
@EnableConfigurationProperties(value={EmbedAuthenticationProperties.class})
@Role(value=2)
public class AuthorizingHandlerAutoConfiguration {
    @Bean
    @Role(value=2)
    public DefaultAuthorizingHandler authorizingHandler() {
        return new DefaultAuthorizingHandler(null);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public UserTokenWebFilter userTokenWebFilter(UserTokenManager userTokenManager, ObjectProvider<ReactiveUserTokenParser> tokenParsers, ObjectProvider<ReactiveUserTokenGenerator> tokenGenerators) {
        UserTokenWebFilter filter = new UserTokenWebFilter(userTokenManager);
        tokenParsers.forEach(filter::register);
        tokenGenerators.forEach(filter::register);
        return filter;
    }

    @Bean
    public ReactiveAuthenticationManagerProvider embedAuthenticationManager(EmbedAuthenticationProperties properties) {
        return new EmbedReactiveAuthenticationManager(properties);
    }

    @Bean
    public UserAllowPermissionHandler userAllowPermissionHandler() {
        return new UserAllowPermissionHandler();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConfigurationProperties(prefix="hsweb.authorize.token.default")
    public DefaultUserTokenGenPar defaultUserTokenGenPar() {
        return new DefaultUserTokenGenPar();
    }

    @Bean
    public AuthorizationController authorizationController() {
        return new AuthorizationController();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public ReactiveUserTokenController userTokenController() {
        return new ReactiveUserTokenController();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public BearerTokenParser bearerTokenParser() {
        return new BearerTokenParser();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public AuthorizationLoginLoggerInfoHandler authorizationLoginLoggerInfoHandler() {
        return new AuthorizationLoginLoggerInfoHandler();
    }

    @Configuration
    @ConditionalOnProperty(prefix="hsweb.authorize", name={"basic-authorization"}, havingValue="true")
    @ConditionalOnClass(value={UserTokenForTypeParser.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class BasicAuthorizationConfiguration {
        @Bean
        public BasicAuthorizationTokenParser basicAuthorizationTokenParser(AuthenticationManager authenticationManager, UserTokenManager tokenManager) {
            return new BasicAuthorizationTokenParser(authenticationManager, tokenManager);
        }
    }
}

