/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.hswebframework.web.aop.MethodInterceptorContext;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionCustomizerParser;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.define.DefaultBasicAuthorizeDefinition;
import org.hswebframework.web.authorization.basic.define.EmptyAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.utils.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class DefaultAopMethodAuthorizeDefinitionParser
implements AopMethodAuthorizeDefinitionParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAopMethodAuthorizeDefinitionParser.class);
    private final Map<CacheKey, AuthorizeDefinition> cache = new ConcurrentHashMap<CacheKey, AuthorizeDefinition>();
    private List<AopMethodAuthorizeDefinitionCustomizerParser> parserCustomizers;
    private static final Set<String> excludeMethodName = new HashSet<String>(Arrays.asList("toString", "clone", "hashCode", "getClass"));

    @Autowired(required=false)
    public void setParserCustomizers(List<AopMethodAuthorizeDefinitionCustomizerParser> parserCustomizers) {
        this.parserCustomizers = parserCustomizers;
    }

    @Override
    public List<AuthorizeDefinition> getAllParsed() {
        return new ArrayList<AuthorizeDefinition>(this.cache.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizeDefinition parse(Class<?> target, Method method, MethodInterceptorContext context) {
        if (excludeMethodName.contains(method.getName())) {
            return null;
        }
        CacheKey key = this.buildCacheKey(target, method);
        AuthorizeDefinition definition = this.cache.get(key);
        if (definition instanceof EmptyAuthorizeDefinition) {
            return null;
        }
        if (null != definition) {
            return definition;
        }
        if (!CollectionUtils.isEmpty(this.parserCustomizers)) {
            definition = this.parserCustomizers.stream().map(customizer -> customizer.parse(target, method, context)).filter(Objects::nonNull).findAny().orElse(null);
            if (definition instanceof EmptyAuthorizeDefinition) {
                return null;
            }
            if (definition != null) {
                return definition;
            }
        }
        Authorize annotation = (Authorize)AnnotationUtils.findAnnotation(target, (Method)method, Authorize.class);
        if (DefaultAopMethodAuthorizeDefinitionParser.isIgnoreMethod(method) || annotation != null && annotation.ignore()) {
            this.cache.put(key, (AuthorizeDefinition)EmptyAuthorizeDefinition.instance);
            return null;
        }
        Map<CacheKey, AuthorizeDefinition> map = this.cache;
        synchronized (map) {
            return this.cache.computeIfAbsent(key, __ -> DefaultBasicAuthorizeDefinition.from(target, method));
        }
    }

    CacheKey buildCacheKey(Class<?> target, Method method) {
        return new CacheKey(ClassUtils.getUserClass(target), method);
    }

    public void destroy() {
        this.cache.clear();
    }

    static boolean isIgnoreMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return true;
        }
        return null == AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class) && null == AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResourceAction.class);
    }

    static class CacheKey {
        private final Class<?> type;
        private final Method method;

        public CacheKey(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Method this$method = this.method;
            Method other$method = other.method;
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Method $method = this.method;
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }
    }
}

