/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging;

import java.util.Optional;
import org.hswebframework.web.logging.AccessLoggerInfo;
import reactor.core.publisher.Mono;

public class AccessLoggerHolder {
    static final ThreadLocal<AccessLoggerInfo> HOLDER = new ThreadLocal();

    public static Mono<AccessLoggerInfo> currentReactive() {
        return Mono.deferContextual(ctx -> Mono.justOrEmpty(ctx.getOrEmpty(AccessLoggerInfo.class).or(AccessLoggerHolder::current)));
    }

    public static Optional<AccessLoggerInfo> current() {
        return Optional.ofNullable(HOLDER.get());
    }

    public static void set(AccessLoggerInfo info) {
        HOLDER.set(info);
    }

    public static void remove() {
        HOLDER.remove();
    }
}

