/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.security.rsa;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.expands.security.rsa.DefaultEncrypt;

public class RSAPublicEncrypt
extends DefaultEncrypt {
    private byte[] publicKey;

    public RSAPublicEncrypt(RSAPublicKey publicKey) {
        this.publicKey = Base64.encodeBase64((byte[])publicKey.getEncoded());
    }

    public RSAPublicEncrypt(String publicKey) {
        this.publicKey = publicKey.getBytes();
    }

    public RSAPublicEncrypt(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getKey() {
        return new String(this.publicKey);
    }

    @Override
    protected EncodedKeySpec encodedKeySpec(byte[] keyBytes) {
        return new X509EncodedKeySpec(keyBytes);
    }

    public boolean verify(String sign, byte[] data) {
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])this.publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicK = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(publicK);
            signature.update(data);
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

