/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.script.engine.SpEL;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.ExecuteResult;
import org.hswebframework.expands.script.engine.ListenerSupportEngine;
import org.hswebframework.expands.script.engine.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpElEngine
extends ListenerSupportEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, SpelScriptContext> cache = new ConcurrentHashMap<String, SpelScriptContext>();
    protected final ExpressionParser parser = new SpelExpressionParser();
    private List<ContextCall> contextCalls = new ArrayList<ContextCall>();

    @Override
    public boolean compiled(String id) {
        return this.cache.containsKey(id);
    }

    @Override
    public void init(String ... contents) throws Exception {
    }

    @Override
    public boolean remove(String id) {
        return this.cache.remove(id) != null;
    }

    @Override
    public ScriptContext getContext(String id) {
        return this.cache.get(id);
    }

    @Override
    public boolean compile(String id, String code) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("compile SpEL {} : {}", (Object)id, (Object)code);
        }
        this.cache.put(id, new SpelScriptContext(id, DigestUtils.md5Hex((String)code), this.parser.parseExpression(code)));
        return false;
    }

    @Override
    public ExecuteResult execute(String id) {
        return this.execute(id, new HashMap<String, Object>());
    }

    @Override
    public ExecuteResult execute(String id, Map<String, Object> param) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute SpEL {} : {}", (Object)id, param);
        }
        ExecuteResult result = new ExecuteResult();
        long start = System.currentTimeMillis();
        SpelScriptContext scriptContext = this.cache.get(id);
        try {
            if (scriptContext != null) {
                this.doListenerBefore(scriptContext);
                scriptContext = this.cache.get(id);
                param = new HashMap<String, Object>(param);
                param.putAll(this.getGlobalVariable());
                StandardEvaluationContext context = new StandardEvaluationContext(param);
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    context.setVariable(entry.getKey(), entry.getValue());
                }
                this.contextCalls.forEach(contextCall -> contextCall.init(context));
                Object obj = scriptContext.getScript().getValue((EvaluationContext)context);
                result.setSuccess(true);
                result.setResult(obj);
            } else {
                result.setSuccess(false);
                result.setResult(null);
                result.setMessage(String.format("SpEL: %s not found!", id));
            }
            long end = System.currentTimeMillis();
            result.setUseTime(end - start);
        }
        catch (Exception e) {
            result.setException(e);
        }
        this.doListenerAfter(scriptContext, result);
        return result;
    }

    public void addContextCall(ContextCall contextCall) {
        this.contextCalls.add(contextCall);
    }

    class SpelScriptContext
    extends ScriptContext {
        private Expression script;

        public SpelScriptContext(String id, String md5, Expression script) {
            super(id, md5);
            this.script = script;
        }

        public Expression getScript() {
            return this.script;
        }
    }

    public static interface ContextCall {
        public void init(StandardEvaluationContext var1);
    }
}

