/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Clob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Type;

public final class ClobType
extends CharacterType {
    public static final long maxClobPrecision = 0x10000000000L;
    public static final int defaultClobSize = 0x1000000;

    public ClobType(long l) {
        super(40, l);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return 2005;
    }

    public Class getJDBCClass() {
        return Clob.class;
    }

    public String getJDBCClassName() {
        return "java.sql.Clob";
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public String getDefinition() {
        long l = this.precision;
        String string = null;
        if (this.precision % 1024L == 0L) {
            if (this.precision % 0x40000000L == 0L) {
                l = this.precision / 0x40000000L;
                string = "G";
            } else if (this.precision % 0x100000L == 0L) {
                l = this.precision / 0x100000L;
                string = "M";
            } else {
                l = this.precision / 1024L;
                string = "K";
            }
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.getNameString());
        stringBuffer.append('(');
        stringBuffer.append(l);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    public boolean isLobType() {
        return true;
    }

    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof String) {
            return session.database.lobManager.compare((ClobData)object, (String)object2);
        }
        return session.database.lobManager.compare((ClobData)object, (ClobData)object2);
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClobData) {
            return object;
        }
        if (object instanceof String) {
            ClobDataID clobDataID = sessionInterface.createClob(((String)object).length());
            clobDataID.setString(sessionInterface, 0L, (String)object);
            return clobDataID;
        }
        throw Error.error(5561);
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return ((ClobData)object).toString();
    }

    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        String string = this.convertToString(object);
        return StringConverter.toQuotedString(string, '\'', true);
    }

    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JDBCClobClient) {
            return ((JDBCClobClient)object).getClob();
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            ClobDataID clobDataID = (ClobDataID)object;
            return new JDBCClobClient(sessionInterface, clobDataID);
        }
        throw Error.error(5561);
    }

    public long position(SessionInterface sessionInterface, Object object, Object object2, Type type, long l) {
        if (type.typeCode == 40) {
            return ((ClobData)object).position(sessionInterface, (ClobData)object2, l);
        }
        if (type.isCharacterType()) {
            return ((ClobData)object).position(sessionInterface, (String)object2, l);
        }
        throw Error.runtimeError(201, "ClobType");
    }
}

