/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobType;
import org.hsqldb.types.Type;

public class BinaryType
extends Type {
    static final long maxBinaryPrecision = Integer.MAX_VALUE;

    protected BinaryType(int n, long l) {
        super(61, n, l, 0);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return this.typeCode == 60 ? -2 : -3;
    }

    public Class getJDBCClass() {
        return byte[].class;
    }

    public String getJDBCClassName() {
        return "[B";
    }

    public String getNameString() {
        return this.typeCode == 60 ? "BINARY" : "VARBINARY";
    }

    public String getNameFullString() {
        return this.typeCode == 60 ? "BINARY" : "BINARY VARYING";
    }

    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.getNameString());
        stringBuffer.append('(');
        stringBuffer.append(this.precision);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean acceptsPrecision() {
        return true;
    }

    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    public boolean requiresPrecision() {
        return this.typeCode == 61;
    }

    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            return 0;
        }
        if (!type.isBinaryType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 14: 
            case 15: {
                return Integer.MIN_VALUE;
            }
            case 60: {
                return type.typeCode == 30 ? 4 : 2;
            }
            case 61: {
                return type.typeCode == 30 ? 4 : 2;
            }
            case 30: {
                return type.typeCode == 60 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    public Type getAggregateType(Type type) {
        if (this.typeCode == type.typeCode) {
            return this.precision >= type.precision ? this : type;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 14: 
            case 15: {
                long l = (type.precision + 7L) / 8L;
                return this.precision >= l ? this : BinaryType.getBinaryType(this.typeCode, l);
            }
            case 60: {
                return this.precision >= type.precision ? this : BinaryType.getBinaryType(this.typeCode, type.precision);
            }
            case 61: {
                if (this.typeCode == 30) {
                    return this.precision >= type.precision ? this : BinaryType.getBinaryType(this.typeCode, type.precision);
                }
                return type.precision >= this.precision ? type : BinaryType.getBinaryType(type.typeCode, this.precision);
            }
            case 30: {
                return type.precision >= this.precision ? type : BinaryType.getBinaryType(type.typeCode, this.precision);
            }
        }
        throw Error.error(5562);
    }

    public Type getCombinedType(Type type, int n) {
        Type type2;
        if (n != 36) {
            return this.getAggregateType(type);
        }
        long l = this.precision + type.precision;
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 14: 
            case 15: {
                l = this.precision + (type.precision + 7L) / 8L;
                type2 = this;
                break;
            }
            case 60: {
                type2 = this;
                break;
            }
            case 61: {
                type2 = this.typeCode == 30 ? this : type;
                break;
            }
            case 30: {
                type2 = type;
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        if (l > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                throw Error.error(5570);
            }
            if (this.typeCode == 61) {
                l = Integer.MAX_VALUE;
            }
        }
        return BinaryType.getBinaryType(type2.typeCode, l);
    }

    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof BinaryData && object2 instanceof BinaryData) {
            byte[] byArray;
            byte[] byArray2 = ((BinaryData)object).getBytes();
            int n = byArray2.length > (byArray = ((BinaryData)object2).getBytes()).length ? byArray.length : byArray2.length;
            for (int i = 0; i < n; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                return (byArray2[i] & 0xFF) > (byArray[i] & 0xFF) ? 1 : -1;
            }
            if (byArray2.length == byArray.length) {
                return 0;
            }
            return byArray2.length > byArray.length ? 1 : -1;
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return this.castOrConvertToType(sessionInterface, object, this, false);
    }

    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, true);
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        return ((BlobData)object).getBytes();
    }

    Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        BlobData blobData;
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                blobData = sessionInterface.getScanner().convertToBinary((String)object);
                type = BinaryType.getBinaryType(61, blobData.length(sessionInterface));
                break;
            }
            case 14: {
                blobData = (BlobData)object;
                type = BinaryType.getBinaryType(61, blobData.length(sessionInterface));
                break;
            }
            case 30: 
            case 60: 
            case 61: {
                blobData = (BlobData)object;
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (this.precision == 0L) {
            return blobData;
        }
        if (blobData.length(sessionInterface) > this.precision && blobData.nonZeroLength(sessionInterface) > this.precision) {
            if (!bl) {
                throw Error.error(3401);
            }
            sessionInterface.addWarning(Error.error(1004));
        }
        if (type.typeCode == 30) {
            long l = blobData.length(sessionInterface);
            if (l > this.precision) {
                throw Error.error(3471);
            }
            byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)l);
            blobData = new BinaryData(byArray, false);
        }
        switch (this.typeCode) {
            case 60: {
                if (blobData.length(sessionInterface) > this.precision) {
                    byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                } else if (blobData.length(sessionInterface) < this.precision) {
                    byte[] byArray = (byte[])ArrayUtil.resizeArray(blobData.getBytes(), (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                }
                return blobData;
            }
            case 61: {
                if (blobData.length(sessionInterface) > this.precision) {
                    byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)this.precision);
                    blobData = new BinaryData(byArray, false);
                }
                return blobData;
            }
        }
        throw Error.error(3471);
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, false);
        }
        if (object instanceof BinaryData) {
            return object;
        }
        if (object instanceof String) {
            return this.castOrConvertToType(sessionInterface, object, Type.SQL_VARCHAR, false);
        }
        throw Error.error(3471);
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((BlobData)object).getBytes());
    }

    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((BinaryData)object).getBytes());
    }

    public boolean canConvertFrom(Type type) {
        return type.typeCode == 0 || type.isBinaryType() || type.isCharacterType();
    }

    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (!type.isBinaryType()) {
            return -1;
        }
        switch (this.typeCode) {
            case 61: {
                if (type.typeCode == this.typeCode) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                if (type.typeCode == 60) {
                    return this.precision >= type.precision ? 0 : -1;
                }
                return -1;
            }
            case 30: {
                if (type.typeCode == this.typeCode) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                return -1;
            }
            case 14: 
            case 60: {
                return type.typeCode == this.typeCode && this.precision == type.precision ? 0 : -1;
            }
            case 15: {
                return type.typeCode == this.typeCode && this.precision >= type.precision ? 0 : -1;
            }
        }
        return -1;
    }

    public long position(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2, Type type, long l) {
        if (blobData == null || blobData2 == null) {
            return -1L;
        }
        long l2 = blobData.length(sessionInterface);
        if (l + l2 > blobData.length(sessionInterface)) {
            return -1L;
        }
        return blobData.position(sessionInterface, blobData2, l);
    }

    public BlobData substring(SessionInterface sessionInterface, BlobData blobData, long l, long l2, boolean bl) {
        long l3;
        long l4 = blobData.length(sessionInterface);
        if (bl) {
            l3 = l + l2;
        } else {
            long l5 = l3 = l4 > l ? l4 : l;
        }
        if (l > l3) {
            throw Error.error(3431);
        }
        if (l > l3 || l3 < 0L) {
            l = 0L;
            l3 = 0L;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l3 > l4) {
            l3 = l4;
        }
        l2 = l3 - l;
        byte[] byArray = blobData.getBytes(sessionInterface, l, (int)l2);
        return new BinaryData(byArray, false);
    }

    int getRightTrimSize(BlobData blobData) {
        byte[] byArray = blobData.getBytes();
        int n = byArray.length;
        --n;
        while (n >= 0 && byArray[n] == 0) {
            --n;
        }
        return ++n;
    }

    public BlobData trim(Session session, BlobData blobData, int n, boolean bl, boolean bl2) {
        int n2;
        if (blobData == null) {
            return null;
        }
        byte[] byArray = blobData.getBytes();
        int n3 = byArray.length;
        if (bl2) {
            --n3;
            while (n3 >= 0 && byArray[n3] == n) {
                --n3;
            }
            ++n3;
        }
        if (bl) {
            for (n2 = 0; n2 < n3 && byArray[n2] == n; ++n2) {
            }
        }
        byte[] byArray2 = byArray;
        if (n2 != 0 || n3 != byArray.length) {
            byArray2 = new byte[n3 - n2];
            System.arraycopy(byArray, n2, byArray2, 0, n3 - n2);
        }
        if (this.typeCode == 30) {
            BlobDataID blobDataID = session.createBlob(byArray2.length);
            blobDataID.setBytes(session, 0L, byArray2);
            return blobDataID;
        }
        return new BinaryData(byArray2, byArray2 == byArray);
    }

    public BlobData overlay(Session session, BlobData blobData, BlobData blobData2, long l, long l2, boolean bl) {
        if (blobData == null || blobData2 == null) {
            return null;
        }
        if (!bl) {
            l2 = blobData2.length(session);
        }
        switch (this.typeCode) {
            case 60: 
            case 61: {
                BinaryData binaryData = new BinaryData(session, this.substring(session, blobData, 0L, l, true), blobData2);
                binaryData = new BinaryData(session, binaryData, this.substring(session, blobData, l + l2, 0L, false));
                return binaryData;
            }
            case 30: {
                byte[] byArray = this.substring(session, blobData, 0L, l, false).getBytes();
                long l3 = blobData.length(session) + blobData2.length(session) - l2;
                BlobDataID blobDataID = session.createBlob(l3);
                blobDataID.setBytes(session, 0L, byArray);
                blobDataID.setBytes(session, blobDataID.length(session), blobData2.getBytes());
                byArray = this.substring(session, blobData, l + l2, 0L, false).getBytes();
                blobDataID.setBytes(session, blobDataID.length(session), byArray);
                return blobDataID;
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }

    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        long l = ((BlobData)object).length(session) + ((BlobData)object2).length(session);
        if (l > this.precision) {
            throw Error.error(3401);
        }
        if (this.typeCode == 30) {
            BlobDataID blobDataID = session.createBlob(l);
            blobDataID.setBytes(session, 0L, ((BlobData)object2).getBytes());
            blobDataID.setBytes(session, ((BlobData)object).length(session), ((BlobData)object2).getBytes());
            return blobDataID;
        }
        return new BinaryData(session, (BlobData)object, (BlobData)object2);
    }

    public static BinaryType getBinaryType(int n, long l) {
        switch (n) {
            case 60: 
            case 61: {
                return new BinaryType(n, l);
            }
            case 30: {
                return new BlobType(l);
            }
        }
        throw Error.runtimeError(201, "BinaryType");
    }
}

