/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;

    public RowStoreAVLDisk(PersistentStoreCollection persistentStoreCollection, DataFileCache dataFileCache, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = dataFileCache;
        if (dataFileCache != null) {
            this.rowOut = dataFileCache.rowOut.duplicate();
            dataFileCache.adjustStoreCount(1);
        }
        persistentStoreCollection.setStore(table, this);
    }

    public boolean isMemory() {
        return false;
    }

    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    public void set(CachedObject cachedObject) {
        Row row = (Row)cachedObject;
        this.database.txManager.setTransactionInfo(row);
    }

    public CachedObject get(int n) {
        CachedObject cachedObject = this.cache.get(n, (PersistentStore)this, false);
        return cachedObject;
    }

    public CachedObject get(int n, boolean bl) {
        CachedObject cachedObject = this.cache.get(n, (PersistentStore)this, bl);
        return cachedObject;
    }

    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    public int getStorageSize(int n) {
        return this.cache.get(n, (PersistentStore)this, false).getStorageSize();
    }

    public void add(CachedObject cachedObject) {
        int n = cachedObject.getRealSize(this.rowOut);
        n += this.indexList.length * 16;
        n = this.rowOut.getStorageSize(n);
        cachedObject.setStorageSize(n);
        this.cache.add(cachedObject);
    }

    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            return new RowAVLDisk(this.table, rowInputInterface);
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    public CachedObject getNewInstance(int n) {
        return null;
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDisk rowAVLDisk = new RowAVLDisk(this.table, (Object[])object, this);
        this.add(rowAVLDisk);
        if (bl) {
            RowAction rowAction;
            rowAVLDisk.rowAction = rowAction = new RowAction(session, this.table, 1, rowAVLDisk, null);
        }
        return rowAVLDisk;
    }

    public void indexRow(Session session, Row row) {
        try {
            super.indexRow(session, row);
        }
        catch (HsqlException hsqlException) {
            this.database.txManager.removeTransactionInfo(row);
            throw hsqlException;
        }
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int n) {
        this.cache.remove(n, this);
    }

    public void removePersistence(int n) {
    }

    public void release(int n) {
        this.cache.release(n);
    }

    public void commitPersistence(CachedObject cachedObject) {
    }

    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    public DataFileCache getCache() {
        return this.cache;
    }

    public void setCache(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache.adjustStoreCount(-1);
        this.cache = null;
    }

    public CachedObject getAccessor(Index index) {
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[index.getPosition()];
        if (nodeAVL == null) {
            return null;
        }
        if (!nodeAVL.isInMemory()) {
            RowAVL rowAVL = (RowAVL)this.get(nodeAVL.getPos(), false);
            nodeAVL = rowAVL.getNode(index.getPosition());
            this.accessorList[index.getPosition()] = nodeAVL;
        }
        return nodeAVL;
    }

    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    public void setAccessor(Index index, int n) {
        CachedObject cachedObject = this.get(n, false);
        if (cachedObject != null) {
            NodeAVL nodeAVL = ((RowAVL)cachedObject).getNode(index.getPosition());
            cachedObject = nodeAVL;
        }
        this.setAccessor(index, cachedObject);
    }

    public void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    public void writeLock() {
        this.cache.writeLock.lock();
    }

    public void writeUnlock() {
        this.cache.writeLock.unlock();
    }
}

