/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public DataFileCacheSession(Database database, String string) {
        super(database, string);
    }

    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.cachedRowPadding = this.cacheFileScale = 64;
        this.initialFreePos = this.cacheFileScale;
        this.maxCacheRows = 2048;
        this.maxCacheBytes = this.maxCacheRows * 1024;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.dataFile = null;
    }

    public void open(boolean bl) {
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, false, 0);
            this.fileFreePosition = this.initialFreePos;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0L);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to open RA file", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    public void close(boolean bl) {
        this.writeLock.lock();
        try {
            block4: {
                try {
                    this.cache.clear();
                    if (this.dataFile == null) break block4;
                    this.dataFile.close();
                    this.dataFile = null;
                    this.fa.removeElement(this.dataFileName);
                }
                catch (Throwable throwable) {
                    this.database.logger.logWarningEvent("Failed to close RA file", throwable);
                    throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
                }
            }
            Object var4_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }
}

