/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class Util {
    static final void throwError(HsqlException hsqlException) throws SQLException {
        SQLException sQLException = new SQLException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode());
        sQLException.initCause(hsqlException);
        throw sQLException;
    }

    static final void throwError(Result result) throws SQLException {
        SQLException sQLException = new SQLException(result.getMainString(), result.getSubString(), result.getErrorCode());
        if (result.getException() != null) {
            sQLException.initCause(result.getException());
        }
        throw sQLException;
    }

    public static final SQLException sqlException(HsqlException hsqlException) {
        SQLException sQLException = new SQLException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode());
        sQLException.initCause(hsqlException);
        return sQLException;
    }

    public static final SQLException sqlException(HsqlException hsqlException, Throwable throwable) {
        SQLException sQLException = new SQLException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode());
        if (throwable != null) {
            sQLException.initCause(throwable);
        }
        return sQLException;
    }

    public static final SQLException sqlException(int n) {
        return Util.sqlException(Error.error(n));
    }

    public static final SQLException sqlExceptionSQL(int n) {
        return Util.sqlException(Error.error(n));
    }

    public static final SQLException sqlException(int n, String string) {
        return Util.sqlException(Error.error(n, string));
    }

    public static final SQLException sqlException(int n, String string, Exception exception) {
        return Util.sqlException(Error.error(n, string), exception);
    }

    public static final SQLException sqlException(int n, int n2) {
        return Util.sqlException(Error.error(n, n2));
    }

    static final SQLException sqlException(int n, int n2, Object[] objectArray) {
        return Util.sqlException(Error.error(null, n, n2, objectArray));
    }

    static final SQLException notSupported() {
        return Util.sqlException(Error.error(1500));
    }

    static SQLException notUpdatableColumn() {
        return Util.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return Util.sqlException(423);
    }

    static SQLException nullArgument(String string) {
        return Util.sqlException(423, string + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(423);
    }

    public static SQLException invalidArgument(String string) {
        return Util.sqlException(423, string);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String string) {
        return Util.sqlException(423, string);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result result) {
        return new SQLWarning(result.getMainString(), result.getSubString(), result.getErrorCode());
    }

    public static SQLException sqlException(Throwable throwable) {
        return new SQLException(throwable.getMessage(), Error.getStateString(458), 458);
    }

    public static SQLException sqlException(Result result) {
        SQLException sQLException = new SQLException(result.getMainString(), result.getSubString(), result.getErrorCode());
        if (result.getException() != null) {
            sQLException.initCause(result.getException());
        }
        return sQLException;
    }
}

