/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.hsqldb.ClientConnection;
import org.hsqldb.ClientConnectionHTTP;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.ResultProperties;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    HsqlProperties connProperties;
    HsqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;

    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int n = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement jDBCStatement = new JDBCStatement(this, n);
        return jDBCStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string, 1003, 1007, this.rsHoldability);
            return jDBCCallableStatement;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = null;
        int n4 = 0;
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.length());
                    }
                    stringBuffer.append(string.substring(n4, i));
                    n4 = i = this.onStartEscapeSequence(string, stringBuffer, i);
                    bl = true;
                    ++n3;
                    n = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --n;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    n -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        stringBuffer.append(string.substring(n4, i));
                        stringBuffer.append(' ');
                        n4 = ++i;
                        bl = true;
                        n = --n3 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    stringBuffer.append(string.substring(n4, i));
                    n4 = i = this.onStartEscapeSequence(string, stringBuffer, i);
                    bl = true;
                    ++n3;
                    n = 3;
                }
            }
        }
        if (!bl) {
            return string;
        }
        stringBuffer.append(string.substring(n4, string.length()));
        return stringBuffer.toString();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, string);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        int n3 = ResultProperties.getValueForJDBC(n, n2, this.rsHoldability);
        return new JDBCStatement(this, n3);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n, n2, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n, n2, this.rsHoldability);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public synchronized void setHoldability(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        this.rsHoldability = n;
    }

    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        JDBCSavepoint jDBCSavepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
        return jDBCSavepoint;
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw Util.nullArgument();
        }
        if (string.startsWith("SYSTEM_SAVEPOINT_")) {
            throw Util.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(string);
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
        return new JDBCSavepoint(string, this);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = Error.getMessage(4821);
            throw Util.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (this != jDBCSavepoint.connection) {
            String string = Error.getMessage(4821);
            throw Util.invalidArgument(string);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = Error.getMessage(4821);
            throw Util.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (this != jDBCSavepoint.connection) {
            String string = Error.getMessage(4821);
            throw Util.invalidArgument(string);
        }
        try {
            this.sessionProxy.releaseSavepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        int n4 = ResultProperties.getValueForJDBC(n, n2, n3);
        return new JDBCStatement(this, n4);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n, n2, n3, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n, n2, n3);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkClosed();
        try {
            if (n != 1 && n != 2) {
                throw Util.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, n, null, null);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 21, nArray, null);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 11, null, stringArray);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    public void setSchema(String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            Util.nullArgument("schema");
        } else if (string.length() == 0) {
            Util.invalidArgument("Zero-length schema");
        } else {
            new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(string);
        }
    }

    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw Util.nullArgument("executor");
        }
        this.close();
    }

    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public JDBCConnection(HsqlProperties hsqlProperties) throws SQLException {
        boolean bl;
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl2 = bl = string3 == "hsqls://" || string3 == "https://";
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = HsqlDateTime.getZoneSeconds(calendar);
        try {
            if (DatabaseURL.isInProcessDatabaseType(string3)) {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, hsqlProperties, null, n2);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new ClientConnection(string4, n, string5, string6, bl, string, string2, n2);
                this.isNetConn = true;
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new ClientConnectionHTTP(string4, n, string5, string6, bl, string, string2, n2);
                this.isNetConn = true;
            } else {
                throw Util.invalidArgument(string3);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = hsqlProperties;
            this.clientProperties = this.sessionProxy.getClientProperties();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public JDBCConnection(SessionInterface sessionInterface) {
        this.isInternal = true;
        this.sessionProxy = sessionInterface;
    }

    public JDBCConnection(JDBCConnection jDBCConnection, JDBCConnectionEventListener jDBCConnectionEventListener) {
        this.sessionProxy = jDBCConnection.sessionProxy;
        this.connProperties = jDBCConnection.connProperties;
        this.clientProperties = jDBCConnection.clientProperties;
        this.isPooled = true;
        this.poolEventListener = jDBCConnectionEventListener;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = sQLWarning;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(1305, hsqlException.getMessage(), hsqlException);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String string, StringBuffer stringBuffer, int n) throws SQLException {
        stringBuffer.append(' ');
        ++n;
        n = StringUtil.skipSpaces(string, n);
        if (string.regionMatches(true, n, "fn ", 0, 3) || string.regionMatches(true, n, "oj ", 0, 3)) {
            n += 2;
        } else if (string.regionMatches(true, n, "ts ", 0, 3)) {
            stringBuffer.append("TIMESTAMP");
            n += 2;
        } else if (string.regionMatches(true, n, "d ", 0, 2)) {
            stringBuffer.append("DATE");
            ++n;
        } else if (string.regionMatches(true, n, "t ", 0, 2)) {
            stringBuffer.append("TIME");
            ++n;
        } else if (string.regionMatches(true, n, "call ", 0, 5)) {
            stringBuffer.append("CALL");
            n += 4;
        } else if (string.regionMatches(true, n, "?= call ", 0, 8)) {
            stringBuffer.append("CALL");
            n += 7;
        } else if (string.regionMatches(true, n, "? = call ", 0, 8)) {
            stringBuffer.append("CALL");
            n += 8;
        } else if (string.regionMatches(true, n, "escape ", 0, 7)) {
            n += 6;
        } else {
            throw Util.sqlException(Error.error(425, string.substring(--n)));
        }
        return n;
    }
}

