/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.Util;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCArray
implements Array {
    volatile boolean closed;
    Type arrayType;
    Type elementType;
    Object[] data;
    JDBCConnection connection;
    SessionInterface sessionProxy;

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkClosed();
        Object[] objectArray = new Object[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            objectArray[i] = this.elementType.convertSQLToJava(this.sessionProxy, this.data[i]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, l - 1L, n)) {
            throw Util.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.elementType.convertSQLToJava(this.sessionProxy, this.data[(int)l + i - 1]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(l, n);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(0L, this.data.length);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(l - 1L, n);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(l, n);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.connection = null;
            this.sessionProxy = null;
        }
    }

    public JDBCArray(Object[] objectArray, Type type, Type type2, SessionInterface sessionInterface) {
        this(objectArray, type, type2, sessionInterface.getJDBCConnection());
        this.sessionProxy = sessionInterface;
    }

    JDBCArray(Object[] objectArray, Type type, JDBCConnection jDBCConnection) throws SQLException {
        this(objectArray, type, null, jDBCConnection);
    }

    JDBCArray(Object[] objectArray, Type type, Type type2, JDBCConnection jDBCConnection) {
        this.data = objectArray;
        this.elementType = type;
        this.arrayType = type2;
        this.connection = jDBCConnection;
        this.sessionProxy = jDBCConnection.sessionProxy;
    }

    public Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long l, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, l, n)) {
            throw Util.outOfRangeArgument();
        }
        Type[] typeArray = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData resultMetaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        resultMetaData.columnLabels = new String[]{"C1", "C2"};
        resultMetaData.colIndexes = new int[]{-1, -1};
        resultMetaData.columns = new ColumnBase[2];
        ColumnBase columnBase = new ColumnBase("", "", "", "");
        columnBase.setType(typeArray[0]);
        resultMetaData.columns[0] = columnBase;
        columnBase = new ColumnBase("", "", "", "");
        columnBase.setType(typeArray[1]);
        resultMetaData.columns[1] = columnBase;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
        int n2 = (int)l;
        while ((long)n2 < l + (long)n) {
            Object[] objectArray = new Object[]{n2 + 1, this.data[n2]};
            rowSetNavigatorClient.add(objectArray);
            ++n2;
        }
        Result result = Result.newDataResult(resultMetaData);
        result.setNavigator(rowSetNavigatorClient);
        return result;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw Util.sqlException(1251);
        }
    }
}

