/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();

    public TransactionManagerMV2PL(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 1;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{this.database.getCatalogName()};
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return true;
    }

    public boolean isMVCC() {
        return false;
    }

    public int getTransactionControl() {
        return 1;
    }

    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareCommitActions(Session session) {
        Object[] objectArray = session.rowActionList.getArray();
        int n = session.rowActionList.size();
        this.writeLock.lock();
        try {
            int n2;
            session.actionTimestamp = this.nextChangeTimestamp();
            for (n2 = 0; n2 < n; n2 += 1) {
                RowAction rowAction = (RowAction)objectArray[n2];
                rowAction.prepareCommit(session);
            }
            n2 = 1;
            Object var7_6 = null;
            this.writeLock.unlock();
            return n2 != 0;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int n = session.rowActionList.size();
        Object[] objectArray = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            int n2;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (n2 = 0; n2 < n; ++n2) {
                RowAction rowAction = (RowAction)objectArray[n2];
                rowAction.commit(session);
            }
            this.persistCommit(session, objectArray, n);
            n2 = session.rowActionList.size();
            if (n2 > n) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(session, objectArray, n, n2, session.actionTimestamp);
                this.finaliseRows(session, objectArray, n, n2, true);
                session.rowActionList.setSize(n);
            }
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp || session == this.lobSession) {
                this.mergeTransaction(session, objectArray, 0, n, session.actionTimestamp);
                this.finaliseRows(session, objectArray, 0, n, true);
            } else {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            this.endTransactionTPL(session);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int n, long l) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction != null) {
                rowAction.rollback(session, l);
                continue;
            }
            System.out.println("null action in rollback " + n);
        }
        this.mergeRolledBackTransaction(session, l, objectArray, n, n2);
        this.finaliseRows(session, objectArray, n, n2, false);
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction;
        boolean bl;
        Row row2 = row;
        synchronized (row2) {
            bl = row.rowAction == null;
            rowAction = RowAction.addDeleteAction(session, table, row, nArray);
        }
        session.rowActionList.add(rowAction);
        if (bl && table.tableType == 5) {
            this.rowActionMap.put(rowAction.getPos(), rowAction);
        }
        return rowAction;
    }

    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        if (table.tableType == 5) {
            this.rowActionMap.put(rowAction.getPos(), rowAction);
        }
        persistentStore.indexRow(session, row);
        session.rowActionList.add(rowAction);
    }

    public boolean canRead(Session session, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, 0);
    }

    public boolean canRead(Session session, int n, int n2) {
        RowAction rowAction = (RowAction)this.rowActionMap.get(n);
        return rowAction == null ? true : rowAction.canRead(session, 0);
    }

    public void setTransactionInfo(CachedObject cachedObject) {
        RowAction rowAction;
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        row.rowAction = rowAction = (RowAction)this.rowActionMap.get(row.position);
    }

    public void removeTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        this.rowActionMap.remove(cachedObject.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long l2 = 0L;
            Object[] objectArray = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionTimestamps.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
                session.isTransaction = true;
                ++this.transactionCount;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAction(Session session, Statement statement) {
        if (session.hasLocks(statement)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean bl;
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    Object var5_3 = null;
                    this.writeLock.unlock();
                    return;
                }
            }
            if (bl = this.setWaitedSessionsTPL(session, statement)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var5_4 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
                ++this.transactionCount;
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    void endTransaction(Session session) {
        long l = session.transactionTimestamp;
        session.isTransaction = false;
        int n = this.liveTransactionTimestamps.indexOf(l);
        if (n >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }

    public DoubleIntIndex getTransactionIDList() {
        return super.getTransactionIDList();
    }

    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
        super.convertTransactionIDs(doubleIntIndex);
    }
}

